/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vmanager;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jenkinsci.plugins.vmanager.SessionStatusHolder;
import org.jenkinsci.plugins.vmanager.StepHolder;
import org.jenkinsci.plugins.vmanager.UnitTestFormatter;
import org.jenkinsci.plugins.vmanager.Utils;

public class LaunchHolder {
    private StepHolder stepHolder = null;
    private List<String> listOfSessions = null;
    private List<String> listOfSessionsForCountDown = null;
    private static long TIME_TO_SLEEP = 60000L;
    private static final String postData1 = "{\"filter\":{\"attName\":\"id\",\"operand\":\"EQUALS\",\"@c\":\".AttValueFilter\",\"attValue\":\"";
    private static final String postData2 = "\"},\"projection\": {\"type\":\"SELECTION_ONLY\",\"selection\":[\"session_status\",\"name\",\"running\",\"waiting\"]}}";
    private static final String runsList = "{\"filter\":{\"condition\":\"AND\",\"@c\":\".ChainedFilter\",\"chain\":[{\"@c\":\".RelationFilter\",\"relationName\":\"session\",\"filter\":{\"condition\":\"AND\",\"@c\":\".ChainedFilter\",\"chain\":[{\"@c\":\".InFilter\",\"attName\":\"id\",\"operand\":\"IN\",\"values\":[\"######\"]}]}}]},\"pageLength\":100000,\"settings\":{\"write-hidden\":true,\"stream-mode\":true},\"projection\": {\"type\": \"SELECTION_ONLY\",\"selection\":[\"test_name\",\"status\",\"duration\",\"test_group\",\"computed_seed\",\"id\",\"first_failure_name\",\"first_failure_description\"###ATTR###]}}";
    private FilePath filePath = null;
    private Utils utils = null;
    Map<String, String> extraAttrLabels = new HashMap<String, String>();
    Map<String, String> sessionFinalState = new HashMap<String, String>();

    public LaunchHolder(StepHolder stepHolder, List<String> listOfSessions, Utils utilsInstance) {
        this.stepHolder = stepHolder;
        this.listOfSessions = listOfSessions;
        this.utils = utilsInstance;
        this.listOfSessionsForCountDown = new ArrayList<String>();
        Iterator<String> iter = listOfSessions.iterator();
        while (iter.hasNext()) {
            this.listOfSessionsForCountDown.add(iter.next());
        }
    }

    public StepHolder getStepHolder() {
        return this.stepHolder;
    }

    public void setStepHolder(StepHolder stepHolder) {
        this.stepHolder = stepHolder;
    }

    public List<String> getListOfSessions() {
        return this.listOfSessions;
    }

    public void setListOfSessions(List<String> listOfSessions) {
        this.listOfSessions = listOfSessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performWaiting(String url, boolean requireAuth, String user, String password, TaskListener listener, boolean dynamicUserId, String buildID, int buildNumber, String workPlacePath, int connConnTimeOut, int connReadTimeout, boolean advConfig, boolean notInTestMode, String workingJobDir, Launcher launcher) throws Exception {
        String requestMethod = "POST";
        String apiURL = url + "/rest/sessions/list";
        boolean keepWaiting = true;
        HttpURLConnection conn = null;
        long startTime = new Date().getTime();
        long startTimeForDebugInfo = new Date().getTime();
        long timeToWaitOverall = (long)this.stepHolder.getStepSessionTimeout() * 60L * 1000L;
        long timeBetweenPrintStatus = 1800000L;
        boolean debugPrint = true;
        Object buildResult = null;
        if (notInTestMode) {
            listener.getLogger().print("Waiting until all sessions will end...\n");
            listener.getLogger().print("Checking for state change every " + TIME_TO_SLEEP / 60000L + " minutes.\n");
            listener.getLogger().print("Printing out session state every " + timeBetweenPrintStatus / 60000L + " minutes.\n");
        } else {
            System.out.println("Waiting until all sessions will end...\n");
            System.out.println("Checking for state change every " + TIME_TO_SLEEP / 60000L + " minutes.");
            System.out.println("Printing out session state every " + timeBetweenPrintStatus / 60000L + " minutes.");
        }
        SessionStatusHolder sessionStatusHolder = new SessionStatusHolder(url, requireAuth, user, password, listener, dynamicUserId, buildNumber, workPlacePath, buildID, connConnTimeOut, connReadTimeout, advConfig, this.listOfSessions, this.stepHolder.isMarkBuildAsFailedIfAllRunFailed(), this.stepHolder.isFailJobIfAllRunFailed(), workingJobDir, this.stepHolder.isMarkBuildAsPassedIfAllRunPassed(), this.stepHolder.isFailJobUnlessAllRunPassed());
        HashMap<String, String> sessionIdName = new HashMap<String, String>();
        HashMap<String, String> sessionCompletedLastState = new HashMap<String, String>();
        block30: while (keepWaiting) {
            buildResult = "";
            if (this.stepHolder.getStepSessionTimeout() != 0 && new Date().getTime() - startTime > timeToWaitOverall) {
                buildResult = "(" + new Date().toString() + ") - Timeout.  Waiting for more than " + this.stepHolder.getStepSessionTimeout() + " minutes. Marking build as failed.\n";
                if (notInTestMode) {
                    listener.getLogger().print((String)buildResult);
                    break;
                }
                System.out.println((String)buildResult);
                break;
            }
            try {
                Thread.sleep(TIME_TO_SLEEP);
            }
            catch (InterruptedException e1) {
                if (this.stepHolder.isPauseSessionOnBuildInterruption()) {
                    listener.getLogger().print("Build " + buildID + " was interrupted. checking if there are sessions running in Verisium Manager to be also aborted...");
                    try {
                        Logger logger = Logger.getLogger(LaunchHolder.class.getName());
                        this.abortVManagerSessions(logger, url, requireAuth, user, password, listener, dynamicUserId, buildNumber, workPlacePath, buildID, connConnTimeOut, connReadTimeout, advConfig, notInTestMode, this.listOfSessions, workingJobDir);
                    }
                    catch (Exception ex) {
                        listener.getLogger().print("Failed to delete session during build removal." + ex.getMessage());
                        listener.getLogger().println(ExceptionUtils.getFullStackTrace((Throwable)ex));
                    }
                }
                e1.printStackTrace();
                break;
            }
            try {
                if (new Date().getTime() - startTimeForDebugInfo > timeBetweenPrintStatus) {
                    startTimeForDebugInfo = new Date().getTime();
                    debugPrint = true;
                }
                Iterator<String> sessionIter = this.listOfSessions.iterator();
                String tmpSessionId = null;
                String tmpPostData = null;
                String sessionState = null;
                int numOfRunningRuns = 0;
                int numOfWaitingRuns = 0;
                while (sessionIter.hasNext()) {
                    tmpSessionId = sessionIter.next();
                    tmpPostData = postData1 + tmpSessionId + postData2;
                    BufferedReader br = null;
                    try {
                        String output;
                        conn = this.utils.getVAPIConnection(apiURL, requireAuth, user, password, requestMethod, dynamicUserId, buildID, buildNumber, workPlacePath, listener, connConnTimeOut, connReadTimeout, advConfig);
                        OutputStream os = conn.getOutputStream();
                        os.write(tmpPostData.getBytes(Charset.forName("UTF-8")));
                        os.flush();
                        if (!this.checkResponseCode(conn)) continue;
                        br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
                        StringBuilder result = new StringBuilder();
                        while ((output = br.readLine()) != null) {
                            result.append(output);
                        }
                        JSONArray tmpArray = JSONArray.fromObject((Object)result.toString());
                        if (tmpArray.size() == 0) {
                            buildResult = "(" + new Date().toString() + ") -  Session id (" + tmpSessionId + ") has been deleted on the Verisium Manager system.  Failing the build.\n";
                            if (notInTestMode) {
                                listener.getLogger().print((String)buildResult);
                            } else {
                                System.out.println((String)buildResult);
                            }
                            keepWaiting = false;
                            continue block30;
                        }
                        JSONObject tmp = tmpArray.getJSONObject(0);
                        sessionState = tmp.getString("session_status");
                        numOfRunningRuns = tmp.getInt("running");
                        numOfWaitingRuns = tmp.getInt("waiting");
                        if (numOfRunningRuns == 0 && numOfWaitingRuns == 0) {
                            String lastKnownSessionCompletedState = (String)sessionCompletedLastState.get(tmpSessionId);
                            if ("true".equals(lastKnownSessionCompletedState)) {
                                this.sessionFinalState.put(tmpSessionId, "true");
                                if ("failed".equals(sessionState) && this.checkIfAllSessionsEnded(tmpSessionId, listener)) {
                                    buildResult = "(" + new Date().toString() + ") - All sessions got into a state in which the build step can continue.\n";
                                    if (notInTestMode) {
                                        listener.getLogger().print((String)buildResult);
                                    } else {
                                        System.out.println((String)buildResult);
                                    }
                                    buildResult = "success";
                                    keepWaiting = false;
                                    continue block30;
                                }
                            } else {
                                sessionCompletedLastState.put(tmpSessionId, "true");
                                this.sessionFinalState.put(tmpSessionId, "false");
                            }
                        } else {
                            sessionCompletedLastState.put(tmpSessionId, "false");
                            this.sessionFinalState.put(tmpSessionId, "false");
                        }
                        sessionIdName.put(tmpSessionId, tmp.getString("name"));
                        if (notInTestMode) {
                            if (debugPrint) {
                                listener.getLogger().print("(" + new Date().toString() + ") - State of Session '" + tmp.getString("name") + "' (" + tmpSessionId + ") = " + tmp.getString("session_status") + "\n");
                            }
                        } else if (debugPrint) {
                            System.out.println("(" + new Date().toString() + ") - State of Session '" + tmp.getString("name") + "' (" + tmpSessionId + ") = " + tmp.getString("session_status"));
                        }
                        if (this.toContinue(sessionState, tmpSessionId, listener)) {
                            buildResult = "(" + new Date().toString() + ") - All sessions got into a state in which the build step can continue.\n";
                            if (notInTestMode) {
                                listener.getLogger().print((String)buildResult);
                            } else {
                                System.out.println((String)buildResult);
                            }
                            buildResult = "success";
                            keepWaiting = false;
                            continue block30;
                        }
                        if (this.toFail(sessionState, tmpSessionId, listener)) {
                            buildResult = "(" + new Date().toString() + ") - State of Session '" + tmp.getString("name") + "' (" + tmpSessionId + ") = " + tmp.getString("session_status") + " - Marking build failed.\n";
                            if (notInTestMode) {
                                listener.getLogger().print((String)buildResult);
                            } else {
                                System.out.println((String)buildResult);
                            }
                            keepWaiting = false;
                            continue block30;
                        }
                        if (!this.toIgnore(sessionState, tmpSessionId, listener)) continue;
                    }
                    catch (ConnectException e) {
                        if (notInTestMode) {
                            if (!debugPrint) continue block30;
                            listener.getLogger().print("(" + new Date().toString() + ") - Verisium Manager Server is not responding or is down. Build will keep try to connect.\n");
                            continue block30;
                        }
                        System.out.println("(" + new Date().toString() + ") - Verisium Manager Server is not responding or is down. Build will keep try to connect.'");
                        continue block30;
                    }
                    catch (Exception e) {
                        if (notInTestMode) {
                            listener.getLogger().print(e.getMessage());
                        }
                        e.printStackTrace();
                    }
                    finally {
                        if (br != null) {
                            br.close();
                        }
                        if (conn == null) continue block30;
                        conn.disconnect();
                        continue block30;
                    }
                }
            }
            catch (Exception e) {
                if (notInTestMode) {
                    listener.getLogger().print(e.getMessage());
                }
                e.printStackTrace();
            }
            finally {
                if (this.listOfSessions.size() > 1) {
                    if (notInTestMode) {
                        if (debugPrint) {
                            listener.getLogger().print("\n");
                        }
                    } else if (debugPrint) {
                        System.out.println("\n");
                    }
                }
                debugPrint = false;
                sessionStatusHolder.dumpSessionStatus(false, sessionIdName, this.utils, launcher);
            }
        }
        sessionStatusHolder.dumpSessionStatus(true, sessionIdName, this.utils, launcher);
        if (this.stepHolder.getjUnitRequestHolder() != null && this.stepHolder.getjUnitRequestHolder().isGenerateJUnitXML()) {
            StringBuilder resultExtra = new StringBuilder();
            BufferedReader brExtra = null;
            try {
                String outputExtra;
                apiURL = url + "/rest/$schema/response?action=list&component=runs&extended=true";
                conn = this.utils.getVAPIConnection(apiURL, requireAuth, user, password, "GET", dynamicUserId, buildID, buildNumber, workPlacePath, listener, connConnTimeOut, connReadTimeout, advConfig);
                brExtra = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
                while ((outputExtra = brExtra.readLine()) != null) {
                    resultExtra.append(outputExtra);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (brExtra != null) {
                    brExtra.close();
                }
                if (conn != null) {
                    conn.disconnect();
                }
            }
            JSONObject tmp = JSONObject.fromObject((Object)resultExtra.toString());
            JSONObject responseItems = JSONObject.fromObject((Object)tmp.getString("items"));
            JSONObject properties = JSONObject.fromObject((Object)responseItems.getString("properties"));
            List<Object> extraItems = new ArrayList();
            if (this.stepHolder.getjUnitRequestHolder().getStaticAttributeList() != null) {
                extraItems = Arrays.asList(this.stepHolder.getjUnitRequestHolder().getStaticAttributeList().split("\\s*,\\s*"));
            }
            Iterator iterExtra = extraItems.iterator();
            String attr = null;
            JSONObject attrObject = null;
            StringBuilder extraAttributesForRuns = new StringBuilder();
            while (iterExtra.hasNext()) {
                attr = (String)iterExtra.next();
                if (!properties.has(attr)) continue;
                attrObject = JSONObject.fromObject((Object)properties.getString(attr));
                String attrTitle = attrObject.getString("title");
                this.extraAttrLabels.put(attr, attrTitle);
                if (attr.indexOf(" ") > 0 || attr.equals("first_failure_name") || attr.equals("first_failure_description") || attr.equals("computed_seed") || attr.equals("test_group") || attr.equals("test_name")) continue;
                extraAttributesForRuns.append(",\"").append(attr).append("\"");
            }
            String runsRestURL = url + "/rest/runs/list";
            Iterator<String> sessionIter = this.listOfSessions.iterator();
            String runsJSONData = null;
            String tmpSessionId = null;
            ArrayList<JSONObject> entireSessionsRuns = new ArrayList<JSONObject>();
            while (sessionIter.hasNext()) {
                runsJSONData = runsList;
                tmpSessionId = sessionIter.next();
                runsJSONData = runsJSONData.replaceAll("######", tmpSessionId);
                runsJSONData = runsJSONData.replaceAll("###ATTR###", extraAttributesForRuns.toString());
                BufferedReader br = null;
                try {
                    String output;
                    conn = this.utils.getVAPIConnection(runsRestURL, requireAuth, user, password, requestMethod, dynamicUserId, buildID, buildNumber, workPlacePath, listener, connConnTimeOut, connReadTimeout, advConfig);
                    OutputStream os = conn.getOutputStream();
                    os.write(runsJSONData.getBytes(Charset.forName("UTF-8")));
                    os.flush();
                    if (!this.checkResponseCode(conn)) continue;
                    br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
                    StringBuilder result = new StringBuilder();
                    while ((output = br.readLine()) != null) {
                        result.append(output);
                    }
                    JSONArray tmpRunsArray = JSONArray.fromObject((Object)result.toString());
                    Iterator runsIter = tmpRunsArray.iterator();
                    while (runsIter.hasNext()) {
                        entireSessionsRuns.add((JSONObject)runsIter.next());
                    }
                }
                catch (Exception e) {
                    if (notInTestMode) {
                        listener.getLogger().print(e.getMessage());
                    }
                    e.printStackTrace();
                }
                finally {
                    if (br != null) {
                        br.close();
                    }
                    conn.disconnect();
                }
            }
            if (entireSessionsRuns.size() > 0) {
                UnitTestFormatter unitTestFormatter = new UnitTestFormatter(entireSessionsRuns, this.stepHolder.getjUnitRequestHolder(), this.extraAttrLabels);
                unitTestFormatter.dumpXMLFile(workPlacePath, buildNumber, buildID, this.utils);
            }
        }
        if (!"success".equals(buildResult)) {
            throw new Exception((String)buildResult);
        }
    }

    private boolean toContinue(String state, String sessionId, TaskListener listener) {
        return this.checkWhatNext(state, sessionId, "continue", listener);
    }

    private boolean toFail(String state, String sessionId, TaskListener listener) {
        return this.checkWhatNext(state, sessionId, "fail", listener);
    }

    private boolean toIgnore(String state, String sessionId, TaskListener listener) {
        return this.checkWhatNext(state, sessionId, "ignore", listener);
    }

    private boolean checkWhatNext(String state, String sessionId, String checkFor, TaskListener listener) {
        if ("inaccessible".equals(state)) {
            if (this.stepHolder.getInaccessibleResolver().equals(checkFor)) {
                return this.stepResolver(checkFor, sessionId, listener);
            }
        } else if ("stopped".equals(state)) {
            if (this.stepHolder.getStoppedResolver().equals(checkFor)) {
                return this.stepResolver(checkFor, sessionId, listener);
            }
        } else if ("failed".equals(state)) {
            if (this.stepHolder.getFailedResolver().equals(checkFor)) {
                return this.stepResolver(checkFor, sessionId, listener);
            }
        } else if ("done".equals(state)) {
            if (this.stepHolder.getDoneResolver().equals(checkFor)) {
                return this.stepResolver(checkFor, sessionId, listener);
            }
        } else if ("suspended".equals(state)) {
            if (this.stepHolder.getSuspendedResolver().equals(checkFor)) {
                return this.stepResolver(checkFor, sessionId, listener);
            }
        } else if ("completed".equals(state) && checkFor.equals("continue")) {
            return this.checkIfAllSessionsEnded(sessionId, listener);
        }
        return false;
    }

    private boolean checkIfAllSessionsEnded(String sessionId, TaskListener listener) {
        if ("true".equals(this.sessionFinalState.get(sessionId))) {
            this.listOfSessionsForCountDown.remove(sessionId);
        }
        return this.listOfSessionsForCountDown.size() == 0;
    }

    private boolean stepResolver(String checkFor, String sessionId, TaskListener listener) {
        if (checkFor.equals("continue")) {
            return this.checkIfAllSessionsEnded(sessionId, listener);
        }
        if (checkFor.equals("fail")) {
            return true;
        }
        if (checkFor.equals("ignore")) {
            return this.checkIfAllSessionsEnded(sessionId, listener);
        }
        return false;
    }

    private boolean checkResponseCode(HttpURLConnection conn) {
        try {
            return conn.getResponseCode() == 200 || conn.getResponseCode() == 204 || conn.getResponseCode() == 202 || conn.getResponseCode() == 201 || conn.getResponseCode() == 206 || conn.getResponseCode() == 205 || conn.getResponseCode() == 406;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void abortVManagerSessions(Logger logger, String url, boolean requireAuth, String user, String password, TaskListener listener, boolean dynamicUserId, int buildNumber, String workPlacePath, String buildId, int connConnTimeOut, int connReadTimeout, boolean advConfig, boolean notInTestMode, List<String> listOfSessions, String workingJobDir) throws Exception {
        String postData = "{\"filter\":{\"@c\":\".InFilter\",\"attName\":\"id\",\"operand\":\"IN\",\"values\":[" + String.join((CharSequence)",", listOfSessions) + "]}}";
        String apiURL = url + "/rest/sessions/suspend";
        HttpURLConnection conn = this.utils.getVAPIConnection(apiURL, requireAuth, user, password, "POST", dynamicUserId, buildId, buildNumber, workPlacePath, listener, connConnTimeOut, connReadTimeout, advConfig);
        OutputStream os = conn.getOutputStream();
        os.write(postData.getBytes(Charset.forName("UTF-8")));
        os.flush();
        if (conn.getResponseCode() != 200 && conn.getResponseCode() != 204 && conn.getResponseCode() != 202 && conn.getResponseCode() != 201 && conn.getResponseCode() != 206 && conn.getResponseCode() != 205) {
            String reason = "";
            if (conn.getResponseCode() == 503) {
                reason = "Failed to suspend sessions.  vAPI process failed to connect to remote Verisium Manager server.";
            }
            if (conn.getResponseCode() == 401) {
                reason = "Failed to suspend sessions.  Authentication Error";
            }
            if (conn.getResponseCode() == 408) {
                reason = "Failed to suspend sessions.  No more licences are available for vAPI";
            }
            logger.log(Level.SEVERE, reason);
            this.processErrorFromRespone(conn, logger);
        } else {
            logger.log(Level.INFO, "Sessions were suspended in Verisium Manager as a result of build interuption.");
        }
        conn.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processErrorFromRespone(HttpURLConnection conn, Logger logger) throws IOException {
        Object errorMessage = "";
        StringBuilder resultFromError = null;
        int responseCode = 0;
        BufferedReader br = null;
        try {
            String output;
            resultFromError = new StringBuilder(conn.getResponseMessage());
            responseCode = conn.getResponseCode();
            br = new BufferedReader(new InputStreamReader(conn.getErrorStream(), "UTF-8"));
            while ((output = br.readLine()) != null) {
                resultFromError.append(output);
            }
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                errorMessage = "Failed : HTTP error code : " + responseCode + " (" + String.valueOf(resultFromError) + ")\n";
                if (br != null) {
                    br.close();
                }
                logger.log(Level.SEVERE, (String)errorMessage);
                throw throwable;
            }
            errorMessage = "Failed : HTTP error code : " + responseCode + " (" + String.valueOf(resultFromError) + ")\n";
            if (br != null) {
                br.close();
            }
            logger.log(Level.SEVERE, (String)errorMessage);
        }
        errorMessage = "Failed : HTTP error code : " + responseCode + " (" + String.valueOf(resultFromError) + ")\n";
        if (br != null) {
            br.close();
        }
        logger.log(Level.SEVERE, (String)errorMessage);
    }
}

