/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vmanager;

import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.lang.exception.ExceptionUtils;

public class InvokeExecutionTask
extends MasterToSlaveFileCallable<Void>
implements Serializable {
    TaskListener jobListener = null;
    String executionScript = null;
    String executionShellLocation = null;
    String vsifFile = null;
    String buildId = null;
    int buildNumber = 0;
    String[] command;
    FilePath filePath = null;

    public InvokeExecutionTask(TaskListener listener, String executionScript, String executionShellLocation, String executionVsifFile, String buildId, int buildNumber, String[] command, FilePath filePath) {
        this.jobListener = listener;
        this.executionScript = executionScript;
        this.executionShellLocation = executionShellLocation;
        this.vsifFile = executionVsifFile;
        this.buildId = buildId;
        this.buildNumber = buildNumber;
        this.command = command;
        this.filePath = filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Void invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
        String sessionNameToMonitor = null;
        this.jobListener.getLogger().print("\nTrying to launch a session using batch on this agent workspace:\n");
        this.jobListener.getLogger().print("Select script for this execution is " + this.executionScript + "\n");
        this.jobListener.getLogger().print("Select shell type for this execution is " + this.executionShellLocation + "\n");
        this.jobListener.getLogger().print("Select vsif for this execution is " + this.vsifFile + "\n");
        boolean foundGoodVSIF = false;
        BufferedReader in = null;
        BufferedReader inError = null;
        try {
            ProcessBuilder builder = new ProcessBuilder(this.command);
            builder.redirectErrorStream(true);
            Process proc = builder.start();
            in = new BufferedReader(new InputStreamReader(proc.getInputStream(), "UTF-8"));
            inError = new BufferedReader(new InputStreamReader(proc.getErrorStream(), "UTF-8"));
            String s = null;
            while ((s = in.readLine()) != null) {
                this.jobListener.getLogger().print(s + "\n");
                if (s.indexOf("*I,runner.sessionStarted: Session") <= -1) continue;
                foundGoodVSIF = true;
                sessionNameToMonitor = s.substring(34, s.indexOf(" started."));
                String fileOutput = this.buildNumber + "." + this.buildId + ".sessions.input";
                StringBuffer writer = new StringBuffer();
                writer.append(sessionNameToMonitor);
                FilePath newFile = this.filePath.child(fileOutput);
                newFile.write(writer.toString(), StandardCharsets.UTF_8.name());
            }
            String sError = null;
            while ((sError = inError.readLine()) != null) {
                this.jobListener.getLogger().print(sError + "\n");
            }
        }
        catch (IOException e) {
            this.jobListener.getLogger().println(e.getMessage());
            for (StackTraceElement ste : e.getStackTrace()) {
                this.jobListener.getLogger().println(" " + String.valueOf(ste));
            }
            this.jobListener.getLogger().println(ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        catch (InterruptedException ex) {
            this.jobListener.getLogger().println(ex.getMessage());
            for (StackTraceElement ste : ex.getStackTrace()) {
                this.jobListener.getLogger().println(" " + String.valueOf(ste));
            }
            this.jobListener.getLogger().println(ExceptionUtils.getFullStackTrace((Throwable)ex));
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (inError != null) {
                inError.close();
            }
        }
        if (!foundGoodVSIF) {
            throw new IOException("Failed to launch vsif using batch.  Job stopped.");
        }
        this.jobListener.getLogger().print("Found session name to monitor: " + sessionNameToMonitor + "\n");
        return null;
    }
}

