/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.vigilnz.pipeline;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.vigilnz.api.ApiService;
import io.jenkins.plugins.vigilnz.credentials.TokenCredentials;
import io.jenkins.plugins.vigilnz.models.ApiRequest;
import io.jenkins.plugins.vigilnz.models.ApiResponse;
import io.jenkins.plugins.vigilnz.models.ContainerScanContext;
import io.jenkins.plugins.vigilnz.pipeline.PipelineStep;
import io.jenkins.plugins.vigilnz.ui.ScanResultAction;
import io.jenkins.plugins.vigilnz.utils.VigilnzConfig;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;

public class PipelineStepExecution
extends StepExecution {
    private static final long serialVersionUID = 1L;
    private final transient PipelineStep step;

    public PipelineStepExecution(PipelineStep step, StepContext context) {
        super(context);
        this.step = step;
    }

    public static void getGitDetails(File workspaceDir, EnvVars env, TaskListener listener) {
        try {
            File gitDir = new File(workspaceDir, ".git");
            if (!gitDir.exists()) {
                listener.getLogger().println("No .git folder found");
                return;
            }
            String head = Files.readString(Paths.get(gitDir.getAbsolutePath(), "HEAD"), StandardCharsets.UTF_8).trim();
            String branch = null;
            String commit = null;
            if (head.startsWith("ref:")) {
                branch = head.substring("ref: refs/heads/".length());
                Path refPath = Paths.get(gitDir.getAbsolutePath(), head.substring("ref: ".length()));
                if (Files.exists(refPath, new LinkOption[0])) {
                    commit = Files.readString(refPath, StandardCharsets.UTF_8).trim();
                }
            } else {
                commit = head;
            }
            Path configPath = Paths.get(gitDir.getAbsolutePath(), "config");
            String repoUrl = null;
            if (Files.exists(configPath, new LinkOption[0])) {
                for (String line : Files.readAllLines(configPath, StandardCharsets.UTF_8)) {
                    if (!line.trim().startsWith("url =")) continue;
                    repoUrl = line.split("=")[1].trim();
                    break;
                }
            }
            if (branch != null) {
                env.put("GIT_BRANCH", branch);
            }
            if (commit != null) {
                env.put("GIT_COMMIT", commit);
            }
            if (repoUrl != null) {
                env.put("GIT_URL", repoUrl);
            }
        }
        catch (Exception e) {
            listener.getLogger().println("Error reading git info: " + e.getMessage());
        }
    }

    public List<String> convertToScanList(String scanTypes) {
        if (scanTypes != null && !scanTypes.trim().isEmpty()) {
            List<String> scanTypeList = Arrays.asList(scanTypes.split("\\s*,\\s*"));
            return scanTypeList.stream().map(s -> {
                if (s.equalsIgnoreCase("sca")) {
                    return "cve";
                }
                if (s.equalsIgnoreCase("secret scan")) {
                    return "secret";
                }
                if (s.equalsIgnoreCase("iac scan")) {
                    return "iac";
                }
                if (s.equalsIgnoreCase("container scan")) {
                    return "container";
                }
                return s.toLowerCase();
            }).collect(Collectors.toList());
        }
        return List.of();
    }

    public boolean start() throws Exception {
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        Run run = (Run)this.getContext().get(Run.class);
        String credentialsId = this.step.getCredentialsId();
        if (credentialsId == null || credentialsId.trim().isEmpty()) {
            listener.error("Error: Credentials ID is required. Please provide a credential ID in the pipeline step.");
            this.attachResult(run, this.buildErrorResponse("Credentials ID is required."));
            this.getContext().onFailure((Throwable)new AbortException("Credentials ID is required"));
            return false;
        }
        TokenCredentials creds = (TokenCredentials)CredentialsProvider.findCredentialById((String)credentialsId, TokenCredentials.class, (Run)run);
        listener.getLogger().println("------ Pipeline Method ------");
        if (creds != null) {
            EnvVars env = (EnvVars)this.getContext().get(EnvVars.class);
            FilePath ws = (FilePath)this.getContext().get(FilePath.class);
            if (ws != null) {
                File workspaceDir = new File(ws.getRemote());
                PipelineStepExecution.getGitDetails(workspaceDir, env, listener);
            }
            String token = creds.getToken().getPlainText();
            VigilnzConfig.setBaseUrl(creds.getEnvironment());
            listener.getLogger().println("Selected Scan Types: " + this.step.getScanTypes());
            List<String> scanTypes = this.convertToScanList(this.step.getScanTypes());
            if (scanTypes == null || scanTypes.isEmpty()) {
                listener.error("Error: At least one scan type must be selected.");
                this.attachResult(run, this.buildErrorResponse("At least one scan type must be selected."));
                this.getContext().onFailure((Throwable)new AbortException("At least one scan type must be selected"));
                return false;
            }
            ApiRequest apiRequest = new ApiRequest();
            apiRequest.setProjectName(this.step.getProjectName());
            apiRequest.setScanTypes(scanTypes);
            apiRequest.setScanContext(this.step.getDastScanContext());
            ApiRequest.ContainerScanContext containerScanContext = new ApiRequest.ContainerScanContext("");
            ContainerScanContext pipeLineContainerScanInfo = this.step.getContainerScanContext();
            containerScanContext.setImageName(pipeLineContainerScanInfo.getImage());
            containerScanContext.setRegistryProvider(pipeLineContainerScanInfo.getProvider());
            JSONObject json = new JSONObject();
            if (pipeLineContainerScanInfo.getAuth() != null) {
                containerScanContext.setAuthMethod(pipeLineContainerScanInfo.getAuth().getType());
                if (pipeLineContainerScanInfo.getAuth().getType().equalsIgnoreCase("token")) {
                    json.put("token", (Object)pipeLineContainerScanInfo.getAuth().getToken());
                } else if (pipeLineContainerScanInfo.getAuth().getType().equalsIgnoreCase("username-password")) {
                    json.put("username", (Object)pipeLineContainerScanInfo.getAuth().getUsername());
                    json.put("password", (Object)pipeLineContainerScanInfo.getAuth().getPassword());
                }
                containerScanContext.setCredentials(json);
            }
            if (pipeLineContainerScanInfo.getRegistry() != null) {
                containerScanContext.setCustomRegistryUrl(pipeLineContainerScanInfo.getRegistry().getUrl());
                containerScanContext.setRegistrySubType(pipeLineContainerScanInfo.getRegistry().getType());
            }
            apiRequest.setContainerScanContext(containerScanContext);
            try {
                String result = ApiService.triggerScan(token, apiRequest, env, listener);
                if (result == null || result.isEmpty()) {
                    listener.getLogger().println("API call failed, no action added.");
                    this.getContext().onFailure((Throwable)new AbortException("Scan failed"));
                    return false;
                }
                run.addAction((Action)new ScanResultAction(result, credentialsId));
            }
            catch (Exception e) {
                listener.error("Scan failed");
                this.attachResult(run, this.buildErrorResponse("Scan failed: " + e.getMessage()));
                this.getContext().onFailure((Throwable)new AbortException("Scan failed"));
                return false;
            }
        } else {
            listener.error("Error: Vigilnz Token credential not found with ID: " + credentialsId);
            this.attachResult(run, this.buildErrorResponse("Vigilnz Token credential not found with ID: " + credentialsId));
            this.getContext().onFailure((Throwable)new AbortException("No Vigilnz Token credential found with ID: " + credentialsId));
            return false;
        }
        this.getContext().onSuccess(null);
        return true;
    }

    private void attachResult(Run<?, ?> run, String json) {
        try {
            run.addAction((Action)new ScanResultAction(json, ""));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String buildErrorResponse(String message) {
        ApiResponse resp = new ApiResponse();
        resp.setMessage(message);
        try {
            return new ObjectMapper().writeValueAsString((Object)resp);
        }
        catch (JsonProcessingException e) {
            return "{\"message\":\"" + message.replace("\"", "\\\"") + "\"}";
        }
    }
}

