/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.vigilnz.build;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.cli.shaded.org.apache.commons.lang.StringUtils;
import io.jenkins.plugins.vigilnz.api.ApiService;
import io.jenkins.plugins.vigilnz.credentials.TokenCredentials;
import io.jenkins.plugins.vigilnz.models.ApiRequest;
import io.jenkins.plugins.vigilnz.models.ApiResponse;
import io.jenkins.plugins.vigilnz.ui.ScanResultAction;
import io.jenkins.plugins.vigilnz.utils.VigilnzConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class SecurityCheckBuilder
extends Builder {
    private final String credentialsId;
    private String projectName;
    private boolean cveScan;
    private boolean sastScan;
    private boolean sbomScan;
    private boolean iacScan;
    private boolean secretScan;
    private boolean dastScan;
    private boolean containerScan;
    private String targetSiteUrl;
    private String dastScanType;
    private String imageName;
    private String registryProvider;
    private String authType;
    private String dockerUsername;
    private String registryType;
    private String dockerPassword;
    private String registryUrl;
    private String accessToken;
    private String googleRegistryUrl;
    private String dockerAuthMethod;
    private String awsRegistryType;
    private String ecrAccessToken;
    private String gitRegistryType;
    private String gitHubAccessToken;
    private String googleRegistryType;
    private String googleAuthenticateFields;
    private String googleAccessToken;
    private String quayAuthenticateFields;
    private String quayUsername;
    private String quayPassword;
    private String quayAccessToken;
    private String azureRegistryType;
    private String azureRegistryUrl;
    private String azureAuthenticateFields;
    private String azureUsername;
    private String azurePassword;
    private String azureAccessToken;

    @DataBoundConstructor
    public SecurityCheckBuilder(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    @DataBoundSetter
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public boolean isCveScan() {
        return this.cveScan;
    }

    @DataBoundSetter
    public void setCveScan(boolean cveScan) {
        this.cveScan = cveScan;
    }

    public boolean isSastScan() {
        return this.sastScan;
    }

    @DataBoundSetter
    public void setSastScan(boolean sastScan) {
        this.sastScan = sastScan;
    }

    public boolean isSbomScan() {
        return this.sbomScan;
    }

    @DataBoundSetter
    public void setSbomScan(boolean sbomScan) {
        this.sbomScan = sbomScan;
    }

    public boolean isSecretScan() {
        return this.secretScan;
    }

    @DataBoundSetter
    public void setSecretScan(boolean secretScan) {
        this.secretScan = secretScan;
    }

    public boolean isDastScan() {
        return this.dastScan;
    }

    @DataBoundSetter
    public void setDastScan(boolean dastScan) {
        this.dastScan = dastScan;
    }

    public boolean isContainerScan() {
        return this.containerScan;
    }

    @DataBoundSetter
    public void setContainerScan(boolean containerScan) {
        this.containerScan = containerScan;
    }

    public boolean isIacScan() {
        return this.iacScan;
    }

    @DataBoundSetter
    public void setIacScan(boolean iacScan) {
        this.iacScan = iacScan;
    }

    public List<String> getScanTypes() {
        ArrayList<String> types = new ArrayList<String>();
        if (this.cveScan) {
            types.add("cve");
        }
        if (this.sastScan) {
            types.add("sast");
        }
        if (this.sbomScan) {
            types.add("sbom");
        }
        if (this.iacScan) {
            types.add("iac");
        }
        if (this.secretScan) {
            types.add("secret");
        }
        if (this.dastScan) {
            types.add("dast");
        }
        if (this.containerScan) {
            types.add("container");
        }
        return types;
    }

    public JSONObject getCredentialData() {
        JSONObject json = new JSONObject();
        if (this.authType.equalsIgnoreCase("token")) {
            if (this.registryProvider.equalsIgnoreCase("aws-ecr")) {
                json.put("token", (Object)this.ecrAccessToken);
            } else if (this.registryProvider.equalsIgnoreCase("github") || this.registryProvider.equalsIgnoreCase("gitlab")) {
                json.put("token", (Object)this.gitHubAccessToken);
            } else if (this.registryProvider.equalsIgnoreCase("google")) {
                json.put("token", (Object)this.googleAccessToken);
            } else if (this.registryProvider.equalsIgnoreCase("azure")) {
                json.put("token", (Object)this.accessToken);
            } else if (this.registryProvider.equalsIgnoreCase("quay")) {
                json.put("token", (Object)this.quayAccessToken);
            }
        } else if (this.authType.equalsIgnoreCase("username-password")) {
            if (this.registryProvider.equalsIgnoreCase("quay")) {
                json.put("username", (Object)this.quayUsername);
                json.put("password", (Object)this.quayPassword);
            } else {
                json.put("username", (Object)this.dockerUsername);
                json.put("password", (Object)this.dockerPassword);
            }
        }
        return json;
    }

    public String displayScan(List<String> scansList) {
        List<String> updatedList = scansList.stream().map(s -> {
            if (s.equalsIgnoreCase("cve")) {
                s = "sca";
            } else if (s.equalsIgnoreCase("secret")) {
                s = "secret scan";
            } else if (s.equalsIgnoreCase("iac")) {
                s = "iac scan";
            } else if (s.equalsIgnoreCase("container")) {
                s = "container scan";
            }
            return s.toUpperCase();
        }).toList();
        return String.join((CharSequence)", ", updatedList);
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        EnvVars env = build.getEnvironment((TaskListener)listener);
        listener.getLogger().println("------ Freestyle Method ------");
        List<String> scanTypes = this.getScanTypes();
        if (scanTypes.isEmpty()) {
            listener.error("Error: At least one scan type must be selected.");
            this.attachResult(build, this.buildErrorResponse("At least one scan type must be selected."));
            return false;
        }
        if (this.credentialsId == null || this.credentialsId.trim().isEmpty()) {
            listener.error("Error: Credentials ID is required. Please select a credential in the build step configuration.");
            this.attachResult(build, this.buildErrorResponse("Credentials ID is required."));
            return false;
        }
        TokenCredentials creds = (TokenCredentials)CredentialsProvider.findCredentialById((String)this.credentialsId, TokenCredentials.class, (Run)build);
        if (creds == null) {
            listener.error("Error: Vigilnz Token credential not found with ID: " + this.credentialsId);
            this.attachResult(build, this.buildErrorResponse("Vigilnz Token credential not found with ID: " + this.credentialsId));
            return false;
        }
        String tokenText = creds.getToken().getPlainText();
        VigilnzConfig.setBaseUrl(creds.getEnvironment());
        if (this.projectName != null && !this.projectName.trim().isEmpty()) {
            listener.getLogger().println("Project Name: " + this.projectName);
        } else {
            listener.getLogger().println("Target File: (not specified)");
        }
        listener.getLogger().println("Selected Scan Types: " + this.displayScan(scanTypes));
        listener.getLogger().println("Selected Scan Types:1 " + this.targetSiteUrl);
        String result = "";
        ApiRequest apiRequest = new ApiRequest();
        apiRequest.setProjectName(this.projectName);
        apiRequest.setScanTypes(scanTypes);
        ApiRequest.ScanContext dastScanContext = new ApiRequest.ScanContext("", "");
        if (this.dastScan) {
            dastScanContext.setTargetUrl(this.targetSiteUrl);
            dastScanContext.setDastScanType(this.dastScanType);
            apiRequest.setScanContext(dastScanContext);
        }
        ApiRequest.ContainerScanContext containerScanInfo = new ApiRequest.ContainerScanContext("");
        if (this.containerScan) {
            containerScanInfo.setImageName(this.imageName);
            containerScanInfo.setRegistryProvider(this.registryProvider);
            if (this.registryProvider.equalsIgnoreCase("aws-ecr") || this.registryProvider.equalsIgnoreCase("azure") || this.registryProvider.equalsIgnoreCase("google")) {
                if (this.registryProvider.equalsIgnoreCase("google")) {
                    containerScanInfo.setCustomRegistryUrl(this.googleRegistryUrl);
                    containerScanInfo.setRegistrySubType(this.googleRegistryType);
                } else if (this.registryProvider.equalsIgnoreCase("aws-ecr")) {
                    containerScanInfo.setCustomRegistryUrl(this.registryUrl);
                    containerScanInfo.setRegistrySubType(this.awsRegistryType);
                } else if (this.registryProvider.equalsIgnoreCase("azure")) {
                    containerScanInfo.setCustomRegistryUrl(this.azureRegistryUrl);
                    containerScanInfo.setRegistrySubType(this.azureRegistryType);
                }
            }
            containerScanInfo.setCredentials(this.getCredentialData());
            if (this.authType.equalsIgnoreCase("ecr-public")) {
                containerScanInfo.setAuthMethod("none");
            } else {
                containerScanInfo.setAuthMethod(this.authType);
            }
            apiRequest.setContainerScanContext(containerScanInfo);
        }
        try {
            result = ApiService.triggerScan(tokenText, apiRequest, env, (TaskListener)listener);
            if (result != null && !result.isEmpty()) {
                build.addAction((Action)new ScanResultAction(result, this.credentialsId));
            } else {
                listener.getLogger().println("API call failed, no action added.");
            }
        }
        catch (Exception e) {
            listener.error("Scan failed");
            this.attachResult(build, this.buildErrorResponse("Scan failed: " + e.getMessage()));
            build.addAction((Action)new ScanResultAction(new ApiResponse().toString(), ""));
            return false;
        }
        return true;
    }

    private void attachResult(AbstractBuild build, String json) {
        try {
            build.addAction((Action)new ScanResultAction(json, ""));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String buildErrorResponse(String message) {
        ApiResponse resp = new ApiResponse();
        resp.setMessage(message);
        try {
            return new ObjectMapper().writeValueAsString((Object)resp);
        }
        catch (JsonProcessingException e) {
            return "{\"message\":\"" + message.replace("\"", "\\\"") + "\"}";
        }
    }

    public String getTargetSiteUrl() {
        return this.targetSiteUrl;
    }

    @DataBoundSetter
    public void setTargetSiteUrl(String targetSiteUrl) {
        this.targetSiteUrl = targetSiteUrl;
    }

    public String getDastScanType() {
        return this.dastScanType;
    }

    @DataBoundSetter
    public void setDastScanType(String dastScanType) {
        this.dastScanType = dastScanType;
    }

    public String getImageName() {
        return this.imageName;
    }

    @DataBoundSetter
    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public String getRegistryProvider() {
        return this.registryProvider;
    }

    @DataBoundSetter
    public void setRegistryProvider(String registryProvider) {
        this.registryProvider = registryProvider;
    }

    public String isAuthType() {
        return this.authType;
    }

    @DataBoundSetter
    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public String getDockerUsername() {
        return this.dockerUsername;
    }

    @DataBoundSetter
    public void setDockerUsername(String dockerUsername) {
        this.dockerUsername = dockerUsername;
    }

    public String getDockerPassword() {
        return this.dockerPassword;
    }

    @DataBoundSetter
    public void setDockerPassword(String dockerPassword) {
        this.dockerPassword = dockerPassword;
    }

    public String getRegistryUrl() {
        return this.registryUrl;
    }

    @DataBoundSetter
    public void setRegistryUrl(String registryUrl) {
        this.registryUrl = registryUrl;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    @DataBoundSetter
    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getRegistryType() {
        return this.registryType;
    }

    @DataBoundSetter
    public void setRegistryType(String registryType) {
        this.registryType = registryType;
    }

    public String getDockerAuthMethod() {
        return this.dockerAuthMethod;
    }

    @DataBoundSetter
    public void setDockerAuthMethod(String dockerAuthMethod) {
        this.dockerAuthMethod = dockerAuthMethod;
    }

    public String getAwsRegistryType() {
        return this.awsRegistryType;
    }

    @DataBoundSetter
    public void setAwsRegistryType(String awsRegistryType) {
        this.awsRegistryType = awsRegistryType;
    }

    public String getEcrAccessToken() {
        return this.ecrAccessToken;
    }

    @DataBoundSetter
    public void setEcrAccessToken(String ecrAccessToken) {
        this.ecrAccessToken = ecrAccessToken;
    }

    public String getGitRegistryType() {
        return this.gitRegistryType;
    }

    @DataBoundSetter
    public void setGitRegistryType(String gitRegistryType) {
        this.gitRegistryType = gitRegistryType;
    }

    public String getGitHubAccessToken() {
        return this.gitHubAccessToken;
    }

    @DataBoundSetter
    public void setGitHubAccessToken(String gitHubAccessToken) {
        this.gitHubAccessToken = gitHubAccessToken;
    }

    public String getGoogleRegistryType() {
        return this.googleRegistryType;
    }

    @DataBoundSetter
    public void setGoogleRegistryType(String googleRegistryType) {
        this.googleRegistryType = googleRegistryType;
    }

    public String getGoogleAuthenticateFields() {
        return this.googleAuthenticateFields;
    }

    @DataBoundSetter
    public void setGoogleAuthenticateFields(String googleAuthenticateFields) {
        this.googleAuthenticateFields = googleAuthenticateFields;
    }

    public String getGoogleAccessToken() {
        return this.googleAccessToken;
    }

    @DataBoundSetter
    public void setGoogleAccessToken(String googleAccessToken) {
        this.googleAccessToken = googleAccessToken;
    }

    public String getGoogleRegistryUrl() {
        return this.googleRegistryUrl;
    }

    @DataBoundSetter
    public void setGoogleRegistryUrl(String googleRegistryUrl) {
        this.googleRegistryUrl = googleRegistryUrl;
    }

    public String getQuayAuthenticateFields() {
        return this.quayAuthenticateFields;
    }

    @DataBoundSetter
    public void setQuayAuthenticateFields(String quayAuthenticateFields) {
        this.quayAuthenticateFields = quayAuthenticateFields;
    }

    public String getQuayUsername() {
        return this.quayUsername;
    }

    @DataBoundSetter
    public void setQuayUsername(String quayUsername) {
        this.quayUsername = quayUsername;
    }

    public String getQuayPassword() {
        return this.quayPassword;
    }

    @DataBoundSetter
    public void setQuayPassword(String quayPassword) {
        this.quayPassword = quayPassword;
    }

    public String getQuayAccessToken() {
        return this.quayAccessToken;
    }

    @DataBoundSetter
    public void setQuayAccessToken(String quayAccessToken) {
        this.quayAccessToken = quayAccessToken;
    }

    public String getAzureRegistryType() {
        return this.azureRegistryType;
    }

    @DataBoundSetter
    public void setAzureRegistryType(String azureRegistryType) {
        this.azureRegistryType = azureRegistryType;
    }

    public String getAzureRegistryUrl() {
        return this.azureRegistryUrl;
    }

    @DataBoundSetter
    public void setAzureRegistryUrl(String azureRegistryUrl) {
        this.azureRegistryUrl = azureRegistryUrl;
    }

    public String getAzureAuthenticateFields() {
        return this.azureAuthenticateFields;
    }

    @DataBoundSetter
    public void setAzureAuthenticateFields(String azureAuthenticateFields) {
        this.azureAuthenticateFields = azureAuthenticateFields;
    }

    public String getAzureUsername() {
        return this.azureUsername;
    }

    @DataBoundSetter
    public void setAzureUsername(String azureUsername) {
        this.azureUsername = azureUsername;
    }

    public String getAzurePassword() {
        return this.azurePassword;
    }

    @DataBoundSetter
    public void setAzurePassword(String azurePassword) {
        this.azurePassword = azurePassword;
    }

    public String getAzureAccessToken() {
        return this.azureAccessToken;
    }

    @DataBoundSetter
    public void setAzureAccessToken(String azureAccessToken) {
        this.azureAccessToken = azureAccessToken;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public String getDisplayName() {
            return "Invoke Vigilnz Security Task";
        }

        @POST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project) {
            if (project == null || !project.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            ListBoxModel items = new ListBoxModel();
            for (TokenCredentials c : CredentialsProvider.lookupCredentials(TokenCredentials.class, (Item)project, (Authentication)ACL.SYSTEM, Collections.emptyList())) {
                String label;
                String string = label = c.getId().isEmpty() ? c.getDescription() : c.getId();
                if (label == null || label.isEmpty()) {
                    label = c.getId();
                }
                items.add(label, c.getId());
            }
            items.add("None", "");
            return items;
        }

        @POST
        public ListBoxModel doFillDastScanTypeItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Spider Only", "spider");
            items.add("Active Scan Only", "active");
            items.add("Full Scan", "full");
            return items;
        }

        @POST
        public ListBoxModel doFillAwsRegistryTypeItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("ECR Public", "ecr-public");
            items.add("ECR Private", "ecr-private");
            return items;
        }

        @POST
        public ListBoxModel doFillDockerAuthMethodItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("None (Public Images)", "none");
            items.add("Username/Password", "username-password");
            return items;
        }

        @POST
        public ListBoxModel doFillQuayAuthenticateFieldsItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("None (Public Images)", "none");
            items.add("Username/Password", "username-password");
            items.add("Access Token", "token");
            return items;
        }

        @POST
        public ListBoxModel doFillAzureAuthenticateFieldsItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Username/Password", "username-password");
            items.add("Access Token", "token");
            return items;
        }

        @POST
        public ListBoxModel doFillAzureRegistryTypeItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Microsoft Container Registry", "mcr");
            items.add("Private Azure CR", "acr-private");
            return items;
        }

        @POST
        public ListBoxModel doFillGitRegistryTypeItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("None (Public Images)", "none");
            items.add("Access Token", "token");
            return items;
        }

        @POST
        public ListBoxModel doFillGoogleRegistryTypeItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Container Registry", "gcr");
            items.add("Artifact Registry", "artifact-registry");
            return items;
        }

        @POST
        public ListBoxModel doFillGoogleAuthenticateFieldsItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("None (Public Images)", "none");
            items.add("Access Token", "token");
            return items;
        }

        @POST
        public ListBoxModel doFillRegistryProviderItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Docker Hub", "dockerhub");
            items.add("AWS ECR", "aws-ecr");
            items.add("GitHub Container Registry", "github");
            items.add("GitLab Container Registry", "gitlab");
            items.add("Google Container Registry", "google");
            items.add("Azure Container Registry", "azure");
            items.add("Quay.io", "quay");
            return items;
        }

        public boolean isApplicable(Class jobType) {
            return true;
        }

        @POST
        public FormValidation doCheckCredentialsId(@AncestorInPath Item project, @QueryParameter String credentialsId) {
            if (project != null && !project.hasPermission(Item.CONFIGURE)) {
                return FormValidation.error((String)"No permission to configure this project");
            }
            if (project == null) {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            }
            if (credentialsId == null || credentialsId.trim().isEmpty()) {
                return FormValidation.error((String)"Credentials selection is required");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckScanTypes(@AncestorInPath Item project, @QueryParameter String value) {
            if (project != null && !project.hasPermission(Item.CONFIGURE)) {
                return FormValidation.error((String)"No permission to configure this project");
            }
            if (project == null) {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            }
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"You must select at least one scan type.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckImageName(@QueryParameter String imageName) {
            if (imageName == null || imageName.isEmpty()) {
                return FormValidation.error((String)"Image name is required");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckTargetSiteUrl(@QueryParameter String targetSiteUrl) {
            if (targetSiteUrl == null || targetSiteUrl.isEmpty()) {
                return FormValidation.error((String)"Target Url is required");
            }
            return FormValidation.ok();
        }
    }
}

