/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.vigilnz.pipeline;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.vigilnz.credentials.TokenCredentials;
import io.jenkins.plugins.vigilnz.models.ApiRequest;
import io.jenkins.plugins.vigilnz.models.ContainerScanContext;
import io.jenkins.plugins.vigilnz.pipeline.PipelineStepExecution;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.verb.POST;

public class PipelineStep
extends Step {
    private final String credentialsId;
    private final String scanTypes;
    private String projectName;
    private ApiRequest.ScanContext dastScanContext = new ApiRequest.ScanContext("", "");
    private ContainerScanContext containerScanContext = new ContainerScanContext("", "");
    private boolean cveScan;
    private boolean sastScan;
    private boolean sbomScan;
    private boolean iacScan;
    private boolean secretScan;

    @DataBoundConstructor
    public PipelineStep(String credentialsId, String scanTypes) {
        this.credentialsId = credentialsId;
        this.scanTypes = scanTypes;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getScanTypes() {
        if (this.scanTypes != null && !this.scanTypes.trim().isEmpty()) {
            return this.scanTypes;
        }
        ArrayList<String> types = new ArrayList<String>();
        if (this.cveScan) {
            types.add("SCA");
        }
        if (this.sastScan) {
            types.add("SAST");
        }
        if (this.sbomScan) {
            types.add("SBOM");
        }
        if (this.iacScan) {
            types.add("IAC");
        }
        if (this.secretScan) {
            types.add("SECRET");
        }
        return String.join((CharSequence)",", types);
    }

    @DataBoundSetter
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new PipelineStepExecution(this, context);
    }

    public ApiRequest.ScanContext getDastScanContext() {
        return this.dastScanContext;
    }

    @DataBoundSetter
    public void setDastScanContext(ApiRequest.ScanContext dastScanContext) {
        this.dastScanContext = dastScanContext;
    }

    public boolean isCveScan() {
        return this.cveScan;
    }

    public void setCveScan(boolean cveScan) {
        this.cveScan = cveScan;
    }

    public boolean isSastScan() {
        return this.sastScan;
    }

    public void setSastScan(boolean sastScan) {
        this.sastScan = sastScan;
    }

    public boolean isSbomScan() {
        return this.sbomScan;
    }

    public void setSbomScan(boolean sbomScan) {
        this.sbomScan = sbomScan;
    }

    public boolean isIacScan() {
        return this.iacScan;
    }

    public void setIacScan(boolean iacScan) {
        this.iacScan = iacScan;
    }

    public boolean isSecretScan() {
        return this.secretScan;
    }

    public void setSecretScan(boolean secretScan) {
        this.secretScan = secretScan;
    }

    public ContainerScanContext getContainerScanContext() {
        return this.containerScanContext;
    }

    @DataBoundSetter
    public void setContainerScanContext(ContainerScanContext containerScanContext) {
        this.containerScanContext = containerScanContext;
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "vigilnzScan";
        }

        @Nonnull
        public String getDisplayName() {
            return "Run Vigilnz Security Scan";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Set.of(TaskListener.class, Run.class, FilePath.class);
        }

        @POST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project) {
            ListBoxModel items = new ListBoxModel();
            for (TokenCredentials c : CredentialsProvider.lookupCredentials(TokenCredentials.class, (Item)project, (Authentication)ACL.SYSTEM, Collections.emptyList())) {
                String label;
                String string = label = c.getId().isEmpty() ? c.getDescription() : c.getId();
                if (label.isEmpty()) {
                    label = c.getId();
                }
                items.add(label, c.getId());
            }
            items.add("None", "");
            return items;
        }

        @POST
        public ListBoxModel doFillDastScanTypeItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Spider Only", "spider");
            items.add("Active Scan Only", "active");
            items.add("Full Scan", "full");
            return items;
        }
    }
}

