/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.vigilnz.ui;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.vigilnz.api.ApiService;
import io.jenkins.plugins.vigilnz.credentials.TokenCredentials;
import io.jenkins.plugins.vigilnz.models.ApiResponse;
import io.jenkins.plugins.vigilnz.utils.VigilnzConfig;
import java.io.IOException;
import java.util.List;
import jenkins.model.RunAction2;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class ScanResultAction
implements RunAction2 {
    private ApiResponse response;
    private transient Run<?, ?> run;

    public ScanResultAction(String scanSummary, String apiKeyId) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        ApiResponse apiResponse = (ApiResponse)mapper.readValue(scanSummary, ApiResponse.class);
        apiResponse.setApiKey(apiKeyId);
        this.setResponse(apiResponse);
        this.response = apiResponse;
    }

    public boolean getIsScanCompleted() {
        try {
            JSONObject payload = new JSONObject();
            payload.put("scanDetails", this.response.getScanInfo());
            payload.put("resultMethod", (Object)true);
            TokenCredentials creds = (TokenCredentials)CredentialsProvider.findCredentialById((String)this.response.getApiKey(), TokenCredentials.class, this.run);
            if (creds == null) {
                return false;
            }
            VigilnzConfig.setBaseUrl(creds.getEnvironment());
            String apiResult = ApiService.fetchScanResults(creds.getToken().getPlainText(), payload, TaskListener.NULL, true);
            ObjectMapper mapper = new ObjectMapper();
            ApiResponse apiResponse = (ApiResponse)mapper.readValue(apiResult, ApiResponse.class);
            apiResponse.setApiKey(this.response.getApiKey());
            this.setResponse(apiResponse);
            boolean allCompleted = this.isAllCompleted();
            apiResponse.setAllScanCompleted(allCompleted);
            return allCompleted;
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean isAllCompleted() {
        List<ApiResponse.ScanResults> scanResultsList = this.response.getScanResults();
        List<ApiResponse.ScanInfo> scanInfoList = this.response.getScanInfo();
        if (scanResultsList == null || scanResultsList.isEmpty()) {
            return false;
        }
        for (ApiResponse.ScanInfo scanInfo : scanInfoList) {
            for (ApiResponse.ScanResults scanResults : scanResultsList) {
                if (!scanInfo.getScanTargetId().equals(scanResults.getScanTargetId()) || !scanInfo.getScanType().equalsIgnoreCase(scanResults.getScanType()) || "COMPLETED".equalsIgnoreCase(scanResults.getStatus())) continue;
                return false;
            }
        }
        return true;
    }

    public String getTotalFindingsBySeverity(String severity) {
        if (this.response.getScanResults() == null) {
            return "0";
        }
        int value = this.response.getScanResults().stream().mapToInt(res -> switch (severity.toLowerCase()) {
            case "critical" -> res.getDetails().getCriticalFindings();
            case "high" -> res.getDetails().getHighFindings();
            case "medium" -> res.getDetails().getMediumFindings();
            case "low" -> res.getDetails().getLowFindings();
            default -> 0;
        }).sum();
        return String.valueOf(value);
    }

    public String getIconFileName() {
        return "symbol-reader-outline plugin-ionicons-api";
    }

    public String getSiteUrl(String res) {
        String siteUrl = VigilnzConfig.getBaseSiteUrl();
        return switch (res.toLowerCase()) {
            case "secret" -> siteUrl + "/secret-scan";
            case "iac" -> siteUrl + "/iac-scan";
            case "cve", "sca" -> siteUrl + "/sca";
            default -> siteUrl + "/" + res.toLowerCase();
        };
    }

    public String getDisplayName() {
        return "Vigilnz Scan Results";
    }

    public String getUrlName() {
        return "vigilnzResult";
    }

    public ApiResponse getResponse() {
        return this.response;
    }

    public void setResponse(ApiResponse response) {
        this.response = response;
    }

    public Run<?, ?> getRun() {
        return this.run;
    }

    public void onAttached(Run<?, ?> r) {
        this.run = r;
    }

    public void onLoad(Run<?, ?> r) {
        this.run = r;
    }
}

