/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.vigilnz.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ApiResponse {
    private String repositoryId;
    private String repoUrl;
    private String projectName;
    private String repoName;
    private String apiKey;
    private String message;
    private boolean isAllScanCompleted;
    private List<ScanInfo> scanInfo;
    private List<ScanResults> scanResults;
    private List<String> scanTypes;

    public boolean isAllScanCompleted() {
        return this.isAllScanCompleted;
    }

    public void setAllScanCompleted(boolean allScanCompleted) {
        this.isAllScanCompleted = allScanCompleted;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public List<String> getScanTypes() {
        return this.scanTypes;
    }

    public void setScanTypes(List<String> scanTypes) {
        this.scanTypes = scanTypes;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getRepoUrl() {
        return this.repoUrl;
    }

    public void setRepoUrl(String repoUrl) {
        this.repoUrl = repoUrl;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getRepoName() {
        return this.repoName;
    }

    public void setRepoName(String repoName) {
        this.repoName = repoName;
    }

    public List<ScanInfo> getScanInfo() {
        return this.scanInfo;
    }

    public void setScanInfo(List<ScanInfo> scanInfo) {
        List<String> scanTypesList = scanInfo.stream().map(ScanInfo::getScanType).toList();
        this.setScanTypes(scanTypesList);
        this.scanInfo = scanInfo;
    }

    public List<ScanResults> getScanResults() {
        return this.scanResults;
    }

    public void setScanResults(List<ScanResults> scanResults) {
        this.scanResults = scanResults;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ScanResults {
        private String scanTargetId;
        private String scanType;
        private String status;
        private int progress;
        private String branchName;
        private Details details;
        private String language;

        public String getScanTargetId() {
            return this.scanTargetId;
        }

        public void setScanTargetId(String scanTargetId) {
            this.scanTargetId = scanTargetId;
        }

        public String getScanType() {
            return this.scanType;
        }

        public void setScanType(String scanType) {
            this.scanType = scanType;
        }

        public String getBranchName() {
            return this.branchName;
        }

        public void setBranchName(String branchName) {
            this.branchName = branchName;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getLanguage() {
            return this.language;
        }

        public void setLanguage(String language) {
            this.language = language;
        }

        public Details getDetails() {
            return this.details;
        }

        public void setDetails(Details details) {
            this.details = details;
        }

        public int getProgress() {
            return this.progress;
        }

        public void setProgress(int progress) {
            this.progress = progress;
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class Details {
            private int totalFindings;
            private int criticalFindings;
            private int highFindings;
            private int mediumFindings;
            private int lowFindings;
            private int riskScore;
            private int totalDependencies;
            private int directDependencies;
            private int transitiveDependencies;
            private int uniquePackages;

            public int getTotalDependencies() {
                return this.totalDependencies;
            }

            public void setTotalDependencies(int totalDependencies) {
                this.totalDependencies = totalDependencies;
            }

            public int getDirectDependencies() {
                return this.directDependencies;
            }

            public void setDirectDependencies(int directDependencies) {
                this.directDependencies = directDependencies;
            }

            public int getTransitiveDependencies() {
                return this.transitiveDependencies;
            }

            public void setTransitiveDependencies(int transitiveDependencies) {
                this.transitiveDependencies = transitiveDependencies;
            }

            public int getUniquePackages() {
                return this.uniquePackages;
            }

            public void setUniquePackages(int uniquePackages) {
                this.uniquePackages = uniquePackages;
            }

            public int getTotalFindings() {
                return this.totalFindings;
            }

            public void setTotalFindings(int totalFindings) {
                this.totalFindings = totalFindings;
            }

            public int getCriticalFindings() {
                return this.criticalFindings;
            }

            public void setCriticalFindings(int criticalFindings) {
                this.criticalFindings = criticalFindings;
            }

            public int getHighFindings() {
                return this.highFindings;
            }

            public void setHighFindings(int highFindings) {
                this.highFindings = highFindings;
            }

            public int getMediumFindings() {
                return this.mediumFindings;
            }

            public void setMediumFindings(int mediumFindings) {
                this.mediumFindings = mediumFindings;
            }

            public int getLowFindings() {
                return this.lowFindings;
            }

            public void setLowFindings(int lowFindings) {
                this.lowFindings = lowFindings;
            }

            public int getRiskScore() {
                return this.riskScore;
            }

            public void setRiskScore(int riskScore) {
                this.riskScore = riskScore;
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ScanInfo {
        private String scanTargetId;
        private String scanType;

        public String getScanTargetId() {
            return this.scanTargetId;
        }

        public void setScanTargetId(String scanTargetId) {
            this.scanTargetId = scanTargetId;
        }

        public String getScanType() {
            return this.scanType;
        }

        public void setScanType(String scanType) {
            this.scanType = scanType;
        }
    }
}

