/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.vigilnz.pipeline;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.vigilnz.pipeline.PipelineStepExecution;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class PipelineStep
extends Step {
    private final String credentialsId;
    private final List<String> scanTypes;
    private String projectName;

    @DataBoundConstructor
    public PipelineStep(String credentialsId, String scanTypes) {
        this.credentialsId = credentialsId;
        if (scanTypes != null && !scanTypes.trim().isEmpty()) {
            List<String> scanTypeList = Arrays.asList(scanTypes.split("\\s*,\\s*"));
            this.scanTypes = scanTypeList.stream().map(s -> s.equalsIgnoreCase("sca") ? "cve" : s).collect(Collectors.toList());
        } else {
            this.scanTypes = List.of();
        }
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    @DataBoundSetter
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public List<String> getScanTypes() {
        return this.scanTypes != null ? this.scanTypes : List.of();
    }

    public StepExecution start(StepContext context) throws Exception {
        return new PipelineStepExecution(this, context);
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "vigilnzScan";
        }

        @Nonnull
        public String getDisplayName() {
            return "Run Vigilnz Security Scan";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Set.of(TaskListener.class, Run.class, FilePath.class);
        }
    }
}

