/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.vigilnz.build;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.cli.shaded.org.apache.commons.lang.StringUtils;
import io.jenkins.plugins.vigilnz.api.ApiService;
import io.jenkins.plugins.vigilnz.credentials.TokenCredentials;
import io.jenkins.plugins.vigilnz.models.ApiResponse;
import io.jenkins.plugins.vigilnz.ui.ScanResultAction;
import io.jenkins.plugins.vigilnz.utils.VigilnzConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class SecurityCheckBuilder
extends Builder {
    private final String credentialsId;
    private String projectName;
    private boolean cveScan;
    private boolean sastScan;
    private boolean sbomScan;
    private boolean iacScan;
    private boolean secretScan;
    private boolean dastScan;
    private boolean containerScan;

    @DataBoundConstructor
    public SecurityCheckBuilder(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    @DataBoundSetter
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public boolean isCveScan() {
        return this.cveScan;
    }

    @DataBoundSetter
    public void setCveScan(boolean cveScan) {
        this.cveScan = cveScan;
    }

    public boolean isSastScan() {
        return this.sastScan;
    }

    @DataBoundSetter
    public void setSastScan(boolean sastScan) {
        this.sastScan = sastScan;
    }

    public boolean isSbomScan() {
        return this.sbomScan;
    }

    @DataBoundSetter
    public void setSbomScan(boolean sbomScan) {
        this.sbomScan = sbomScan;
    }

    public boolean isSecretScan() {
        return this.secretScan;
    }

    @DataBoundSetter
    public void setSecretScan(boolean secretScan) {
        this.secretScan = secretScan;
    }

    public boolean isDastScan() {
        return this.dastScan;
    }

    @DataBoundSetter
    public void setDastScan(boolean dastScan) {
        this.dastScan = dastScan;
    }

    public boolean isContainerScan() {
        return this.containerScan;
    }

    @DataBoundSetter
    public void setContainerScan(boolean containerScan) {
        this.containerScan = containerScan;
    }

    public boolean isIacScan() {
        return this.iacScan;
    }

    @DataBoundSetter
    public void setIacScan(boolean iacScan) {
        this.iacScan = iacScan;
    }

    public List<String> getScanTypes() {
        ArrayList<String> types = new ArrayList<String>();
        if (this.cveScan) {
            types.add("cve");
        }
        if (this.sastScan) {
            types.add("sast");
        }
        if (this.sbomScan) {
            types.add("sbom");
        }
        if (this.iacScan) {
            types.add("iac");
        }
        if (this.secretScan) {
            types.add("secret");
        }
        if (this.dastScan) {
            types.add("dast");
        }
        if (this.containerScan) {
            types.add("mscan");
        }
        return types;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        EnvVars env = build.getEnvironment((TaskListener)listener);
        listener.getLogger().println("------ Freestyle Method ------");
        List<String> scanTypes = this.getScanTypes();
        if (scanTypes.isEmpty()) {
            listener.error("Error: At least one scan type must be selected.");
            this.attachResult(build, this.buildErrorResponse("At least one scan type must be selected."));
            return false;
        }
        if (this.credentialsId == null || this.credentialsId.trim().isEmpty()) {
            listener.error("Error: Credentials ID is required. Please select a credential in the build step configuration.");
            this.attachResult(build, this.buildErrorResponse("Credentials ID is required."));
            return false;
        }
        TokenCredentials creds = (TokenCredentials)CredentialsProvider.findCredentialById((String)this.credentialsId, TokenCredentials.class, (Run)build);
        if (creds == null) {
            listener.error("Error: Vigilnz Token credential not found with ID: " + this.credentialsId);
            this.attachResult(build, this.buildErrorResponse("Vigilnz Token credential not found with ID: " + this.credentialsId));
            return false;
        }
        String tokenText = creds.getToken().getPlainText();
        VigilnzConfig.setBaseUrl(creds.getEnvironment());
        if (this.projectName != null && !this.projectName.trim().isEmpty()) {
            listener.getLogger().println("Project Name: " + this.projectName);
        } else {
            listener.getLogger().println("Target File: (not specified)");
        }
        listener.getLogger().println("Selected Scan Types: " + String.join((CharSequence)", ", scanTypes));
        String result = "";
        try {
            result = ApiService.triggerScan(tokenText, this.projectName, scanTypes, env, (TaskListener)listener);
            if (result != null && !result.isEmpty()) {
                build.addAction((Action)new ScanResultAction(result, this.credentialsId));
            } else {
                listener.getLogger().println("API call failed, no action added.");
            }
        }
        catch (Exception e) {
            listener.error("Scan failed");
            this.attachResult(build, this.buildErrorResponse("Scan failed: " + e.getMessage()));
            build.addAction((Action)new ScanResultAction(new ApiResponse().toString(), ""));
            return false;
        }
        return true;
    }

    private void attachResult(AbstractBuild build, String json) {
        try {
            build.addAction((Action)new ScanResultAction(json, ""));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String buildErrorResponse(String message) {
        ApiResponse resp = new ApiResponse();
        resp.setMessage(message);
        try {
            return new ObjectMapper().writeValueAsString((Object)resp);
        }
        catch (JsonProcessingException e) {
            return "{\"message\":\"" + message.replace("\"", "\\\"") + "\"}";
        }
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public String getDisplayName() {
            return "Invoke Vigilnz Security Task";
        }

        @POST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project) {
            if (project == null || !project.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            ListBoxModel items = new ListBoxModel();
            for (TokenCredentials c : CredentialsProvider.lookupCredentials(TokenCredentials.class, (Item)project, (Authentication)ACL.SYSTEM, Collections.emptyList())) {
                String label;
                String string = label = c.getId().isEmpty() ? c.getDescription() : c.getId();
                if (label == null || label.isEmpty()) {
                    label = c.getId();
                }
                items.add(label, c.getId());
            }
            items.add("None", "");
            return items;
        }

        public boolean isApplicable(Class jobType) {
            return true;
        }

        @POST
        public FormValidation doCheckCredentialsId(@AncestorInPath Item project, @QueryParameter String credentialsId) {
            if (project != null && !project.hasPermission(Item.CONFIGURE)) {
                return FormValidation.error((String)"No permission to configure this project");
            }
            if (project == null) {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            }
            if (credentialsId == null || credentialsId.trim().isEmpty()) {
                return FormValidation.error((String)"Credentials selection is required");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckScanType(@AncestorInPath Item project, @QueryParameter String value) {
            if (project != null && !project.hasPermission(Item.CONFIGURE)) {
                return FormValidation.error((String)"No permission to configure this project");
            }
            if (project == null) {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            }
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"You must select at least one scan type.");
            }
            return FormValidation.ok();
        }
    }
}

