/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.vigilnz.credentials;

import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.Secret;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.DataBoundConstructor;

public class TokenCredentials
extends BaseStandardCredentials
implements StringCredentials {
    private final Secret token;

    @DataBoundConstructor
    public TokenCredentials(CredentialsScope scope, String id, String description, Secret token) {
        super(scope, id, description);
        if (token == null || Secret.toString((Secret)token).isEmpty()) {
            throw new IllegalArgumentException("Token is required");
        }
        this.token = token;
    }

    public Secret getToken() {
        return this.token;
    }

    @NonNull
    public Secret getSecret() {
        return this.token;
    }

    @Symbol(value={"vigilnzToken"})
    @Extension
    public static class DescriptorImpl
    extends CredentialsDescriptor {
        public String getDisplayName() {
            return "Vigilnz Security Token";
        }
    }
}

