/*
 * Decompiled with CFR 0.152.
 */
package hudson.views;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Run;
import hudson.model.TopLevelItem;
import hudson.model.User;
import hudson.scm.ChangeLogSet;
import hudson.util.ReflectionUtils;
import hudson.views.AbstractBuildTrendFilter;
import hudson.views.EmailValuesHelper;
import hudson.views.JenkinsUtil;
import hudson.views.ViewJobFilter;
import hudson.views.filters.Messages;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import org.kohsuke.stapler.DataBoundConstructor;

public class UserRelevanceFilter
extends AbstractBuildTrendFilter {
    private static final String ANONYMOUS = Hudson.ANONYMOUS2.getName().toUpperCase(Locale.ROOT);
    private boolean matchUserId = true;
    private boolean matchUserFullName = true;
    private boolean ignoreCase = true;
    private boolean ignoreWhitespace = true;
    private boolean ignoreNonAlphaNumeric = true;
    private boolean matchBuilder = true;
    private boolean matchEmail = true;
    private boolean matchScmChanges = true;

    @DataBoundConstructor
    public UserRelevanceFilter(boolean matchUserId, boolean matchUserFullName, boolean ignoreCase, boolean ignoreWhitespace, boolean ignoreNonAlphaNumeric, boolean matchBuilder, boolean matchEmail, boolean matchScmChanges, String buildCountTypeString, float amount, String amountTypeString, String includeExcludeTypeString) {
        super(buildCountTypeString, amount, amountTypeString, includeExcludeTypeString);
        this.matchUserId = matchUserId;
        this.matchUserFullName = matchUserFullName;
        if (!matchUserId && !matchUserFullName) {
            this.matchUserId = true;
        }
        this.ignoreCase = ignoreCase;
        this.ignoreWhitespace = ignoreWhitespace;
        this.ignoreNonAlphaNumeric = ignoreNonAlphaNumeric;
        this.matchBuilder = matchBuilder;
        this.matchEmail = matchEmail;
        this.matchScmChanges = matchScmChanges;
    }

    @Override
    protected boolean matches(TopLevelItem item) {
        boolean matched;
        if (this.matchEmail && (matched = this.matchesEmail(item))) {
            return true;
        }
        return super.matches(item);
    }

    @Override
    public boolean matchesRun(Run run) {
        String userId;
        String userName;
        User user = this.getUser();
        if (user == null) {
            return false;
        }
        if (this.matchUserFullName && this.runMatches(userName = this.normalize(user.getFullName()), true, run)) {
            return true;
        }
        return this.matchUserId && this.runMatches(userId = this.normalize(user.getId()), false, run);
    }

    private User getUser() {
        try {
            return JenkinsUtil.getInstance().getMe();
        }
        catch (Exception e) {
            try {
                return JenkinsUtil.getInstance().getUser(Hudson.ANONYMOUS2.getName());
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    public boolean runMatches(String userName, boolean matchAgainstFullName, Run run) {
        boolean matches;
        if (this.matchScmChanges && (matches = this.matchesChangeLog(userName, matchAgainstFullName, run))) {
            return true;
        }
        return this.matchBuilder && (matches = this.matchesUserCause(userName, matchAgainstFullName, run));
    }

    public String normalize(String userName) {
        if (this.ignoreCase) {
            userName = userName.toUpperCase(Locale.ROOT);
        }
        if (!this.ignoreNonAlphaNumeric && !this.ignoreWhitespace) {
            return userName;
        }
        StringBuilder buf = new StringBuilder();
        int len = userName.length();
        for (int i = 0; i < len; ++i) {
            char c = userName.charAt(i);
            if (this.ignoreNonAlphaNumeric && !Character.isLetterOrDigit(c) || this.ignoreWhitespace && Character.isWhitespace(c)) continue;
            buf.append(c);
        }
        return buf.toString();
    }

    public boolean matchesEmail(TopLevelItem item) {
        String userId;
        String userName;
        User user = this.getUser();
        if (user == null) {
            return false;
        }
        if (this.matchUserFullName && this.matchesEmail(item, userName = this.normalize(user.getFullName()))) {
            return true;
        }
        return this.matchUserId && this.matchesEmail(item, userId = this.normalize(user.getId()));
    }

    public boolean matchesEmail(TopLevelItem item, String user) {
        List<String> emails = EmailValuesHelper.getValues(item);
        return this.matchesEmail(emails, user);
    }

    public boolean matchesEmail(List<String> emails, String user) {
        for (String email : emails) {
            boolean matched = this.matchSplitEmailToUserNames(user, email);
            if (!matched) continue;
            return true;
        }
        return false;
    }

    public boolean matchSplitEmailToUserNames(String user, String email) {
        String[] split;
        for (String one : split = email.split("[\\s;,]+")) {
            int index = one.indexOf("@");
            if (index > 0) {
                one = one.substring(0, index);
            }
            if (!(one = this.normalize(one)).equals(user)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesUserCause(String userName, boolean matchAgainstFullName, Run run) {
        for (Object causeObject : run.getCauses()) {
            Cause cause = (Cause)causeObject;
            String builderName = this.getUserValue(cause, matchAgainstFullName);
            boolean matches = userName.equals(builderName);
            if (!matches) continue;
            return true;
        }
        return false;
    }

    public String getUserValue(Cause cause, boolean matchAgainstFullName) {
        String builderName = matchAgainstFullName ? this.getUserValue(cause, "getUserName") : this.getUserValue(cause, "getUserId");
        if (builderName == null) {
            builderName = ANONYMOUS;
        }
        return builderName;
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
    public String getUserValue(Cause cause, String methodName) {
        Method m = ReflectionUtils.getPublicMethodNamed(cause.getClass(), (String)methodName);
        if (m == null) {
            return null;
        }
        try {
            String value = (String)m.invoke((Object)cause, (Object[])null);
            if (value != null) {
                value = this.normalize(value);
            }
            return value;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean matchesChangeLog(String userName, boolean matchAgainstFullName, Run run) {
        if (run instanceof AbstractBuild) {
            AbstractBuild build = (AbstractBuild)run;
            ChangeLogSet set = build.getChangeSet();
            for (ChangeLogSet.Entry entry : set) {
                User changeUser = entry.getAuthor();
                String userMatchPart = matchAgainstFullName ? changeUser.getFullName() : changeUser.getId();
                String changeUserName = this.normalize(userMatchPart);
                if (!userName.equals(changeUserName)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean isMatchUserId() {
        return this.matchUserId;
    }

    public boolean isMatchUserFullName() {
        return this.matchUserFullName;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public boolean isIgnoreWhitespace() {
        return this.ignoreWhitespace;
    }

    public boolean isIgnoreNonAlphaNumeric() {
        return this.ignoreNonAlphaNumeric;
    }

    public boolean isMatchBuilder() {
        return this.matchBuilder;
    }

    public boolean isMatchEmail() {
        return this.matchEmail;
    }

    public boolean isMatchScmChanges() {
        return this.matchScmChanges;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ViewJobFilter> {
        public String getDisplayName() {
            return Messages.UserRelevanceFilter_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/view-job-filters/user-relevance-help.html";
        }
    }
}

