/*
 * Decompiled with CFR 0.152.
 */
package hudson.views;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.views.PluginHelperUtils;
import hudson.views.UpstreamDownstreamMavenHelper;
import hudson.views.ViewJobFilter;
import hudson.views.filters.Messages;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

public class UpstreamDownstreamJobsFilter
extends ViewJobFilter {
    private boolean includeDownstream;
    private boolean includeUpstream;
    private boolean recursive;
    private boolean excludeOriginals;
    private static final transient Logger log = Logger.getLogger("updown");
    private static final transient UpstreamDownstreamMavenHelper mavenHelper = UpstreamDownstreamJobsFilter.buildMavenHelper();

    @DataBoundConstructor
    public UpstreamDownstreamJobsFilter(boolean includeDownstream, boolean includeUpstream, boolean recursive, boolean excludeOriginals) {
        this.includeDownstream = includeDownstream;
        this.excludeOriginals = excludeOriginals;
        this.includeUpstream = includeUpstream;
        this.recursive = recursive;
    }

    public List<TopLevelItem> filter(List<TopLevelItem> added, List<TopLevelItem> all, View filteringView) {
        HashSet<TopLevelItem> filtered = new HashSet<TopLevelItem>();
        for (TopLevelItem next : added) {
            if (this.includeUpstream) {
                HashSet<TopLevelItem> filteredUpstream = new HashSet<TopLevelItem>();
                this.addUpstream(next, filteredUpstream, all);
                filtered.addAll(filteredUpstream);
            }
            if (!this.includeDownstream) continue;
            HashSet<TopLevelItem> filteredDownstream = new HashSet<TopLevelItem>();
            this.addDownstream(next, filteredDownstream, all);
            filtered.addAll(filteredDownstream);
        }
        ArrayList<TopLevelItem> sorted = new ArrayList<TopLevelItem>(all);
        if (!this.excludeOriginals) {
            filtered.addAll(added);
        }
        sorted.retainAll(filtered);
        return sorted;
    }

    public void addUpstream(TopLevelItem current, Set<TopLevelItem> filtered, List<TopLevelItem> all) {
        for (TopLevelItem next : all) {
            boolean isFirstUpstreamFromSecond;
            if (filtered.contains(next) || !(isFirstUpstreamFromSecond = this.isFirstUpstreamFromSecond(next, current))) continue;
            filtered.add(next);
            if (!this.recursive) continue;
            this.addUpstream(next, filtered, all);
        }
    }

    public void addDownstream(TopLevelItem current, Set<TopLevelItem> filtered, List<TopLevelItem> all) {
        for (TopLevelItem next : all) {
            boolean isFirstUpstreamFromSecond;
            if (filtered.contains(next) || !(isFirstUpstreamFromSecond = this.isFirstUpstreamFromSecond(current, next))) continue;
            filtered.add(next);
            if (!this.recursive) continue;
            this.addDownstream(next, filtered, all);
        }
    }

    private boolean isFirstUpstreamFromSecond(TopLevelItem first, TopLevelItem second) {
        boolean isUpstream = false;
        if (second instanceof AbstractProject) {
            AbstractProject secondProject = (AbstractProject)second;
            List upstream = secondProject.getUpstreamProjects();
            isUpstream = upstream.contains(first);
        }
        if (!isUpstream && mavenHelper != null) {
            isUpstream = mavenHelper.isFirstUpstreamFromSecond(first, second);
        }
        return isUpstream;
    }

    public boolean isIncludeDownstream() {
        return this.includeDownstream;
    }

    public boolean isIncludeUpstream() {
        return this.includeUpstream;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public boolean isExcludeOriginals() {
        return this.excludeOriginals;
    }

    private static UpstreamDownstreamMavenHelper buildMavenHelper() {
        log.warning("buildMavenHelper");
        try {
            UpstreamDownstreamMavenHelper helper = PluginHelperUtils.validateAndThrow(new UpstreamDownstreamMavenHelper());
            log.warning("buildMavenHelper." + String.valueOf(helper));
            return helper;
        }
        catch (Throwable t) {
            log.warning("buildMavenHelper.null");
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ViewJobFilter> {
        public String getDisplayName() {
            return Messages.UpstreamDownstreamJobsFilter_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/view-job-filters/upstream-downstream-help.html";
        }
    }
}

