/*
 * Decompiled with CFR 0.152.
 */
package hudson.views;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.ListView;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.util.FormValidation;
import hudson.views.AbstractIncludeExcludeJobFilter;
import hudson.views.ViewGraph;
import hudson.views.ViewJobFilter;
import hudson.views.filters.Messages;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class UnclassifiedJobsFilter
extends AbstractIncludeExcludeJobFilter {
    @DataBoundConstructor
    public UnclassifiedJobsFilter(String includeExcludeTypeString) {
        super(includeExcludeTypeString);
    }

    @Override
    protected void doFilter(List<TopLevelItem> filtered, List<TopLevelItem> all, View filteringView) {
        ViewGraph viewGraph = new ViewGraph();
        List<TopLevelItem> classified = this.getAllClassifiedItems(viewGraph.getViewsNotInCycles(), all.size(), filteringView);
        for (TopLevelItem item : all) {
            boolean matched = !classified.contains(item);
            this.filterItem(filtered, item, matched);
        }
    }

    private List<TopLevelItem> getAllClassifiedItems(Set<View> allViews, int allJobsCount, View filteringView) {
        ArrayList<TopLevelItem> classified = new ArrayList<TopLevelItem>();
        for (View otherView : allViews) {
            Collection items;
            if (otherView == filteringView || (items = otherView.getItems()).size() >= allJobsCount) continue;
            classified.addAll(items);
        }
        return classified;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ViewJobFilter> {
        public String getDisplayName() {
            return Messages.UnclassifiedJobsFilter_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/view-job-filters/unclassified-jobs-help.html";
        }

        public FormValidation doCheck(@QueryParameter String viewName) throws IOException, ServletException, InterruptedException {
            View thisView = ViewGraph.getView(viewName);
            if (thisView == null) {
                return FormValidation.warning((String)Messages.UnclassifiedJobsFilter_Validation_CannotValidate());
            }
            ListView thisViewNew = new ListView(thisView.getViewName());
            thisViewNew.getJobFilters().add((Object)new UnclassifiedJobsFilter(AbstractIncludeExcludeJobFilter.IncludeExcludeType.includeMatched.name()));
            Map<String, View> views = ViewGraph.getAllViewsByName();
            views.put(ViewGraph.toName(thisView), (View)thisViewNew);
            ViewGraph viewGraph = new ViewGraph(views);
            if (viewGraph.getViewsInCycles().contains(thisViewNew)) {
                List<View> cycle = viewGraph.getFirstCycleWithView((View)thisViewNew);
                cycle.set(cycle.indexOf(thisViewNew), thisView);
                return FormValidation.error((String)Messages.UnclassifiedJobsFilter_Validation_CircularViewDefinition(ViewGraph.toName(cycle)));
            }
            return FormValidation.ok();
        }
    }
}

