/*
 * Decompiled with CFR 0.152.
 */
package hudson.views;

import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.SCMedItem;
import hudson.model.TopLevelItem;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.views.AbstractIncludeExcludeJobFilter;
import hudson.views.ViewJobFilter;
import hudson.views.filters.Messages;
import java.util.ArrayList;
import java.util.List;
import jenkins.triggers.SCMTriggerItem;
import org.kohsuke.stapler.DataBoundConstructor;

public class ScmTypeFilter
extends AbstractIncludeExcludeJobFilter {
    private String scmType;

    @DataBoundConstructor
    public ScmTypeFilter(String scmType, String includeExcludeTypeString) {
        super(includeExcludeTypeString);
        this.scmType = scmType;
    }

    public SCMDescriptor getScmType() {
        List<SCMDescriptor> types = ((DescriptorImpl)this.getDescriptor()).getScmTypes();
        for (SCMDescriptor type : types) {
            if (!this.matches(type)) continue;
            return type;
        }
        return null;
    }

    private boolean matches(SCMDescriptor type) {
        if (type.clazz.getName().equals(this.scmType)) {
            return true;
        }
        return type.getDisplayName().equals(this.scmType);
    }

    @Override
    protected boolean matches(TopLevelItem item) {
        SCMedItem sitem;
        SCM scm;
        SCMDescriptor descriptor;
        if (item instanceof SCMedItem && this.matches(descriptor = (scm = (sitem = (SCMedItem)item).getScm()).getDescriptor())) {
            return true;
        }
        if (item instanceof SCMTriggerItem) {
            sitem = (SCMTriggerItem)item;
            for (SCM scm2 : sitem.getSCMs()) {
                if (!this.matches(scm2.getDescriptor())) continue;
                return true;
            }
        }
        return false;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ViewJobFilter> {
        public String getDisplayName() {
            return Messages.ScmTypeFilter_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/view-job-filters/scm-type-help.html";
        }

        public List<SCMDescriptor> getScmTypes() {
            ArrayList<SCMDescriptor> types = new ArrayList<SCMDescriptor>();
            DescriptorExtensionList scms = SCM.all();
            for (SCMDescriptor scm : scms) {
                types.add(scm);
            }
            return types;
        }
    }
}

