/*
 * Decompiled with CFR 0.152.
 */
package hudson.views;

import hudson.Extension;
import hudson.model.BooleanParameterValue;
import hudson.model.ChoiceParameterDefinition;
import hudson.model.Descriptor;
import hudson.model.FileParameterValue;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Run;
import hudson.model.StringParameterValue;
import hudson.model.TopLevelItem;
import hudson.views.AbstractIncludeExcludeJobFilter;
import hudson.views.RunMatcher;
import hudson.views.ViewJobFilter;
import hudson.views.filters.Messages;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class ParameterFilter
extends AbstractIncludeExcludeJobFilter
implements RunMatcher {
    private String nameRegex;
    private transient Pattern namePattern;
    private String valueRegex;
    private transient Pattern valuePattern;
    private String descriptionRegex;
    private transient Pattern descriptionPattern;
    private Boolean useDefaultValue = Boolean.TRUE;
    private boolean matchBuildsInProgress;
    private boolean matchAllBuilds;
    private int maxBuildsToMatch;

    @DataBoundConstructor
    public ParameterFilter(String includeExcludeTypeString, String nameRegex, String valueRegex, String descriptionRegex, boolean useDefaultValue, boolean matchAllBuilds, int maxBuildsToMatch, boolean matchBuildsInProgress) {
        super(includeExcludeTypeString);
        this.nameRegex = nameRegex;
        this.valueRegex = valueRegex;
        this.descriptionRegex = descriptionRegex;
        this.namePattern = this.toPattern(nameRegex);
        this.valuePattern = this.toPattern(valueRegex);
        this.descriptionPattern = this.toPattern(descriptionRegex);
        this.useDefaultValue = useDefaultValue;
        this.matchAllBuilds = matchAllBuilds;
        this.maxBuildsToMatch = maxBuildsToMatch;
        this.matchBuildsInProgress = matchBuildsInProgress;
    }

    @Override
    Object readResolve() {
        if (this.nameRegex != null) {
            this.namePattern = this.toPattern(this.nameRegex);
        }
        if (this.valueRegex != null) {
            this.valuePattern = this.toPattern(this.valueRegex);
        }
        if (this.descriptionRegex != null) {
            this.descriptionPattern = this.toPattern(this.descriptionRegex);
        }
        if (this.useDefaultValue == null) {
            this.useDefaultValue = Boolean.TRUE;
        }
        return super.readResolve();
    }

    private Pattern toPattern(String regex) {
        if (StringUtils.isEmpty((String)regex)) {
            return null;
        }
        return Pattern.compile(regex);
    }

    @Override
    protected boolean matches(TopLevelItem item) {
        if (item instanceof Job) {
            Job job = (Job)item;
            if (this.useDefaultValue.booleanValue()) {
                return this.matchesDefaultValue(job);
            }
            return this.matchesBuildValue(job);
        }
        return false;
    }

    protected boolean matchesDefaultValue(Job job) {
        ParametersDefinitionProperty property = (ParametersDefinitionProperty)job.getProperty(ParametersDefinitionProperty.class);
        if (property != null) {
            List defs = property.getParameterDefinitions();
            for (ParameterDefinition def : defs) {
                boolean multiline = this.isValueMultiline(def);
                String svalue = this.getStringValue(def);
                boolean matches = this.matchesParameter(def.getName(), svalue, multiline, def.getDescription());
                if (!matches) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean matchesBuildValue(Job job) {
        boolean matched = false;
        int count = 1;
        Run run = job.getLastBuild();
        while (run != null && !matched) {
            boolean isBuilding = run.isBuilding();
            if (this.matchBuildsInProgress || !isBuilding) {
                matched = this.matchesRun(run);
                if (!this.matchAllBuilds || this.maxBuildsToMatch > 0 && count >= this.maxBuildsToMatch) break;
            }
            run = run.getPreviousBuild();
            ++count;
        }
        return matched;
    }

    @Override
    public boolean matchesRun(Run run) {
        ParametersAction action = (ParametersAction)run.getAction(ParametersAction.class);
        if (action == null) {
            return false;
        }
        for (ParameterValue value : action.getParameters()) {
            String sval = this.getStringValue(value);
            if (!this.matchesParameter(value.getName(), sval, false, null)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesParameter(String name, String value, boolean isValueMultiline, String description) {
        if (!this.matches(this.namePattern, name, false)) {
            return false;
        }
        if (!this.matches(this.valuePattern, value, isValueMultiline)) {
            return false;
        }
        return description == null || this.matches(this.descriptionPattern, description, true);
    }

    protected String getStringValue(ParameterDefinition definition) {
        if (definition instanceof ChoiceParameterDefinition) {
            return ((ChoiceParameterDefinition)definition).getChoicesText();
        }
        ParameterValue value = definition.getDefaultParameterValue();
        return this.getStringValue(value);
    }

    private boolean isValueMultiline(ParameterDefinition def) {
        return def instanceof ChoiceParameterDefinition;
    }

    protected String getStringValue(ParameterValue value) {
        if (value instanceof StringParameterValue) {
            return ((StringParameterValue)value).getValue();
        }
        if (value instanceof BooleanParameterValue) {
            boolean bval = ((BooleanParameterValue)value).value;
            return String.valueOf(bval);
        }
        if (value instanceof FileParameterValue) {
            String file = ((FileParameterValue)value).getOriginalFileName();
            return file;
        }
        return String.valueOf(value);
    }

    private boolean matches(Pattern p, String m, boolean multiline) {
        if (p == null) {
            return true;
        }
        if (m == null) {
            return false;
        }
        Matcher matcher = p.matcher(m);
        if (multiline) {
            return matcher.find();
        }
        return matcher.matches();
    }

    public String getNameRegex() {
        return this.nameRegex;
    }

    public String getValueRegex() {
        return this.valueRegex;
    }

    public String getDescriptionRegex() {
        return this.descriptionRegex;
    }

    public boolean isUseDefaultValue() {
        return this.useDefaultValue;
    }

    public boolean isMatchAllBuilds() {
        return this.matchAllBuilds;
    }

    public int getMaxBuildsToMatch() {
        return this.maxBuildsToMatch;
    }

    public boolean isMatchBuildsInProgress() {
        return this.matchBuildsInProgress;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ViewJobFilter> {
        public String getDisplayName() {
            return Messages.ParameterFilter_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/view-job-filters/parameter-help.html";
        }
    }
}

