/*
 * Decompiled with CFR 0.152.
 */
package hudson.views;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.TopLevelItem;
import hudson.views.AbstractEmailValuesProvider;
import hudson.views.CoreEmailValuesProvider;
import hudson.views.EmailExtValuesProvider;
import hudson.views.EmailMavenValuesProvider;
import hudson.views.PluginHelperUtils;
import java.util.ArrayList;
import java.util.List;

public class EmailValuesHelper {
    private static List<AbstractEmailValuesProvider> matchers = EmailValuesHelper.buildMatchers();

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    public static List<String> getValues(TopLevelItem item) {
        ArrayList<String> values = new ArrayList<String>();
        if (item == null) {
            return values;
        }
        for (AbstractEmailValuesProvider matcher : matchers) {
            List<String> some = matcher.getValues(item);
            if (some == null) continue;
            values.addAll(some);
        }
        return values;
    }

    private static List<AbstractEmailValuesProvider> buildMatchers() {
        ArrayList<AbstractEmailValuesProvider> matchers = new ArrayList<AbstractEmailValuesProvider>();
        try {
            matchers.add(PluginHelperUtils.validateAndThrow(new CoreEmailValuesProvider()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            matchers.add(EmailValuesHelper.buildEmailExt());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            matchers.add(EmailValuesHelper.buildEmailMaven());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return matchers;
    }

    private static AbstractEmailValuesProvider buildEmailExt() {
        return PluginHelperUtils.validateAndThrow(new EmailExtValuesProvider());
    }

    private static AbstractEmailValuesProvider buildEmailMaven() {
        return PluginHelperUtils.validateAndThrow(new EmailMavenValuesProvider());
    }
}

