/*
 * Decompiled with CFR 0.152.
 */
package hudson.views;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TopLevelItem;
import hudson.views.AbstractIncludeExcludeJobFilter;
import hudson.views.ViewJobFilter;
import hudson.views.filters.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class BuildStatusFilter
extends AbstractIncludeExcludeJobFilter {
    private boolean neverBuilt;
    private boolean building;
    private boolean inBuildQueue;

    @DataBoundConstructor
    public BuildStatusFilter(boolean neverBuilt, boolean building, boolean inBuildQueue, String includeExcludeTypeString) {
        super(includeExcludeTypeString);
        this.neverBuilt = neverBuilt;
        this.building = building;
        this.inBuildQueue = inBuildQueue;
    }

    @Override
    protected boolean matches(TopLevelItem item) {
        if (item instanceof Job) {
            Job job = (Job)item;
            if (this.building && job.isBuilding()) {
                return true;
            }
            if (this.inBuildQueue && job.isInQueue()) {
                return true;
            }
            Run last = job.getLastBuild();
            if (last == null && this.neverBuilt) {
                return true;
            }
        }
        return false;
    }

    public boolean isNeverBuilt() {
        return this.neverBuilt;
    }

    public boolean isBuilding() {
        return this.building;
    }

    public boolean isInBuildQueue() {
        return this.inBuildQueue;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ViewJobFilter> {
        public String getDisplayName() {
            return Messages.BuildStatusFilter_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/view-job-filters/build-status-help.html";
        }
    }
}

