/*
 * Decompiled with CFR 0.152.
 */
package hudson.views;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.ListView;
import hudson.model.Run;
import hudson.model.TopLevelItem;
import hudson.model.TopLevelItemDescriptor;
import hudson.model.View;
import hudson.util.RunList;
import hudson.views.JenkinsUtil;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import hudson.views.RunMatcher;
import hudson.views.ViewJobFilter;
import hudson.views.filters.Messages;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Logger;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;

public class BuildFilterColumn
extends ListViewColumn {
    private static final Logger LOGGER = Logger.getLogger(BuildFilterColumn.class.getName());
    private ListViewColumn delegate;
    private ListView view;

    @DataBoundConstructor
    public BuildFilterColumn(ListViewColumn delegate) {
        this.delegate = delegate;
    }

    public BuildFilterColumn(ListViewColumn delegate, ListView view) {
        this(delegate);
        this.view = view;
    }

    public static List doGetAllColumns() {
        DescriptorExtensionList all = ListViewColumn.all();
        ArrayList list = new ArrayList();
        for (Object descriptor : all) {
            if (descriptor instanceof DescriptorImpl) continue;
            list.add(descriptor);
        }
        return list;
    }

    public ListViewColumn getDelegate() {
        return this.delegate;
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
    public Job getJobWrapper(final Job job) {
        final JobWrapper wrapper = new JobWrapper(job);
        try {
            ProxyFactory factory = new ProxyFactory();
            factory.setSuperclass(job.getClass());
            MethodHandler handler = new MethodHandler(){

                public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
                    if (BuildFilterColumn.this.matches(thisMethod, args, "_getRuns", new Class[0]) && thisMethod.getReturnType().equals(SortedMap.class)) {
                        return wrapper._getRuns();
                    }
                    if (BuildFilterColumn.this.matches(thisMethod, args, "getBuilds", new Class[0])) {
                        return wrapper.getBuilds();
                    }
                    if (BuildFilterColumn.this.matches(thisMethod, args, "getLastBuild", new Class[0])) {
                        return wrapper.getLastBuild();
                    }
                    if (BuildFilterColumn.this.matches(thisMethod, args, "getIconColor", new Class[0])) {
                        return wrapper.getIconColor();
                    }
                    if (BuildFilterColumn.this.matches(thisMethod, args, "getBuildHealthReports", new Class[0])) {
                        return wrapper.getBuildHealthReports();
                    }
                    return thisMethod.invoke((Object)job, args);
                }
            };
            return (Job)factory.create(new Class[]{ItemGroup.class, String.class}, new Object[]{job.getParent(), job.getName()}, handler);
        }
        catch (Exception e) {
            LOGGER.info("Can't proxy job of type " + String.valueOf(job.getClass()) + ": " + e.getMessage());
            LOGGER.info("Falling back to simple wrapper object");
            return wrapper;
        }
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
    public Run getRunWrapper(final Run run) {
        final RunWrapper wrapper = new RunWrapper(run);
        try {
            ProxyFactory factory = new ProxyFactory();
            factory.setSuperclass(run.getClass());
            MethodHandler handler = new MethodHandler(){

                public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
                    if (BuildFilterColumn.this.matches(thisMethod, args, "_this", new Class[0])) {
                        return wrapper._this();
                    }
                    if (BuildFilterColumn.this.matches(thisMethod, args, "getNextBuild", new Class[0])) {
                        return wrapper.getNextBuild();
                    }
                    if (BuildFilterColumn.this.matches(thisMethod, args, "getPreviousBuild", new Class[0])) {
                        return wrapper.getPreviousBuild();
                    }
                    return thisMethod.invoke((Object)run, args);
                }
            };
            return (Run)factory.create(new Class[]{run.getParent().getClass()}, new Object[]{run.getParent()}, handler);
        }
        catch (Exception e) {
            LOGGER.info("Can't proxy build of type " + String.valueOf(run.getClass()) + ": " + e.getMessage());
            LOGGER.info("Falling back to simple wrapper object");
            return wrapper;
        }
    }

    private boolean matches(Method method, Object[] args, String name, Class ... argTypes) {
        if (!method.getName().equals(name)) {
            return false;
        }
        if (args.length != argTypes.length) {
            return false;
        }
        for (int i = 0; i < argTypes.length; ++i) {
            if (argTypes[i].isInstance(args[i])) continue;
            return false;
        }
        return true;
    }

    private boolean matchesRun(Run run) {
        for (ViewJobFilter filter : this.view.getJobFilters()) {
            RunMatcher matcher;
            if (!(filter instanceof RunMatcher) || (matcher = (RunMatcher)filter).matchesRun(run)) continue;
            return false;
        }
        return true;
    }

    @Extension
    public static class DescriptorImpl
    extends ListViewColumnDescriptor {
        public String getDisplayName() {
            return Messages.BuildFilterColumn_DisplayName();
        }

        public ListViewColumn newInstance(StaplerRequest2 req, JSONObject obj) throws Descriptor.FormException {
            BuildFilterColumn col;
            try {
                col = (BuildFilterColumn)super.newInstance(req, obj);
            }
            catch (Exception e) {
                ListViewColumn delegate;
                try {
                    delegate = this.newInstanceFromClass(req, obj);
                }
                catch (Exception e1) {
                    throw new IllegalArgumentException("Unable to wrap column:" + e.getMessage() + "/" + String.valueOf(obj), e1);
                }
                col = new BuildFilterColumn(delegate);
            }
            if (req != null) {
                View view = (View)req.findAncestorObject(View.class);
                if (view instanceof ListView) {
                    col.view = (ListView)view;
                } else {
                    throw new IllegalArgumentException("BuildFilterColumn can only be added to a ListView");
                }
            }
            return col;
        }

        private ListViewColumn newInstanceFromClass(StaplerRequest2 req, JSONObject obj) throws ClassNotFoundException, InstantiationException, IllegalAccessException, Descriptor.FormException {
            JSONObject delegate = obj.getJSONObject("delegate");
            String staplerClass = delegate.getString("stapler-class");
            Descriptor desc = JenkinsUtil.getInstance().getDescriptor(staplerClass);
            ListViewColumn col = (ListViewColumn)desc.newInstance(req, delegate);
            return col;
        }

        public boolean shownByDefault() {
            return false;
        }
    }

    public class JobWrapper
    extends Job
    implements TopLevelItem {
        private final Job delegate;

        public JobWrapper(Job delegate) {
            super(delegate.getParent(), delegate.getName());
            this.delegate = delegate;
        }

        public Run getLastBuild() {
            SortedMap<Integer, Run> runs = this._getRuns();
            Integer id = runs.lastKey();
            if (id != null) {
                return (Run)runs.get(id);
            }
            return null;
        }

        public RunList getBuilds() {
            return RunList.fromRuns(this._getRuns().values());
        }

        protected SortedMap<Integer, Run> _getRuns() {
            TreeMap<Integer, Run> builds = new TreeMap<Integer, Run>();
            SortedMap buildsAsMap = this.delegate.getBuildsAsMap();
            for (Map.Entry entry : buildsAsMap.entrySet()) {
                if (!BuildFilterColumn.this.matchesRun((Run)entry.getValue())) continue;
                builds.put((Integer)entry.getKey(), BuildFilterColumn.this.getRunWrapper((Run)entry.getValue()));
            }
            return builds;
        }

        public boolean isBuildable() {
            return this.delegate.isBuildable();
        }

        protected void removeRun(Run run) {
        }

        public TopLevelItemDescriptor getDescriptor() {
            return ((TopLevelItem)this.delegate).getDescriptor();
        }
    }

    public class RunWrapper
    extends Run {
        private final Run delegate;

        public RunWrapper(Run delegate) {
            super(delegate.getParent(), delegate.getTimestamp());
            this.delegate = delegate;
        }

        @NonNull
        protected Run _this() {
            return this;
        }

        @CheckForNull
        public Run getPreviousBuild() {
            for (Run i = this.delegate.getPreviousBuild(); i != null; i = i.getPreviousBuild()) {
                if (!BuildFilterColumn.this.matchesRun(i)) continue;
                return BuildFilterColumn.this.getRunWrapper(i);
            }
            return null;
        }

        @CheckForNull
        public Run getNextBuild() {
            for (Run i = this.delegate.getNextBuild(); i != null; i = i.getNextBuild()) {
                if (!BuildFilterColumn.this.matchesRun(i)) continue;
                return BuildFilterColumn.this.getRunWrapper(i);
            }
            return null;
        }
    }
}

