/*
 * Decompiled with CFR 0.152.
 */
package hudson.views;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.views.ViewJobFilter;
import hudson.views.filters.Messages;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

public class AddRemoveFallbackFilter
extends ViewJobFilter {
    private String fallbackTypeString;
    private FallbackTypes fallbackType;

    @DataBoundConstructor
    public AddRemoveFallbackFilter(String fallbackTypeString) {
        this.fallbackTypeString = fallbackTypeString;
        this.fallbackType = FallbackTypes.valueOf(fallbackTypeString);
    }

    Object readResolve() {
        if (this.fallbackTypeString != null) {
            this.fallbackType = FallbackTypes.valueOf(this.fallbackTypeString);
        }
        return this;
    }

    public String getFallbackTypeString() {
        return this.fallbackTypeString;
    }

    public List<TopLevelItem> filter(List<TopLevelItem> added, List<TopLevelItem> all, View filteringView) {
        if (this.fallbackType == FallbackTypes.ADD_ALL_IF_NONE_INCLUDED && added.size() == 0) {
            return new ArrayList<TopLevelItem>(all);
        }
        if (this.fallbackType == FallbackTypes.REMOVE_ALL_IF_ALL_INCLUDED && added.size() == all.size()) {
            return new ArrayList<TopLevelItem>();
        }
        return added;
    }

    static enum FallbackTypes {
        ADD_ALL_IF_NONE_INCLUDED,
        REMOVE_ALL_IF_ALL_INCLUDED;

    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ViewJobFilter> {
        public String getDisplayName() {
            return Messages.AddRemoveFallbackFilter_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/view-job-filters/add-remove-fallback-help.html";
        }
    }
}

