/*
 * Decompiled with CFR 0.152.
 */
package hudson.views;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.TopLevelItem;
import hudson.views.AbstractIncludeExcludeJobFilter;
import hudson.views.ViewJobFilter;
import hudson.views.filters.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class SecurityFilter
extends AbstractIncludeExcludeJobFilter {
    public static final String ALL = "MustMatchAll";
    public static final String ONE = "AtLeastOne";
    private boolean configure;
    private boolean build;
    private boolean workspace;
    private String permissionCheckType;

    @DataBoundConstructor
    public SecurityFilter(String permissionCheckType, boolean configure, boolean build, boolean workspace, String includeExcludeTypeString) {
        super(includeExcludeTypeString);
        this.configure = configure;
        this.build = build;
        this.workspace = workspace;
        this.permissionCheckType = permissionCheckType;
    }

    @Override
    protected boolean matches(TopLevelItem item) {
        boolean all = this.permissionCheckType.equals(ALL);
        if (all) {
            return !(this.configure && !item.getACL().hasPermission(Item.CONFIGURE) || this.build && !item.getACL().hasPermission(Item.BUILD) || this.workspace && !item.getACL().hasPermission(Item.WORKSPACE));
        }
        return this.configure && item.getACL().hasPermission(Item.CONFIGURE) || this.build && item.getACL().hasPermission(Item.BUILD) || this.workspace && item.getACL().hasPermission(Item.WORKSPACE);
    }

    public String getPermissionCheckType() {
        return this.permissionCheckType;
    }

    public boolean isConfigure() {
        return this.configure;
    }

    public boolean isBuild() {
        return this.build;
    }

    public boolean isWorkspace() {
        return this.workspace;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ViewJobFilter> {
        public String getDisplayName() {
            return Messages.SecurityFilter_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/view-job-filters/security-help.html";
        }
    }
}

