/*
 * Decompiled with CFR 0.152.
 */
package hudson.views;

import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.SCMedItem;
import hudson.model.TopLevelItem;
import hudson.scm.SCM;
import hudson.util.FormValidation;
import hudson.views.AbstractIncludeExcludeJobFilter;
import hudson.views.EmailValuesHelper;
import hudson.views.MavenValuesHelper;
import hudson.views.ScmFilterHelper;
import hudson.views.TriggerFilterHelper;
import hudson.views.ViewJobFilter;
import hudson.views.filters.Messages;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jenkins.triggers.SCMTriggerItem;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class RegExJobFilter
extends AbstractIncludeExcludeJobFilter {
    private transient ValueType valueType;
    private String valueTypeString;
    private String regex;
    private transient Pattern pattern;
    private boolean matchName;
    private boolean matchFullName;
    private boolean matchDisplayName;
    private boolean matchFullDisplayName;

    public RegExJobFilter(String regex, String includeExcludeTypeString, String valueTypeString) {
        this(regex, includeExcludeTypeString, valueTypeString, true, false, false, false);
    }

    @DataBoundConstructor
    public RegExJobFilter(String regex, String includeExcludeTypeString, String valueTypeString, boolean matchName, boolean matchFullName, boolean matchDisplayName, boolean matchFullDisplayName) {
        super(includeExcludeTypeString);
        this.regex = regex;
        this.pattern = Pattern.compile(regex);
        this.valueTypeString = valueTypeString;
        this.valueType = ValueType.valueOf(valueTypeString);
        this.matchName = matchName;
        this.matchFullName = matchFullName;
        this.matchDisplayName = matchDisplayName;
        this.matchFullDisplayName = matchFullDisplayName;
        this.initOptions();
    }

    @Override
    Object readResolve() {
        if (this.regex != null) {
            this.pattern = Pattern.compile(this.regex);
        }
        if (this.valueTypeString != null) {
            this.valueType = ValueType.valueOf(this.valueTypeString);
        }
        this.initOptions();
        return super.readResolve();
    }

    private void initOptions() {
        if (!(this.matchName || this.matchFullName || this.matchDisplayName || this.matchFullDisplayName)) {
            this.matchName = true;
        }
    }

    @Override
    public boolean matches(TopLevelItem item) {
        List<String> matchValues = this.valueType.getMatchValues(item, this.getOptions());
        for (String matchValue : matchValues) {
            if (matchValue == null || !this.pattern.matcher(matchValue).matches()) continue;
            return true;
        }
        return false;
    }

    public String getRegex() {
        return this.regex;
    }

    public String getValueTypeString() {
        return this.valueTypeString;
    }

    public boolean isMatchName() {
        return this.matchName;
    }

    public boolean isMatchFullName() {
        return this.matchFullName;
    }

    public boolean isMatchDisplayName() {
        return this.matchDisplayName;
    }

    public boolean isMatchFullDisplayName() {
        return this.matchFullDisplayName;
    }

    public Options getOptions() {
        return new Options(this.matchName, this.matchFullName, this.matchDisplayName, this.matchFullDisplayName);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ValueType {
        NAME{

            @Override
            void doGetMatchValues(TopLevelItem item, Options options, List<String> values) {
                if (options.matchName) {
                    values.add(item.getName());
                }
                if (options.matchFullName) {
                    values.add(item.getFullName());
                }
                if (options.matchDisplayName) {
                    values.add(item.getDisplayName());
                }
                if (options.matchFullDisplayName) {
                    values.add(item.getFullDisplayName());
                }
            }
        }
        ,
        DESCRIPTION{

            @Override
            void doGetMatchValues(TopLevelItem item, Options options, List<String> values) {
                if (item instanceof AbstractItem) {
                    ValueType.addSplitValues(values, ((AbstractItem)item).getDescription());
                }
            }
        }
        ,
        SCM{

            @Override
            void doGetMatchValues(TopLevelItem item, Options options, List<String> values) {
                Object scm;
                if (item instanceof AbstractProject) {
                    scm = ((AbstractProject)item).getScm();
                    values.addAll(ScmFilterHelper.getValues((SCM)scm));
                }
                if (item instanceof SCMTriggerItem) {
                    for (SCM scm2 : ((SCMTriggerItem)item).getSCMs()) {
                        values.addAll(ScmFilterHelper.getValues(scm2));
                    }
                }
                if (item instanceof SCMedItem) {
                    scm = ((SCMedItem)item).getScm();
                    values.addAll(ScmFilterHelper.getValues((SCM)scm));
                }
            }
        }
        ,
        EMAIL{

            @Override
            void doGetMatchValues(TopLevelItem item, Options options, List<String> values) {
                values.addAll(EmailValuesHelper.getValues(item));
            }
        }
        ,
        MAVEN{

            @Override
            void doGetMatchValues(TopLevelItem item, Options options, List<String> values) {
                values.addAll(MavenValuesHelper.getValues(item));
            }
        }
        ,
        SCHEDULE{

            @Override
            void doGetMatchValues(TopLevelItem item, Options options, List<String> values) {
                for (String scheduleValue : TriggerFilterHelper.getValues(item)) {
                    ValueType.addSplitValues(values, scheduleValue);
                }
            }
        }
        ,
        NODE{

            @Override
            void doGetMatchValues(TopLevelItem item, Options options, List<String> values) {
                if (item instanceof AbstractProject) {
                    String node = ((AbstractProject)item).getAssignedLabelString();
                    values.add(node);
                }
            }
        }
        ,
        FOLDER_NAME{

            @Override
            void doGetMatchValues(TopLevelItem item, Options options, List<String> values) {
                if (item.getParent() != null) {
                    if (options.matchName && item.getParent() instanceof Item) {
                        values.add(((Item)item.getParent()).getName());
                    }
                    if (options.matchFullName) {
                        values.add(item.getParent().getFullName());
                    }
                    if (options.matchDisplayName) {
                        values.add(item.getParent().getDisplayName());
                    }
                    if (options.matchFullDisplayName) {
                        values.add(item.getParent().getFullDisplayName());
                    }
                }
            }
        };


        private static void addSplitValues(List<String> values, String value) {
            if (value != null) {
                String[] split;
                for (String s : split = value.split("\n", -1)) {
                    values.add(s.trim());
                }
            }
        }

        abstract void doGetMatchValues(TopLevelItem var1, Options var2, List<String> var3);

        public List<String> getMatchValues(TopLevelItem item, Options options) {
            ArrayList<String> values = new ArrayList<String>();
            this.doGetMatchValues(item, options, values);
            return values;
        }
    }

    public static class Options {
        public final boolean matchName;
        public final boolean matchFullName;
        public final boolean matchDisplayName;
        public final boolean matchFullDisplayName;

        public Options(boolean matchName, boolean matchFullName, boolean matchDisplayName, boolean matchFullDisplayName) {
            this.matchName = matchName;
            this.matchFullName = matchFullName;
            this.matchDisplayName = matchDisplayName;
            this.matchFullDisplayName = matchFullDisplayName;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ViewJobFilter> {
        public String getDisplayName() {
            return Messages.RegExJobFilter_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/view-job-filters/regex-help.html";
        }

        public FormValidation doCheckRegex(@QueryParameter String value) throws IOException, ServletException, InterruptedException {
            String v = Util.fixEmpty((String)value);
            if (v != null) {
                try {
                    Pattern.compile(v);
                }
                catch (PatternSyntaxException pse) {
                    return FormValidation.error((String)pse.getMessage());
                }
            }
            return FormValidation.ok();
        }
    }
}

