/*
 * Decompiled with CFR 0.152.
 */
package hudson.views;

import hudson.model.Project;
import hudson.model.TopLevelItem;
import hudson.tasks.Builder;
import hudson.tasks.Maven;
import hudson.views.MatrixProjectBuildersHelper;
import hudson.views.MavenProjectValuesHelper;
import hudson.views.PluginHelperUtils;
import java.util.ArrayList;
import java.util.List;

public class MavenValuesHelper {
    public static final MavenProjectValuesHelper MODULESET_HELPER = MavenValuesHelper.buildMavenProjectValuesHelper();
    public static final MatrixProjectBuildersHelper MATRIX_PROJECT_HELPER = MavenValuesHelper.buildMatrixProjectBuildersHelper();

    public static List<String> getValues(TopLevelItem item) {
        ArrayList<String> values = new ArrayList<String>();
        if (item instanceof Project) {
            Project project = (Project)item;
            List builders = project.getBuilders();
            MavenValuesHelper.addValues(values, builders);
        } else if (MATRIX_PROJECT_HELPER != null) {
            List<Builder> builders = MATRIX_PROJECT_HELPER.getBuilders(item);
            MavenValuesHelper.addValues(values, builders);
        }
        if (MODULESET_HELPER != null) {
            List<String> more = MODULESET_HELPER.getValues(item);
            values.addAll(more);
        }
        return values;
    }

    public static void addValues(List<String> values, List<Builder> builders) {
        if (builders != null) {
            for (Builder builder : builders) {
                if (!(builder instanceof Maven)) continue;
                Maven maven = (Maven)builder;
                values.add(MavenValuesHelper.getTargets(maven));
                values.add(maven.jvmOptions);
                values.add(maven.properties);
                Maven.MavenInstallation install = maven.getMaven();
                if (install == null) continue;
                values.add(install.getName());
            }
        }
    }

    private static String getTargets(Maven maven) {
        String t = maven.getTargets();
        t = MavenValuesHelper.normalize(t);
        return t;
    }

    static String normalize(String s) {
        if (s != null) {
            s = s.replace('\n', ' ');
        }
        return s;
    }

    private static MavenProjectValuesHelper buildMavenProjectValuesHelper() {
        try {
            return PluginHelperUtils.validateAndThrow(new MavenProjectValuesHelper());
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static MatrixProjectBuildersHelper buildMatrixProjectBuildersHelper() {
        try {
            return PluginHelperUtils.validateAndThrow(new MatrixProjectBuildersHelper());
        }
        catch (Throwable t) {
            return null;
        }
    }
}

