/*
 * Decompiled with CFR 0.152.
 */
package hudson.views;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.TopLevelItem;
import hudson.model.TopLevelItemDescriptor;
import hudson.views.AbstractIncludeExcludeJobFilter;
import hudson.views.ViewJobFilter;
import hudson.views.filters.Messages;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

public class JobTypeFilter
extends AbstractIncludeExcludeJobFilter {
    private String jobType;

    @DataBoundConstructor
    public JobTypeFilter(String jobType, String includeExcludeTypeString) {
        super(includeExcludeTypeString);
        this.jobType = jobType;
    }

    public TopLevelItemDescriptor getJobType() {
        for (TopLevelItemDescriptor type : Items.all()) {
            if (!type.getId().equals(this.jobType)) continue;
            return type;
        }
        return null;
    }

    @Override
    protected boolean matches(TopLevelItem item) {
        TopLevelItemDescriptor d = this.getJobType();
        return d != null && d.testInstance(item);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ViewJobFilter> {
        public String getDisplayName() {
            return Messages.JobTypeFilter_DisplayName();
        }

        public List<TopLevelItemDescriptor> getJobTypes(ItemGroup<?> context) {
            return DescriptorVisibilityFilter.apply(context, (Iterable)Items.all());
        }

        public String getHelpFile() {
            return "/plugin/view-job-filters/job-type-help.html";
        }
    }
}

