/*
 * Decompiled with CFR 0.152.
 */
package hudson.views;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TopLevelItem;
import hudson.views.AbstractIncludeExcludeJobFilter;
import hudson.views.ViewJobFilter;
import hudson.views.filters.Messages;
import jenkins.model.ParameterizedJobMixIn;
import org.kohsuke.stapler.DataBoundConstructor;

public class JobStatusFilter
extends AbstractIncludeExcludeJobFilter {
    private boolean unstable;
    private boolean failed;
    private boolean aborted;
    private boolean disabled;
    private boolean stable;

    @DataBoundConstructor
    public JobStatusFilter(boolean unstable, boolean failed, boolean aborted, boolean disabled, boolean stable, String includeExcludeTypeString) {
        super(includeExcludeTypeString);
        this.unstable = unstable;
        this.failed = failed;
        this.aborted = aborted;
        this.disabled = disabled;
        this.stable = stable;
    }

    @Override
    protected boolean matches(TopLevelItem item) {
        Job job;
        Run last;
        if (item instanceof ParameterizedJobMixIn.ParameterizedJob) {
            ParameterizedJobMixIn.ParameterizedJob project = (ParameterizedJobMixIn.ParameterizedJob)item;
            if (this.disabled && project.isDisabled()) {
                return true;
            }
        }
        if (item instanceof Job && (last = (job = (Job)item).getLastCompletedBuild()) != null) {
            Result result = last.getResult();
            if (this.stable && result == Result.SUCCESS) {
                return true;
            }
            if (this.aborted && result == Result.ABORTED) {
                return true;
            }
            if (this.failed && result == Result.FAILURE) {
                return true;
            }
            if (this.unstable && result == Result.UNSTABLE) {
                return true;
            }
        }
        return false;
    }

    public boolean isUnstable() {
        return this.unstable;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isStable() {
        return this.stable;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ViewJobFilter> {
        public String getDisplayName() {
            return Messages.JobStatusFilter_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/view-job-filters/job-status-help.html";
        }
    }
}

