/*
 * Decompiled with CFR 0.152.
 */
package hudson.views;

import hudson.scm.CVSSCM;
import hudson.scm.CvsModule;
import hudson.scm.CvsRepository;
import hudson.scm.CvsRepositoryItem;
import hudson.scm.SCM;
import hudson.views.AbstractScmValuesProvider;
import java.util.ArrayList;
import java.util.List;

public class CvsValuesProvider
extends AbstractScmValuesProvider {
    @Override
    public Class getPluginTesterClass() {
        return CVSSCM.class;
    }

    @Override
    public List<String> getValues(SCM scm) {
        if (!(scm instanceof CVSSCM)) {
            return null;
        }
        CVSSCM cvs = (CVSSCM)scm;
        ArrayList<String> values = new ArrayList<String>();
        CvsRepository[] repos = cvs.getRepositories();
        if (repos != null) {
            for (CvsRepository repo : repos) {
                values.add(repo.getCvsRoot());
                CvsRepositoryItem[] items = repo.getRepositoryItems();
                if (items == null) continue;
                for (CvsRepositoryItem item : items) {
                    values.add(item.getLocation().getLocationName());
                    CvsModule[] modules = item.getModules();
                    if (modules == null) continue;
                    for (CvsModule module : modules) {
                        values.add(module.getCheckoutName());
                        values.add(module.getLocalName());
                        values.add(module.getProjectsetFileName());
                        values.add(module.getRemoteName());
                    }
                }
            }
        }
        return values;
    }
}

