/*
 * Decompiled with CFR 0.152.
 */
package hudson.views;

import hudson.Extension;
import hudson.cli.BuildCommand;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.triggers.SCMTrigger;
import hudson.triggers.TimerTrigger;
import hudson.views.AbstractBuildTrendFilter;
import hudson.views.ViewJobFilter;
import hudson.views.filters.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class BuildTrendFilter
extends AbstractBuildTrendFilter {
    private transient StatusType statusType;
    private String statusTypeString;

    @DataBoundConstructor
    public BuildTrendFilter(String buildCountTypeString, String statusTypeString, float amount, String amountTypeString, String includeExcludeTypeString) {
        super(buildCountTypeString, amount, amountTypeString, includeExcludeTypeString);
        this.statusTypeString = statusTypeString;
        this.statusType = StatusType.valueOf(statusTypeString);
    }

    @Override
    Object readResolve() {
        if (this.statusTypeString != null) {
            this.statusType = StatusType.valueOf(this.statusTypeString);
        }
        return super.readResolve();
    }

    @Override
    public boolean matchesRun(Run run) {
        return this.statusType.matches(run);
    }

    public String getStatusTypeString() {
        return this.statusTypeString;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum StatusType {
        Started{

            @Override
            public boolean matches(Run run) {
                return !run.hasntStartedYet();
            }
        }
        ,
        Completed{

            @Override
            public boolean matches(Result result) {
                return result != Result.ABORTED && result != Result.NOT_BUILT;
            }
        }
        ,
        Stable{

            @Override
            public boolean matches(Result result) {
                return result == Result.SUCCESS;
            }
        }
        ,
        Unstable{

            @Override
            public boolean matches(Result result) {
                return result == Result.UNSTABLE;
            }
        }
        ,
        Failed{

            @Override
            public boolean matches(Result result) {
                return result == Result.FAILURE;
            }
        }
        ,
        NotStable{

            @Override
            public boolean matches(Result result) {
                return result == Result.FAILURE || result == Result.UNSTABLE || result == Result.ABORTED;
            }
        }
        ,
        TriggeredByScmPoll(true){

            @Override
            protected boolean matchesCause(Cause cause) {
                return cause instanceof SCMTrigger.SCMTriggerCause;
            }
        }
        ,
        TriggeredByTimer(true){

            @Override
            protected boolean matchesCause(Cause cause) {
                return cause instanceof TimerTrigger.TimerTriggerCause;
            }
        }
        ,
        TriggeredByUser(true){

            @Override
            protected boolean matchesCause(Cause cause) {
                return (cause instanceof Cause.UserCause || cause instanceof Cause.UserIdCause) && !(cause instanceof BuildCommand.CLICause);
            }
        }
        ,
        TriggeredByRemote(true){

            @Override
            protected boolean matchesCause(Cause cause) {
                return cause instanceof Cause.RemoteCause;
            }
        }
        ,
        TriggeredByUpstream(true){

            @Override
            protected boolean matchesCause(Cause cause) {
                return cause instanceof Cause.UpstreamCause || cause instanceof Cause.UpstreamCause.DeeplyNestedUpstreamCause;
            }
        }
        ,
        TriggeredByCli(true){

            @Override
            protected boolean matchesCause(Cause cause) {
                return cause instanceof BuildCommand.CLICause;
            }
        };

        private boolean matchCause = false;

        public boolean matchesCause(Run run) {
            for (Object causeObject : run.getCauses()) {
                Cause cause = (Cause)causeObject;
                if (!this.matchesCause(cause)) continue;
                return true;
            }
            return false;
        }

        protected boolean matchesCause(Cause cause) {
            return false;
        }

        public boolean matches(Run run) {
            if (this.matchCause) {
                return this.matchesCause(run);
            }
            return this.matches(run.getResult());
        }

        public boolean matches(Result result) {
            return false;
        }

        private StatusType() {
        }

        private StatusType(boolean matchCause) {
            this.matchCause = matchCause;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ViewJobFilter> {
        public String getDisplayName() {
            return Messages.BuildTrendFilter_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/view-job-filters/build-trend-help.html";
        }
    }
}

