/*
 * Decompiled with CFR 0.152.
 */
package hudson.views;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.views.AbstractBuildTrendFilter;
import hudson.views.ViewJobFilter;
import hudson.views.filters.Messages;
import java.text.DecimalFormat;
import org.kohsuke.stapler.DataBoundConstructor;

public class BuildDurationFilter
extends AbstractBuildTrendFilter {
    private boolean lessThan;
    private float buildDurationMinutes;

    @DataBoundConstructor
    public BuildDurationFilter(float buildDurationMinutes, boolean lessThan, String buildCountTypeString, float amount, String amountTypeString, String includeExcludeTypeString) {
        super(buildCountTypeString, amount, amountTypeString, includeExcludeTypeString);
        this.lessThan = lessThan;
        this.buildDurationMinutes = buildDurationMinutes;
    }

    @Override
    public boolean matchesRun(Run run) {
        long buildDurationMs = (long)(this.buildDurationMinutes * 60.0f * 1000.0f);
        if (this.lessThan) {
            return run.getDuration() < buildDurationMs;
        }
        return run.getDuration() > buildDurationMs;
    }

    public boolean isLessThan() {
        return this.lessThan;
    }

    public String getBuildDurationMinutes() {
        DecimalFormat format = new DecimalFormat("##########.##########");
        return format.format(this.buildDurationMinutes);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ViewJobFilter> {
        public String getDisplayName() {
            return Messages.BuildDurationFilter_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/view-job-filters/build-duration-help.html";
        }
    }
}

