/*
 * Decompiled with CFR 0.152.
 */
package hudson.views;

import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.views.ViewJobFilter;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractIncludeExcludeJobFilter
extends ViewJobFilter {
    private transient IncludeExcludeType includeExcludeType;
    private String includeExcludeTypeString;

    public AbstractIncludeExcludeJobFilter(String includeExcludeTypeString) {
        this.includeExcludeTypeString = includeExcludeTypeString;
        this.includeExcludeType = IncludeExcludeType.valueOf(includeExcludeTypeString);
    }

    Object readResolve() {
        if (this.includeExcludeTypeString != null) {
            this.includeExcludeType = IncludeExcludeType.valueOf(this.includeExcludeTypeString);
        }
        return this;
    }

    public boolean isIncludeMatched() {
        return this.includeExcludeType == IncludeExcludeType.includeMatched;
    }

    public boolean isIncludeUnmatched() {
        return this.includeExcludeType == IncludeExcludeType.includeUnmatched;
    }

    public boolean isExcludeMatched() {
        return this.includeExcludeType == IncludeExcludeType.excludeMatched;
    }

    public boolean isExcludeUnmatched() {
        return this.includeExcludeType == IncludeExcludeType.excludeUnmatched;
    }

    public String getIncludeExcludeTypeString() {
        return this.includeExcludeTypeString;
    }

    public List<TopLevelItem> filter(List<TopLevelItem> added, List<TopLevelItem> all, View filteringView) {
        ArrayList<TopLevelItem> filtered = new ArrayList<TopLevelItem>(added);
        this.doFilter(filtered, all, filteringView);
        ArrayList<TopLevelItem> sorted = new ArrayList<TopLevelItem>(all);
        sorted.retainAll(filtered);
        return sorted;
    }

    protected void doFilter(List<TopLevelItem> filtered, List<TopLevelItem> all, View filteringView) {
        for (TopLevelItem item : all) {
            boolean matched = this.matches(item);
            this.filterItem(filtered, item, matched);
        }
    }

    protected final void filterItem(List<TopLevelItem> filtered, TopLevelItem item, boolean matched) {
        if (this.exclude(matched)) {
            filtered.remove(item);
        }
        if (this.include(matched) && !filtered.contains(item)) {
            filtered.add(item);
        }
    }

    public boolean include(boolean matched) {
        if (this.isIncludeMatched() && matched) {
            return true;
        }
        return this.isIncludeUnmatched() && !matched;
    }

    public boolean exclude(boolean matched) {
        if (this.isExcludeMatched() && matched) {
            return true;
        }
        return this.isExcludeUnmatched() && !matched;
    }

    protected boolean matches(TopLevelItem item) {
        return false;
    }

    public static enum IncludeExcludeType {
        includeMatched,
        includeUnmatched,
        excludeMatched,
        excludeUnmatched;

    }
}

