/*
 * Decompiled with CFR 0.152.
 */
package hudson.views;

import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TopLevelItem;
import hudson.views.AbstractIncludeExcludeJobFilter;
import hudson.views.Clock;
import hudson.views.RunMatcher;

public abstract class AbstractBuildTrendFilter
extends AbstractIncludeExcludeJobFilter
implements RunMatcher {
    private static final long ONE_SECOND_MS = 1000L;
    private static final long ONE_MINUTE_MS = 60000L;
    static final long ONE_HOUR_MS = 3600000L;
    static final long ONE_DAY_MS = 86400000L;
    private transient BuildCountType buildCountType;
    private String buildCountTypeString;
    private transient AmountType amountType;
    private String amountTypeString;
    private float amount;

    public AbstractBuildTrendFilter(String buildCountTypeString, float amount, String amountTypeString, String includeExcludeTypeString) {
        super(includeExcludeTypeString);
        this.buildCountTypeString = buildCountTypeString;
        this.buildCountType = BuildCountType.valueOf(buildCountTypeString);
        this.amount = amount;
        this.amountTypeString = amountTypeString;
        this.amountType = AmountType.valueOf(amountTypeString);
    }

    @Override
    Object readResolve() {
        if (this.amountTypeString != null) {
            this.amountType = AmountType.valueOf(this.amountTypeString);
        }
        if (this.buildCountTypeString != null) {
            this.buildCountType = BuildCountType.valueOf(this.buildCountTypeString);
        }
        return super.readResolve();
    }

    @Override
    protected boolean matches(TopLevelItem item) {
        if (item instanceof Job) {
            Job job = (Job)item;
            boolean oneMatched = false;
            int count = 0;
            for (Run run = job.getLastBuild(); run != null; run = run.getPreviousBuild()) {
                boolean runMatches;
                if (this.amount > 0.0f && this.amountType != AmountType.Builds) {
                    long now = Clock.getInstance().currentTimeMillis();
                    long then = run.getTimeInMillis();
                    float diff = now - then;
                    if ((diff = this.amountType.convertMillisToAmount(diff)) > this.amount) break;
                }
                if (runMatches = this.matchesRun(run)) {
                    if (this.buildCountType == BuildCountType.AtLeastOne || this.buildCountType == BuildCountType.Latest) {
                        return true;
                    }
                } else if (this.buildCountType == BuildCountType.All) {
                    return false;
                }
                if (this.buildCountType == BuildCountType.Latest) {
                    return false;
                }
                oneMatched = true;
                if (this.amount > 0.0f && this.amountType == AmountType.Builds && (float)(++count) >= this.amount) break;
            }
            return this.buildCountType == BuildCountType.All && oneMatched;
        }
        return false;
    }

    public String getAmountTypeString() {
        return this.amountTypeString;
    }

    public float getAmount() {
        return this.amount;
    }

    public String getBuildCountTypeString() {
        return this.buildCountTypeString;
    }

    public static enum BuildCountType {
        Latest,
        All,
        AtLeastOne;

    }

    public static enum AmountType {
        Days(86400000L),
        Hours(3600000L),
        Builds(-1L);

        private long divideByAmount;

        private AmountType(long divideByAmount) {
            this.divideByAmount = divideByAmount;
        }

        public float convertMillisToAmount(float millis) {
            return millis / (float)this.divideByAmount;
        }
    }
}

