/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.uniqueid.implv2;

import hudson.Extension;
import hudson.model.Job;
import hudson.model.PersistenceRoot;
import hudson.model.Run;
import org.jenkinsci.plugins.uniqueid.IdStore;

@Extension(ordinal=1.0)
public class RunIdStore
extends IdStore<Run> {
    public RunIdStore() {
        super(Run.class);
    }

    @Override
    public void make(Run run) {
        IdStore.makeId(run.getParent());
    }

    @Override
    public String get(Run run) {
        IdStore<PersistenceRoot> persistenceStore = IdStore.forClass(PersistenceRoot.class);
        String id = persistenceStore.get((PersistenceRoot)run);
        if (id != null) {
            return id;
        }
        Job parent = run.getParent();
        String parentID = IdStore.getId(parent);
        if (parentID != null) {
            return parentID + "_" + run.getId();
        }
        return null;
    }
}

