/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.unblocked.notify;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.ExtensionList;
import hudson.model.Run;
import hudson.util.Secret;
import io.jenkins.plugins.unblocked.UnblockedConfig;
import io.jenkins.plugins.unblocked.UnblockedGlobalConfiguration;
import io.jenkins.plugins.unblocked.config.UnblockedConfigProvider;
import io.jenkins.plugins.unblocked.notify.Notifier;
import io.jenkins.plugins.unblocked.utils.Urls;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;

public class NotifyExecution
extends SynchronousNonBlockingStepExecution<Void> {
    @Nullable
    private final String baseUrl;
    @Nullable
    private final Secret signature;

    public NotifyExecution(@NonNull StepContext context, @Nullable String baseUrl, @Nullable Secret signature) {
        super(context);
        this.baseUrl = baseUrl;
        this.signature = signature;
    }

    protected Void run() throws Exception {
        Run run = (Run)this.getContext().get(Run.class);
        if (run != null && NotifyExecution.isEnabled(run)) {
            String baseUrl = this.getBaseUrl();
            Secret signature = this.getSignature(run);
            Notifier.submit(baseUrl, signature, run);
        }
        return null;
    }

    @Nullable
    private String getBaseUrl() {
        if (this.baseUrl != null && !Urls.isValid(this.baseUrl)) {
            throw new IllegalArgumentException("Invalid URL: " + this.baseUrl);
        }
        return StringUtils.stripEnd((String)this.baseUrl, (String)"/");
    }

    private Secret getSignature(Run<?, ?> run) {
        if (this.signature != null) {
            return this.signature;
        }
        return NotifyExecution.extractSignature(run);
    }

    static Secret extractSignature(Run<?, ?> run) {
        for (UnblockedConfigProvider provider : ExtensionList.lookup(UnblockedConfigProvider.class)) {
            Secret signature;
            UnblockedConfig config = provider.getUnblockedConfig(run);
            if (config == null || (signature = config.getSignature()) == null) continue;
            return signature;
        }
        return UnblockedGlobalConfiguration.get().getSignature();
    }

    static boolean isEnabled(Run<?, ?> run) {
        return !NotifyExecution.isDisabled(run);
    }

    static boolean isDisabled(Run<?, ?> run) {
        for (UnblockedConfigProvider provider : ExtensionList.lookup(UnblockedConfigProvider.class)) {
            UnblockedConfig config = provider.getUnblockedConfig(run);
            if (config == null) continue;
            return config.isDisabled();
        }
        return UnblockedGlobalConfiguration.get().isDisabled();
    }
}

