/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.unblocked.utils;

import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.ProxyConfiguration;
import hudson.util.Secret;
import io.jenkins.plugins.unblocked.utils.Hmac;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Http {
    private static final Logger LOGGER = Logger.getLogger(Http.class.getName());
    private static final String BASEURL = "https://getunblocked.com";
    private static final Duration TIMEOUT = Duration.ofSeconds(30L);

    private static HttpClient createClient() {
        return ProxyConfiguration.newHttpClientBuilder().connectTimeout(Duration.ofSeconds(10L)).version(HttpClient.Version.HTTP_1_1).build();
    }

    public static HttpResponse<String> post(@Nullable String baseUrl, String eventType, String body, Secret signature) {
        if (signature == null) {
            LOGGER.log(Level.SEVERE, "Missing signature");
            return null;
        }
        String url = String.format("%s/api/hooks/jenkins", baseUrl != null ? baseUrl : BASEURL);
        HttpRequest.BodyPublisher payload = HttpRequest.BodyPublishers.ofString(body);
        HttpRequest request = ProxyConfiguration.newHttpRequestBuilder((URI)URI.create(url)).header("Content-Type", "application/json").header("X-Jenkins-Event", eventType).header("X-Jenkins-Signature", Hmac.sign(body, signature)).POST(payload).timeout(TIMEOUT).build();
        try {
            LOGGER.log(Level.INFO, "request: {0}", url);
            HttpClient client = Http.createClient();
            return client.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException | InterruptedException e) {
            LOGGER.log(Level.SEVERE, e, () -> "request: " + url);
            throw new RuntimeException(e);
        }
    }
}

