/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.unblocked.notify;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.Run;
import hudson.util.Secret;
import io.jenkins.plugins.unblocked.notify.NotifyExecution;
import java.util.Collections;
import java.util.Set;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class NotifyStep
extends Step {
    @Nullable
    private String baseUrl;
    @Nullable
    private Secret signature;

    @DataBoundConstructor
    public NotifyStep() {
    }

    @DataBoundSetter
    public void setBaseUrl(@Nullable String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @DataBoundSetter
    public void setSignature(@Nullable String signature) {
        this.signature = Secret.fromString((String)signature);
    }

    public StepExecution start(StepContext context) throws Exception {
        return new NotifyExecution(context, this.baseUrl, this.signature);
    }

    @Extension
    public static class NotifyStepDescriptor
    extends StepDescriptor {
        public String getFunctionName() {
            return "unblockedNotify";
        }

        @NonNull
        public String getDisplayName() {
            return "Send notification to Unblocked";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(Run.class);
        }
    }
}

