/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.unblocked.notify;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.git.Revision;
import hudson.plugins.git.util.Build;
import hudson.plugins.git.util.BuildData;
import hudson.util.Secret;
import hudson.util.VersionNumber;
import io.jenkins.plugins.unblocked.UnblockedPlugin;
import io.jenkins.plugins.unblocked.utils.Http;
import io.jenkins.plugins.unblocked.utils.Json;
import java.net.http.HttpResponse;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import jenkins.model.Jenkins;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMRevisionAction;
import jenkins.scm.api.SCMSource;

public class Notifier {
    private static final String eventType = "Notify";

    public static HttpResponse<String> submit(@Nullable String baseUrl, @NonNull Secret signature, @NonNull Run<?, ?> run) {
        Map<String, Object> payload = Notifier.buildPayload(run);
        String json = Json.stringify(payload);
        return Http.post(baseUrl, eventType, json, signature);
    }

    private static Map<String, Object> buildPayload(Run<?, ?> run) {
        TreeMap<String, Object> payload = new TreeMap<String, Object>();
        Notifier.injectJenkins(payload, run);
        Notifier.injectRepo(payload, run);
        Notifier.injectRun(payload, run);
        return payload;
    }

    private static void injectJenkins(Map<String, Object> payload, Run<?, ?> run) {
        Jenkins jenkins = Jenkins.get();
        VersionNumber version = Jenkins.getVersion();
        if (version != null) {
            payload.put("jenkinsVersion", version.toString());
        }
        payload.put("jenkinsUrl", jenkins.getRootUrl());
        payload.put("pluginVersion", UnblockedPlugin.get().getVersion());
    }

    private static void injectRepo(Map<String, Object> payload, Run<?, ?> run) {
        Iterator<Object> it;
        SCMRevisionAction scmRevisionAction = (SCMRevisionAction)run.getAction(SCMRevisionAction.class);
        if (scmRevisionAction != null) {
            AbstractGitSCMSource gitSource;
            String repoUrl;
            SCMSource scmSource = SCMSource.SourceByItem.findSource((Item)run.getParent());
            if (scmSource instanceof AbstractGitSCMSource && (repoUrl = (gitSource = (AbstractGitSCMSource)scmSource).getRemote()) != null) {
                payload.put("repoUrl", repoUrl);
            }
            SCMRevision revision = scmRevisionAction.getRevision();
            payload.put("repoBranch", revision.getHead().getName());
            payload.put("repoVersion", revision.toString());
        }
        if (!payload.containsKey("repoUrl")) {
            for (BuildData action : run.getActions(BuildData.class)) {
                String repoUrl;
                it = action.remoteUrls.iterator();
                if (!it.hasNext() || (repoUrl = (String)it.next()) == null) continue;
                payload.put("repoUrl", repoUrl);
                break;
            }
        }
        if (!payload.containsKey("repoBranch")) {
            for (BuildData action : run.getActions(BuildData.class)) {
                Revision revision;
                it = action.buildsByBranchName.keySet().iterator();
                if (!it.hasNext()) continue;
                String branch = (String)it.next();
                if (branch == null) break;
                payload.put("repoBranch", branch);
                Build build = (Build)action.buildsByBranchName.get(branch);
                if (build == null || (revision = build.getRevision()) == null) break;
                payload.put("repoVersion", revision.getSha1().name());
                break;
            }
        }
    }

    private static void injectRun(Map<String, Object> payload, Run<?, ?> run) {
        payload.put("runType", run.getClass().getName());
        payload.put("runId", run.getId());
        payload.put("runNumber", run.getNumber());
        payload.put("runSlug", run.getUrl());
        payload.put("runDisplayName", run.getDisplayName());
        Result result = run.getResult();
        if (result != null) {
            payload.put("runResult", result.toString());
        }
        payload.put("runStartedAt", run.getStartTimeInMillis());
        payload.put("runDuration", run.getDuration());
        if (result != null && result.isCompleteBuild()) {
            payload.put("runEndedAt", run.getStartTimeInMillis() + run.getDuration());
        }
    }
}

