/*
 * Decompiled with CFR 0.152.
 */
package com.uipath.uipathpackage.util;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.uipath.uipathpackage.Messages;
import com.uipath.uipathpackage.configuration.UiPathCliConfiguration;
import com.uipath.uipathpackage.entries.SelectEntry;
import com.uipath.uipathpackage.entries.authentication.ExternalAppAuthenticationEntry;
import com.uipath.uipathpackage.entries.authentication.TokenAuthenticationEntry;
import com.uipath.uipathpackage.entries.authentication.UserPassAuthenticationEntry;
import com.uipath.uipathpackage.entries.job.DynamicallyEntry;
import com.uipath.uipathpackage.entries.job.NonProductionJobTypeEntry;
import com.uipath.uipathpackage.entries.job.RobotEntry;
import com.uipath.uipathpackage.entries.job.TestAutomationJobTypeEntry;
import com.uipath.uipathpackage.entries.job.UnattendedJobTypeEntry;
import com.uipath.uipathpackage.models.AuthenticatedOptions;
import com.uipath.uipathpackage.models.JobOptions;
import com.uipath.uipathpackage.models.RunOptions;
import com.uipath.uipathpackage.models.SerializableCliOptions;
import com.uipath.uipathpackage.util.ActualVersion;
import com.uipath.uipathpackage.util.CliDetails;
import com.uipath.uipathpackage.util.CliGetFlow;
import com.uipath.uipathpackage.util.JobType;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.StreamTaskListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidParameterException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.jar.JarEntry;
import java.util.jar.JarException;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.json.JSONObject;

public class Utility {
    public void validateParams(@Nonnull String param, @Nonnull String s) {
        if (param.trim().isEmpty()) {
            throw new InvalidParameterException(s);
        }
    }

    public String getConfigValue(@Nonnull ResourceBundle rb, @Nonnull String s) {
        return rb.getString(s);
    }

    public int execute(@Nonnull String command, @Nonnull SerializableCliOptions options, @Nonnull FilePath remoteTempDir, @Nonnull TaskListener listener, @Nonnull EnvVars envVars, @Nonnull Launcher launcher, boolean throwExceptionOnFailure) throws IOException, InterruptedException, URISyntaxException {
        FilePath cliPath;
        if (remoteTempDir.getRemote().toUpperCase().contains(":\\WINDOWS\\SYSTEM32")) {
            throw new AbortException("The plugin cannot be executed in a workspace path inside the WINDOWS folder. Please use a custom workspace folder that is outside the WINDOWS folder for this build definition or reinstall Jenkins and use a local user account instead.");
        }
        UiPathCliConfiguration cliConfiguration = UiPathCliConfiguration.getInstance();
        Optional<FilePath> cachedCliPath = cliConfiguration.getCliPath(launcher, envVars, cliConfiguration.getSelectedOrDefaultCliVersionKey(envVars));
        if (cachedCliPath.isPresent()) {
            cliPath = cachedCliPath.get();
        } else {
            FilePath cliRootCacheDirPath = cliConfiguration.getCliRootCachedDirectoryPath(launcher, envVars, cliConfiguration.getDefaultCliVersionKey());
            cliPath = this.extractCliApp(cliRootCacheDirPath, listener, envVars);
        }
        FilePath commandOptionsFile = remoteTempDir.createTextTempFile("uipcliargs", "", new JSONObject((Object)new RunOptions(command, options)).toString());
        String[] commandParams = new String[]{"dotnet", cliPath.getRemote(), "run", commandOptionsFile.getRemote()};
        int result = launcher.launch().cmds(commandParams).envs((Map)envVars).stdout(listener).pwd(cliPath.getParent()).start().join();
        if (throwExceptionOnFailure && result != 0) {
            throw new AbortException("Failed to run the command, the CLI failed with error code " + result);
        }
        return result;
    }

    public CliDetails getCliDetails(@Nonnull Run<?, ?> run, @Nonnull TaskListener listener, @Nonnull EnvVars envVars, @Nonnull Launcher launcher) throws IOException, InterruptedException, URISyntaxException {
        CliGetFlow cliGetFlow;
        FilePath cliPath;
        UiPathCliConfiguration cliConfiguration = UiPathCliConfiguration.getInstance();
        String version = cliConfiguration.getSelectedOrDefaultCliVersionKey(envVars);
        launcher.getListener().getLogger().println("Selected CLI version: " + (String)envVars.get((Object)"SELECTED_CLI_VERSION_KEY"));
        launcher.getListener().getLogger().println("Used CLI version: " + version);
        Optional<FilePath> cachedCliPath = cliConfiguration.getCliPath(launcher, envVars, version);
        if (cachedCliPath.isPresent()) {
            cliPath = cachedCliPath.get();
            cliGetFlow = CliGetFlow.CachedTool;
        } else {
            FilePath cliRootCacheDirPath = cliConfiguration.getCliRootCachedDirectoryPath(launcher, envVars, cliConfiguration.getDefaultCliVersionKey());
            cliPath = this.extractCliApp(cliRootCacheDirPath, listener, envVars);
            cliGetFlow = CliGetFlow.ExtractDefaultCli;
        }
        ByteArrayOutputStream commandOutput = new ByteArrayOutputStream();
        StreamTaskListener execListener = new StreamTaskListener((OutputStream)commandOutput, run.getCharset());
        String[] commandParameters = new String[]{"dotnet", cliPath.getRemote(), "--version"};
        launcher.launch().cmds(commandParameters).envs((Map)envVars).stdout((TaskListener)execListener).pwd(cliPath.getParent()).start().join();
        String stdoutText = commandOutput.toString(run.getCharset().name());
        CliDetails response = new CliDetails();
        response.setActualVersion(this.extractActualVersionFromText(stdoutText));
        response.setGetFlow(cliGetFlow);
        return response;
    }

    private ActualVersion extractActualVersionFromText(String text) {
        Pattern versionPattern = Pattern.compile("uipcli (\\d+)\\.(\\d+)\\.\\d+");
        Matcher matcher = versionPattern.matcher(text);
        if (matcher.find()) {
            int majorVersion = Integer.parseInt(matcher.group(1));
            int minorVersion = Integer.parseInt(matcher.group(2));
            return new ActualVersion(majorVersion, minorVersion);
        }
        return new ActualVersion(-1, -1);
    }

    public void validateRuntime(@Nonnull Launcher launcher, @Nonnull EnvVars envVars) throws AbortException, JsonProcessingException {
        UiPathCliConfiguration configuration = UiPathCliConfiguration.getInstance();
        String selectedCliVersionKey = configuration.getSelectedOrDefaultCliVersionKey(envVars);
        UiPathCliConfiguration.Configuration cliConfig = configuration.getConfiguration().get(selectedCliVersionKey);
        if (launcher.isUnix() && cliConfig.getWindowsCompatible()) {
            throw new AbortException(Messages.GenericErrors_MustUseLinux());
        }
    }

    public FilePath extractCliApp(@Nonnull FilePath targetRootCacheDir, @Nonnull TaskListener listener, @Nonnull EnvVars env) throws IOException, InterruptedException, URISyntaxException {
        PrintStream logger = listener.getLogger();
        FilePath targetCliPath = Utility.getDotnetToolCliPath(targetRootCacheDir);
        if (targetCliPath.exists()) {
            logger.println("Using previously extracted UiPath CLI from " + String.valueOf(targetCliPath));
            return targetCliPath;
        }
        String pluginJarPath = Utility.isServerOSWindows() ? env.expand("${JENKINS_HOME}\\plugins\\uipath-automation-package\\WEB-INF\\lib\\uipath-automation-package.jar") : env.expand("${JENKINS_HOME}/plugins/uipath-automation-package/WEB-INF/lib/uipath-automation-package.jar");
        logger.println("Expected plugin jar path on Jenkins master: " + pluginJarPath + ", extracting...");
        this.copyPluginFilesToTempDir(listener, targetRootCacheDir, pluginJarPath);
        return targetCliPath;
    }

    public static FilePath getDotnetToolCliPath(FilePath targetPath) throws IOException, InterruptedException {
        FilePath toolsDir = targetPath.child("tools");
        FilePath uipcliToolPath = toolsDir.child("uipcli.dll");
        if (uipcliToolPath.exists()) {
            return uipcliToolPath;
        }
        if (toolsDir.exists()) {
            for (FilePath child : toolsDir.listDirectories()) {
                String dirName = child.getName();
                if (!dirName.startsWith("net")) continue;
                uipcliToolPath = child.child("any").child("uipcli.dll");
                break;
            }
        }
        return uipcliToolPath;
    }

    public void downloadCli(String feedUrl, @Nonnull FilePath downloadPath, @Nonnull TaskListener listener) throws AbortException {
        PrintStream logger = listener.getLogger();
        logger.println("Downloading CLI from " + feedUrl);
        HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).build();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(feedUrl)).header("Accept", "application/octet-stream, */*").GET().build();
        try {
            HttpResponse<byte[]> response = client.send(request, HttpResponse.BodyHandlers.ofByteArray());
            int status = response.statusCode();
            byte[] body = response.body();
            if (status < 200 || status >= 300) {
                String resp = body != null ? new String(body, StandardCharsets.UTF_8) : "";
                logger.println("Aborting Task Unable to Download CLI.... HttpStatus " + status + " Response " + resp + " Error HTTP " + status);
                throw new AbortException("unable to download the CLI from the public feed");
            }
            try (ByteArrayInputStream in = new ByteArrayInputStream(body);){
                downloadPath.copyFrom((InputStream)in);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace(logger);
                throw new AbortException("Error while writing nupkg to download directory ");
            }
            logger.println("Downloaded CLI successfully. @" + String.valueOf(downloadPath));
        }
        catch (InterruptedException ie) {
            ie.printStackTrace(logger);
            Thread.currentThread().interrupt();
            logger.println("Aborting Task Unable to Download CLI.... Error " + ie.getMessage() + " Download Path " + downloadPath.getRemote());
            throw new AbortException("unable to download the CLI from the public feed");
        }
        catch (IOException ioe) {
            logger.println("Aborting Task Unable to Download CLI.... Error " + ioe.getMessage() + " Download Path " + downloadPath.getRemote());
            throw new AbortException("unable to download the CLI from the public feed");
        }
    }

    public void setCredentialsFromCredentialsEntry(SelectEntry credentials, AuthenticatedOptions options, @Nonnull Run<?, ?> run) throws AbortException {
        if (credentials instanceof UserPassAuthenticationEntry) {
            StandardUsernamePasswordCredentials cred = (StandardUsernamePasswordCredentials)CredentialsProvider.findCredentialById((String)((UserPassAuthenticationEntry)credentials).getCredentialsId(), StandardUsernamePasswordCredentials.class, run, Collections.emptyList());
            if (cred == null || cred.getUsername().isEmpty() || cred.getPassword().getPlainText().isEmpty()) {
                throw new AbortException("Invalid credentials");
            }
            options.setUsername(cred.getUsername());
            options.setPassword(cred.getPassword().getPlainText());
        } else if (credentials instanceof TokenAuthenticationEntry) {
            StringCredentials cred = (StringCredentials)CredentialsProvider.findCredentialById((String)((TokenAuthenticationEntry)credentials).getCredentialsId(), StringCredentials.class, run, Collections.emptyList());
            if (cred == null || cred.getSecret().getPlainText().isEmpty()) {
                throw new AbortException("Invalid credentials");
            }
            options.setRefreshToken(cred.getSecret().getPlainText());
            options.setAccountName(((TokenAuthenticationEntry)credentials).getAccountName());
        } else {
            StringCredentials secret = (StringCredentials)CredentialsProvider.findCredentialById((String)((ExternalAppAuthenticationEntry)credentials).getApplicationSecret(), StringCredentials.class, run, Collections.emptyList());
            if (secret == null || secret.getSecret().getPlainText().isEmpty()) {
                throw new AbortException("Invalid credentials");
            }
            ExternalAppAuthenticationEntry cred = (ExternalAppAuthenticationEntry)credentials;
            options.setAccountForApp(cred.getAccountForApp());
            options.setApplicationId(cred.getApplicationId());
            options.setApplicationSecret(secret.getSecret().getPlainText());
            if (StringUtils.isNotBlank((String)cred.getApplicationScope())) {
                options.setApplicationScope(cred.getApplicationScope());
            }
            if (StringUtils.isNotBlank((String)cred.getIdentityUrl())) {
                options.setAuthorizationUrl(cred.getIdentityUrl());
            }
        }
    }

    public void setJobRunFromStrategyEntry(SelectEntry strategy, JobOptions options) {
        if (strategy == null) {
            options.setJobsCount(1);
            options.setUser("");
            options.setMachine("");
            return;
        }
        if (strategy instanceof DynamicallyEntry) {
            options.setJobsCount(((DynamicallyEntry)strategy).getJobsCount());
            options.setUser(((DynamicallyEntry)strategy).getUser());
            options.setMachine(((DynamicallyEntry)strategy).getMachine());
            options.setRobots(new String[0]);
        } else {
            String robotNames = ((RobotEntry)strategy).getRobotsIds();
            if (robotNames != null) {
                options.setRobots(robotNames.split(","));
            } else {
                options.setRobots(new String[0]);
            }
        }
    }

    public void setJobRunFromJobTypeEntry(SelectEntry strategy, JobOptions options) {
        if (strategy instanceof NonProductionJobTypeEntry) {
            options.setJobType(JobType.NonProduction);
        } else if (strategy instanceof UnattendedJobTypeEntry) {
            options.setJobType(JobType.Unattended);
        } else if (strategy instanceof TestAutomationJobTypeEntry) {
            options.setJobType(JobType.TestAutomation);
        }
    }

    private void extractResourcesToTempFolder(FilePath tempDir, File jarfile, TaskListener listener) throws IOException, InterruptedException {
        try (JarFile archive = new JarFile(jarfile);){
            List entries = archive.stream().sorted(Comparator.comparing(ZipEntry::getName)).collect(Collectors.toList());
            for (JarEntry entry : entries) {
                Path entryPath;
                if (!entry.getName().startsWith("cli") || (entryPath = Paths.get(entry.getName(), new String[0])).getNameCount() <= 1) continue;
                String entryWithoutRootFolder = entryPath.subpath(1, entryPath.getNameCount()).toString();
                FilePath destination = tempDir.child(entryWithoutRootFolder);
                if (entry.isDirectory()) {
                    destination.mkdirs();
                    continue;
                }
                destination.copyFrom(archive.getInputStream(entry));
            }
        }
        catch (JarException e) {
            e.printStackTrace(listener.getLogger());
            throw e;
        }
    }

    private void copyPluginFilesToTempDir(@Nonnull TaskListener listener, FilePath tempDir, String pluginJarPath) throws IOException, URISyntaxException, InterruptedException {
        File jar = new File(pluginJarPath);
        if (!jar.exists()) {
            Enumeration<URL> jellies = this.getClass().getClassLoader().getResources("index.jelly");
            String defaultVersion = ResourceBundle.getBundle("config").getString("UiPath.CLI.Version");
            while (jellies.hasMoreElements()) {
                File jellyF;
                File classes;
                URL jellyU = jellies.nextElement();
                if (!jellyU.getProtocol().equals("file") || !(classes = (jellyF = new File(jellyU.toURI())).getParentFile()).getName().equals("classes")) continue;
                FilePath wsClasses = new FilePath(classes).child("cli-" + defaultVersion);
                wsClasses.copyRecursiveTo(tempDir);
                listener.getLogger().println("Plugin files copied to temp");
            }
        } else {
            listener.getLogger().print("Extracting cli to temp folder " + tempDir.getRemote() + "...");
            this.extractResourcesToTempFolder(tempDir, jar, listener);
            listener.getLogger().println("done!");
        }
    }

    public static boolean isServerOSWindows() {
        return System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH).contains("win");
    }
}

