/*
 * Decompiled with CFR 0.152.
 */
package com.uipath.uipathpackage.solutions;

import com.google.common.collect.ImmutableList;
import com.uipath.uipathpackage.entries.SelectEntry;
import com.uipath.uipathpackage.entries.authentication.ExternalAppAuthenticationEntry;
import com.uipath.uipathpackage.entries.authentication.TokenAuthenticationEntry;
import com.uipath.uipathpackage.entries.authentication.UserPassAuthenticationEntry;
import com.uipath.uipathpackage.models.solutions.SolutionUploadPackageOptions;
import com.uipath.uipathpackage.util.CliDetails;
import com.uipath.uipathpackage.util.TaskScopedEnvVarsManager;
import com.uipath.uipathpackage.util.TraceLevel;
import com.uipath.uipathpackage.util.Utility;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.slaves.WorkspaceList;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class UiPathSolutionUploadPackage
extends Recorder
implements SimpleBuildStep {
    private final String solutionPackagePath;
    private final SelectEntry credentials;
    private final TraceLevel traceLevel;
    private final String orchestratorAddress;
    private final String orchestratorTenant;

    @DataBoundConstructor
    public UiPathSolutionUploadPackage(String solutionPackagePath, SelectEntry credentials, TraceLevel traceLevel, String orchestratorAddress, String orchestratorTenant) {
        this.solutionPackagePath = solutionPackagePath;
        this.credentials = credentials;
        this.traceLevel = traceLevel;
        this.orchestratorAddress = orchestratorAddress;
        this.orchestratorTenant = orchestratorTenant;
    }

    public String getSolutionPackagePath() {
        return this.solutionPackagePath;
    }

    public SelectEntry getCredentials() {
        return this.credentials;
    }

    public TraceLevel getTraceLevel() {
        return this.traceLevel;
    }

    public String getOrchestratorAddress() {
        return this.orchestratorAddress;
    }

    public String getOrchestratorTenant() {
        return this.orchestratorTenant;
    }

    public void perform(Run<?, ?> run, FilePath workspace, EnvVars env, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        this.validateParameters();
        PrintStream logger = listener.getLogger();
        FilePath tempRemoteDir = WorkspaceList.tempDir((FilePath)workspace);
        if (tempRemoteDir == null) {
            throw new AbortException("Failed to create temp folder for solution upload.");
        }
        tempRemoteDir.mkdirs();
        Utility util = new Utility();
        try {
            EnvVars envVars = TaskScopedEnvVarsManager.addRequiredEnvironmentVariables(run, env, listener);
            util.validateRuntime(launcher, envVars);
            CliDetails cliDetails = util.getCliDetails(run, listener, envVars, launcher);
            String buildTag = (String)envVars.get((Object)"BUILD_TAG");
            FilePath expandedSolutionPackagePath = this.solutionPackagePath.contains("${WORKSPACE}") ? new FilePath(launcher.getChannel(), envVars.expand(this.solutionPackagePath)) : workspace.child(envVars.expand(this.solutionPackagePath));
            SolutionUploadPackageOptions options = new SolutionUploadPackageOptions();
            if (cliDetails.getActualVersion().supportsNewTelemetry()) {
                options.populateAdditionalTelemetryData();
                options.setPipelineCorrelationId(buildTag);
                options.setCliGetFlow(cliDetails.getGetFlow());
            }
            options.setSolutionPackagePath(expandedSolutionPackagePath.getRemote());
            util.setCredentialsFromCredentialsEntry(this.credentials, options, run);
            options.setTraceLevel(this.traceLevel);
            options.setOrchestratorUrl(this.orchestratorAddress);
            options.setOrchestratorTenant(this.orchestratorTenant);
            int exitCode = util.execute("SolutionUploadPackageOptions", options, tempRemoteDir, listener, envVars, launcher, true);
            if (exitCode != 0) {
                throw new AbortException("UiPath CLI solution upload-package failed with exit code: " + exitCode);
            }
            logger.println("Upload completed successfully.");
        }
        catch (URISyntaxException e) {
            e.printStackTrace(logger);
            throw new AbortException(e.getMessage());
        }
        finally {
            try {
                if (tempRemoteDir != null) {
                    tempRemoteDir.deleteRecursive();
                }
            }
            catch (Exception e) {
                logger.println("Failed to delete temp folder after solution upload: " + e.getMessage());
            }
        }
    }

    private void validateParameters() throws AbortException {
        Utility util = new Utility();
        util.validateParams(this.solutionPackagePath, "Invalid solution path");
        util.validateParams(this.orchestratorAddress, "Invalid orchestrator address");
        util.validateParams(this.orchestratorTenant, "Invalid orchestrator tenant");
        if (this.credentials == null) {
            throw new InvalidParameterException("Invalid credentials type");
        }
    }

    @Symbol(value={"UiPathSolutionUploadPackage"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "UiPath Solution: Upload Package";
        }

        public FormValidation doCheckSolutionPath(@QueryParameter String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.error((String)"Solution path is required.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckOrchestratorAddress(@QueryParameter String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.error((String)"Orchestrator address is required.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckOrchestratorTenant(@QueryParameter String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.error((String)"Orchestrator tenant is required.");
            }
            return FormValidation.ok();
        }

        public List<Descriptor> getAuthenticationDescriptors() {
            Descriptor externalAppDescriptor;
            Descriptor tokenDescriptor;
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            if (jenkins == null) {
                return new ArrayList<Descriptor>();
            }
            ArrayList<Descriptor> list = new ArrayList<Descriptor>();
            Descriptor userPassDescriptor = jenkins.getDescriptor(UserPassAuthenticationEntry.class);
            if (userPassDescriptor != null) {
                list.add(userPassDescriptor);
            }
            if ((tokenDescriptor = jenkins.getDescriptor(TokenAuthenticationEntry.class)) != null) {
                list.add(tokenDescriptor);
            }
            if ((externalAppDescriptor = jenkins.getDescriptor(ExternalAppAuthenticationEntry.class)) != null) {
                list.add(externalAppDescriptor);
            }
            return ImmutableList.copyOf(list);
        }

        public ListBoxModel doFillTraceLevelItems(@AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            ListBoxModel result = new ListBoxModel();
            for (TraceLevel v : TraceLevel.values()) {
                result.add(v.toString(), v.toString());
            }
            return result;
        }
    }
}

