/*
 * Decompiled with CFR 0.152.
 */
package com.uipath.uipathpackage.solutions;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.google.common.collect.ImmutableList;
import com.uipath.uipathpackage.Messages;
import com.uipath.uipathpackage.entries.SelectEntry;
import com.uipath.uipathpackage.entries.authentication.ExternalAppAuthenticationEntry;
import com.uipath.uipathpackage.entries.authentication.TokenAuthenticationEntry;
import com.uipath.uipathpackage.entries.authentication.UserPassAuthenticationEntry;
import com.uipath.uipathpackage.models.solutions.SolutionAnalyzeOptions;
import com.uipath.uipathpackage.models.solutions.SolutionPackOptions;
import com.uipath.uipathpackage.util.CliDetails;
import com.uipath.uipathpackage.util.TaskScopedEnvVarsManager;
import com.uipath.uipathpackage.util.TraceLevel;
import com.uipath.uipathpackage.util.Utility;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.slaves.WorkspaceList;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.acegisecurity.Authentication;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class UiPathSolutionPack
extends Builder
implements SimpleBuildStep {
    private final Utility util = new Utility();
    private final String version;
    private final String workspacePath;
    private final String outputPath;
    private Boolean disableBuiltInNugetFeeds;
    private boolean runWorkflowAnalysis;
    private String repositoryUrl;
    private String repositoryCommit;
    private String repositoryBranch;
    private String repositoryType;
    private String projectUrl;
    private String releaseNotes;
    private boolean showMetadata;
    private boolean showPackageSigning;
    private String certificatePath;
    private String password;
    private String timestampServerUrl;
    private boolean showMoreSettings;
    private boolean useOrchestrator;
    private String orchestratorAddress;
    private String orchestratorTenant;
    private SelectEntry credentials;
    private final TraceLevel traceLevel;
    private String governanceFilePath;

    @DataBoundConstructor
    public UiPathSolutionPack(String version, String workspacePath, String outputPath, TraceLevel traceLevel) {
        this.version = version;
        this.workspacePath = workspacePath;
        this.outputPath = outputPath;
        this.traceLevel = traceLevel;
        this.disableBuiltInNugetFeeds = null;
        this.repositoryUrl = null;
        this.repositoryCommit = null;
        this.repositoryBranch = null;
        this.repositoryType = null;
        this.projectUrl = null;
        this.releaseNotes = null;
        this.showMetadata = false;
        this.showPackageSigning = false;
        this.certificatePath = null;
        this.password = null;
        this.timestampServerUrl = null;
        this.showMoreSettings = false;
        this.orchestratorAddress = "";
        this.orchestratorTenant = "";
        this.credentials = null;
        this.runWorkflowAnalysis = false;
        this.governanceFilePath = null;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull EnvVars env, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        this.validateParameters();
        FilePath tempRemoteDir = WorkspaceList.tempDir((FilePath)workspace);
        if (Objects.isNull(tempRemoteDir)) {
            throw new AbortException(Messages.GenericErrors_FailedToCreateTempFolderPack());
        }
        tempRemoteDir.mkdirs();
        try {
            FilePath expandedWorkspacePath;
            EnvVars envVars = TaskScopedEnvVarsManager.addRequiredEnvironmentVariables(run, env, listener);
            this.util.validateRuntime(launcher, envVars);
            CliDetails cliDetails = this.util.getCliDetails(run, listener, envVars, launcher);
            String buildTag = (String)envVars.get((Object)"BUILD_TAG");
            FilePath expandedOutputPath = this.outputPath.contains("${WORKSPACE}") ? new FilePath(launcher.getChannel(), envVars.expand(this.outputPath)) : workspace.child(envVars.expand(this.outputPath));
            expandedOutputPath.mkdirs();
            FilePath filePath = expandedWorkspacePath = this.workspacePath.contains("${WORKSPACE}") ? new FilePath(launcher.getChannel(), envVars.expand(this.workspacePath)) : workspace.child(envVars.expand(this.workspacePath));
            if (this.runWorkflowAnalysis) {
                SolutionAnalyzeOptions solutionAnalyzeOptions = new SolutionAnalyzeOptions();
                if (this.governanceFilePath != null && !this.governanceFilePath.isEmpty()) {
                    FilePath expandedGovernanceFilePath = this.governanceFilePath.contains("${WORKSPACE}") ? new FilePath(launcher.getChannel(), envVars.expand(this.governanceFilePath)) : workspace.child(envVars.expand(this.governanceFilePath));
                    solutionAnalyzeOptions.setGovernanceFilePath(expandedGovernanceFilePath.getRemote());
                }
                if (this.disableBuiltInNugetFeeds != null && this.disableBuiltInNugetFeeds.booleanValue()) {
                    solutionAnalyzeOptions.setDisableBuiltInNugetFeeds(true);
                }
                if (cliDetails.getActualVersion().supportsNewTelemetry()) {
                    solutionAnalyzeOptions.populateAdditionalTelemetryData();
                    solutionAnalyzeOptions.setPipelineCorrelationId(buildTag);
                    solutionAnalyzeOptions.setCliGetFlow(cliDetails.getGetFlow());
                }
                solutionAnalyzeOptions.setProjectPath(expandedWorkspacePath.getRemote());
                if (this.useOrchestrator) {
                    solutionAnalyzeOptions.setOrchestratorUrl(this.orchestratorAddress);
                    solutionAnalyzeOptions.setOrchestratorTenant(this.orchestratorTenant);
                    this.util.setCredentialsFromCredentialsEntry(this.credentials, solutionAnalyzeOptions, run);
                }
                this.util.execute("SolutionAnalyzeOptions", solutionAnalyzeOptions, tempRemoteDir, listener, envVars, launcher, true);
            }
            SolutionPackOptions solutionPackOptions = new SolutionPackOptions();
            if (cliDetails.getActualVersion().supportsNewTelemetry()) {
                solutionPackOptions.populateAdditionalTelemetryData();
                solutionPackOptions.setPipelineCorrelationId(buildTag);
                solutionPackOptions.setCliGetFlow(cliDetails.getGetFlow());
            }
            solutionPackOptions.setDestinationFolder(expandedOutputPath.getRemote());
            solutionPackOptions.setProjectPath(expandedWorkspacePath.getRemote());
            if (this.disableBuiltInNugetFeeds != null && this.disableBuiltInNugetFeeds.booleanValue()) {
                solutionPackOptions.setDisableBuiltInNugetFeeds(true);
            }
            solutionPackOptions.setRepositoryUrl(this.repositoryUrl);
            solutionPackOptions.setRepositoryCommit(this.repositoryCommit);
            solutionPackOptions.setRepositoryBranch(this.repositoryBranch);
            solutionPackOptions.setRepositoryType(this.repositoryType);
            solutionPackOptions.setProjectUrl(this.projectUrl);
            solutionPackOptions.setReleaseNotes(this.releaseNotes);
            if (this.certificatePath != null && !this.certificatePath.trim().isEmpty()) {
                StringCredentials passwordCredentials;
                FilePath expandedSignPath = this.certificatePath.contains("${WORKSPACE}") ? new FilePath(launcher.getChannel(), envVars.expand(this.certificatePath)) : workspace.child(envVars.expand(this.certificatePath));
                solutionPackOptions.setCertificatePath(expandedSignPath.getRemote());
                if (this.password != null && !this.password.trim().isEmpty() && (passwordCredentials = (StringCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StringCredentials.class, (Item)run.getParent(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)this.password))) != null) {
                    solutionPackOptions.setCertificatePassword(passwordCredentials.getSecret().getPlainText());
                }
                if (this.timestampServerUrl != null && !this.timestampServerUrl.trim().isEmpty()) {
                    solutionPackOptions.setTimestampServerUrl(this.timestampServerUrl);
                }
            }
            solutionPackOptions.setVersion(envVars.expand(this.version.trim()));
            if (this.useOrchestrator) {
                solutionPackOptions.setOrchestratorUrl(this.orchestratorAddress);
                solutionPackOptions.setOrchestratorTenant(this.orchestratorTenant);
                this.util.setCredentialsFromCredentialsEntry(this.credentials, solutionPackOptions, run);
            }
            String language = Locale.getDefault().getLanguage();
            String country = Locale.getDefault().getCountry();
            String localization = country.isEmpty() ? language : language + "-" + country;
            solutionPackOptions.setLanguage(localization);
            solutionPackOptions.setTraceLevel(this.traceLevel);
            this.util.execute("SolutionPackOptions", solutionPackOptions, tempRemoteDir, listener, envVars, launcher, true);
        }
        catch (URISyntaxException e) {
            e.printStackTrace(listener.getLogger());
            throw new AbortException(e.getMessage());
        }
        finally {
            try {
                Objects.requireNonNull(tempRemoteDir).deleteRecursive();
            }
            catch (Exception e) {
                listener.getLogger().println(Messages.GenericErrors_FailedToDeleteTempPack() + e.getMessage());
            }
        }
    }

    @DataBoundSetter
    public void setUseOrchestrator(boolean useOrchestrator) {
        this.useOrchestrator = useOrchestrator;
        if (!useOrchestrator) {
            this.orchestratorAddress = null;
            this.orchestratorTenant = null;
            this.credentials = null;
        }
    }

    @DataBoundSetter
    public void setGovernanceFilePath(String governanceFilePath) {
        this.governanceFilePath = governanceFilePath;
    }

    @DataBoundSetter
    public void setDisableBuiltInNugetFeeds(Boolean disableBuiltInNugetFeeds) {
        this.disableBuiltInNugetFeeds = disableBuiltInNugetFeeds;
    }

    @DataBoundSetter
    public void setRunWorkflowAnalysis(boolean runWorkflowAnalysis) {
        this.runWorkflowAnalysis = runWorkflowAnalysis;
    }

    @DataBoundSetter
    public void setRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
    }

    @DataBoundSetter
    public void setRepositoryCommit(String repositoryCommit) {
        this.repositoryCommit = repositoryCommit;
    }

    @DataBoundSetter
    public void setRepositoryBranch(String repositoryBranch) {
        this.repositoryBranch = repositoryBranch;
    }

    @DataBoundSetter
    public void setRepositoryType(String repositoryType) {
        this.repositoryType = repositoryType;
    }

    @DataBoundSetter
    public void setProjectUrl(String projectUrl) {
        this.projectUrl = projectUrl;
    }

    @DataBoundSetter
    public void setReleaseNotes(String releaseNotes) {
        this.releaseNotes = releaseNotes;
    }

    @DataBoundSetter
    public void setOrchestratorAddress(String orchestratorAddress) {
        this.orchestratorAddress = orchestratorAddress;
    }

    @DataBoundSetter
    public void setOrchestratorTenant(String orchestratorTenant) {
        this.orchestratorTenant = orchestratorTenant;
    }

    @DataBoundSetter
    public void setCredentials(SelectEntry credentials) {
        this.credentials = credentials;
    }

    @DataBoundSetter
    public void setShowMetadata(boolean showMetadata) {
        this.showMetadata = showMetadata;
    }

    @DataBoundSetter
    public void setShowPackageSigning(boolean showPackageSigning) {
        this.showPackageSigning = showPackageSigning;
    }

    @DataBoundSetter
    public void setCertificatePath(String certificatePath) {
        this.certificatePath = certificatePath;
    }

    @DataBoundSetter
    public void setPassword(String password) {
        this.password = password;
    }

    @DataBoundSetter
    public void setTimestampServerUrl(String timestampServerUrl) {
        this.timestampServerUrl = timestampServerUrl;
    }

    @DataBoundSetter
    public void setShowMoreSettings(boolean showMoreSettings) {
        this.showMoreSettings = showMoreSettings;
    }

    public String getVersion() {
        return this.version;
    }

    public String getWorkspacePath() {
        return this.workspacePath;
    }

    public boolean getUseOrchestrator() {
        return this.useOrchestrator;
    }

    public String getOrchestratorAddress() {
        return this.orchestratorAddress;
    }

    public String getOrchestratorTenant() {
        return this.orchestratorTenant;
    }

    public SelectEntry getCredentials() {
        return this.credentials;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public Boolean getDisableBuiltInNugetFeeds() {
        return this.disableBuiltInNugetFeeds;
    }

    public boolean getRunWorkflowAnalysis() {
        return this.runWorkflowAnalysis;
    }

    public String getGovernanceFilePath() {
        return this.governanceFilePath;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public String getRepositoryCommit() {
        return this.repositoryCommit;
    }

    public String getRepositoryBranch() {
        return this.repositoryBranch;
    }

    public String getRepositoryType() {
        return this.repositoryType;
    }

    public String getProjectUrl() {
        return this.projectUrl;
    }

    public String getReleaseNotes() {
        return this.releaseNotes;
    }

    public boolean getShowMetadata() {
        return this.showMetadata;
    }

    public boolean getShowPackageSigning() {
        return this.showPackageSigning;
    }

    public String getCertificatePath() {
        return this.certificatePath;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTimestampServerUrl() {
        return this.timestampServerUrl;
    }

    public boolean getShowMoreSettings() {
        return this.showMoreSettings;
    }

    public TraceLevel getTraceLevel() {
        return this.traceLevel;
    }

    private void validateParameters() throws AbortException {
        if (this.version == null || this.version.trim().isEmpty()) {
            throw new InvalidParameterException(Messages.GenericErrors_MissingVersioningMethod());
        }
        this.util.validateParams(this.workspacePath, Messages.ValidationErrors_InvalidProject());
        this.util.validateParams(this.outputPath, Messages.ValidationErrors_InvalidOutputPath());
        if (this.useOrchestrator) {
            this.util.validateParams(this.orchestratorAddress, Messages.ValidationErrors_InvalidOrchAddress());
            if (this.credentials == null) {
                throw new InvalidParameterException(Messages.ValidationErrors_InvalidCredentialsType());
            }
            this.credentials.validateParameters();
        }
        if (this.outputPath.toUpperCase().contains("${JENKINS_HOME}")) {
            throw new AbortException(Messages.ValidationErrors_InvalidPath());
        }
    }

    @Symbol(value={"UiPathSolutionPack"})
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public FormValidation doCheckVersion(@QueryParameter String value) {
            if (value.trim().isEmpty()) {
                return FormValidation.error((String)Messages.GenericErrors_MissingVersioningMethod());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckWorkspacePath(@QueryParameter String value) {
            if (value.trim().isEmpty()) {
                return FormValidation.error((String)Messages.UiPathSolutionPack_DescriptorImpl_Error_MissingWorkspacePath());
            }
            if (value.trim().toUpperCase().contains("${JENKINS_HOME}")) {
                return FormValidation.error((String)Messages.GenericErrors_MustUseSlavePaths());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckOutputPath(@QueryParameter String value) {
            if (value.trim().isEmpty()) {
                return FormValidation.error((String)Messages.UiPathPack_DescriptorImpl_Error_MissingOutputPath());
            }
            return FormValidation.ok();
        }

        @Nonnull
        public String getDisplayName() {
            return "UiPath Solution: Pack";
        }

        public ListBoxModel doFillTraceLevelItems(@AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            ListBoxModel result = new ListBoxModel();
            for (TraceLevel v : TraceLevel.values()) {
                result.add(v.toString(), v.toString());
            }
            return result;
        }

        public ListBoxModel doFillPasswordItems(@AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            return CredentialsProvider.listCredentials(StringCredentials.class, (Item)item, (Authentication)ACL.SYSTEM, Collections.emptyList(), (CredentialsMatcher)CredentialsMatchers.always());
        }

        public List<Descriptor> getAuthenticationDescriptors() {
            Descriptor externalAppDescriptor;
            Descriptor tokenDescriptor;
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            if (jenkins == null) {
                return new ArrayList<Descriptor>();
            }
            ArrayList<Descriptor> list = new ArrayList<Descriptor>();
            Descriptor userPassDescriptor = jenkins.getDescriptor(UserPassAuthenticationEntry.class);
            if (userPassDescriptor != null) {
                list.add(userPassDescriptor);
            }
            if ((tokenDescriptor = jenkins.getDescriptor(TokenAuthenticationEntry.class)) != null) {
                list.add(tokenDescriptor);
            }
            if ((externalAppDescriptor = jenkins.getDescriptor(ExternalAppAuthenticationEntry.class)) != null) {
                list.add(externalAppDescriptor);
            }
            return ImmutableList.copyOf(list);
        }
    }
}

