/*
 * Decompiled with CFR 0.152.
 */
package com.uipath.uipathpackage.entries.testExecutionTarget;

import com.uipath.uipathpackage.Messages;
import com.uipath.uipathpackage.entries.SelectEntry;
import com.uipath.uipathpackage.util.Utility;
import hudson.AbortException;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.util.FormValidation;
import javax.annotation.Nonnull;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class TestProjectEntry
extends SelectEntry {
    private final String testProjectPath;
    private final String environments;

    @DataBoundConstructor
    public TestProjectEntry(String testProjectPath, String environments) {
        this.testProjectPath = testProjectPath;
        this.environments = environments;
    }

    public String getTestProjectPath() {
        return this.testProjectPath;
    }

    public String getEnvironments() {
        return this.environments;
    }

    @Override
    public boolean validateParameters() throws AbortException {
        Utility util = new Utility();
        util.validateParams(this.testProjectPath, "Invalid test package path");
        if (this.testProjectPath.toUpperCase().contains("${JENKINS_HOME}")) {
            throw new AbortException("Paths containing JENKINS_HOME are not allowed, use the Copy To Slave plugin to copy the required files to the slave's workspace instead.");
        }
        return true;
    }

    @Symbol(value={"TestProject"})
    @Extension
    public static class DescriptorImpl
    extends Descriptor<SelectEntry> {
        @Nonnull
        public String getDisplayName() {
            return Messages.TestProjectEntry_DescriptorImpl_DisplayName();
        }

        public FormValidation doCheckTestProjectPath(@AncestorInPath Item item, @QueryParameter String value) {
            if (value == null || value.isEmpty()) {
                return FormValidation.error((String)Messages.GenericErrors_MissingTestProjectPath());
            }
            if (value.trim().toUpperCase().contains("${JENKINS_HOME}")) {
                return FormValidation.error((String)Messages.GenericErrors_MustUseSlavePaths());
            }
            return FormValidation.ok();
        }
    }
}

