/*
 * Decompiled with CFR 0.152.
 */
package com.uipath.uipathpackage.entries.authentication;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.uipath.uipathpackage.Messages;
import com.uipath.uipathpackage.entries.SelectEntry;
import com.uipath.uipathpackage.util.Utility;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.Collections;
import javax.annotation.Nonnull;
import org.acegisecurity.Authentication;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ExternalAppAuthenticationEntry
extends SelectEntry {
    private final String identityUrl;
    private final String accountForApp;
    private final String applicationId;
    private final String applicationSecret;
    private final String applicationScope;

    @DataBoundConstructor
    public ExternalAppAuthenticationEntry(String accountForApp, String applicationId, String applicationSecret, String applicationScope, String identityUrl) {
        this.accountForApp = accountForApp;
        this.applicationId = applicationId;
        this.applicationSecret = applicationSecret;
        this.applicationScope = applicationScope;
        this.identityUrl = identityUrl;
    }

    public String getAccountForApp() {
        return this.accountForApp;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getApplicationSecret() {
        return this.applicationSecret;
    }

    public String getApplicationScope() {
        return this.applicationScope;
    }

    public String getIdentityUrl() {
        return this.identityUrl;
    }

    @Override
    public boolean validateParameters() {
        Utility util = new Utility();
        util.validateParams(this.applicationId, Messages.ExternalAppAuthenticationEntry_DescriptorImpl_Errors_MissingApplicationId());
        util.validateParams(this.applicationSecret, Messages.ExternalAppAuthenticationEntry_DescriptorImpl_Errors_MissingApplicationSecret());
        return true;
    }

    @Symbol(value={"ExternalApp"})
    @Extension
    public static class DescriptorImpl
    extends Descriptor<SelectEntry> {
        @Nonnull
        public String getDisplayName() {
            return Messages.ExternalAppAuthenticationEntry_DisplayName();
        }

        public ListBoxModel doFillApplicationSecretItems(@AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            return CredentialsProvider.listCredentials(StringCredentials.class, (Item)item, (Authentication)ACL.SYSTEM, Collections.emptyList(), (CredentialsMatcher)CredentialsMatchers.always());
        }

        public FormValidation doCheckApplicationSecret(@AncestorInPath Item item, @QueryParameter String value) {
            if (CredentialsProvider.listCredentials(StringCredentials.class, (Item)item, (Authentication)ACL.SYSTEM, Collections.emptyList(), (CredentialsMatcher)CredentialsMatchers.withId((String)value)).isEmpty()) {
                return FormValidation.error((String)Messages.GenericErrors_MissingCredentialSecret());
            }
            return FormValidation.ok();
        }
    }
}

