/*
 * Decompiled with CFR 0.152.
 */
package com.uipath.uipathpackage;

import com.google.common.collect.ImmutableList;
import com.uipath.uipathpackage.Messages;
import com.uipath.uipathpackage.entries.SelectEntry;
import com.uipath.uipathpackage.entries.authentication.ExternalAppAuthenticationEntry;
import com.uipath.uipathpackage.entries.authentication.TokenAuthenticationEntry;
import com.uipath.uipathpackage.entries.authentication.UserPassAuthenticationEntry;
import com.uipath.uipathpackage.entries.testExecutionTarget.TestProjectEntry;
import com.uipath.uipathpackage.entries.testExecutionTarget.TestSetEntry;
import com.uipath.uipathpackage.models.TestOptions;
import com.uipath.uipathpackage.util.CliDetails;
import com.uipath.uipathpackage.util.TaskScopedEnvVarsManager;
import com.uipath.uipathpackage.util.TraceLevel;
import com.uipath.uipathpackage.util.Utility;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.slaves.WorkspaceList;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.tasks.junit.JUnitResultArchiver;
import hudson.tasks.junit.JUnitTask;
import hudson.tasks.junit.StdioRetention;
import hudson.tasks.junit.TestDataPublisher;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.junit.TestResultSummary;
import hudson.tasks.test.TestResultProjectAction;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class UiPathTest
extends Recorder
implements SimpleBuildStep,
JUnitTask {
    private final Utility util = new Utility();
    private final String orchestratorAddress;
    private final String orchestratorTenant;
    private final String folderName;
    private final SelectEntry credentials;
    private final SelectEntry testTarget;
    private final Integer timeout;
    private final String testResultsOutputPath;
    private final String parametersFilePath;
    private String testResultIncludes;
    private String repositoryUrl;
    private String repositoryCommit;
    private String repositoryBranch;
    private String repositoryType;
    private String projectUrl;
    private String releaseNotes;
    private final TraceLevel traceLevel;
    private boolean attachRobotLogs;
    private Boolean disableBuiltInNugetFeeds;
    private String projectKey;
    private static int TimeoutDefault = 7200;

    public Integer getTimeout() {
        return this.timeout;
    }

    @DataBoundConstructor
    public UiPathTest(String orchestratorAddress, String orchestratorTenant, String folderName, SelectEntry testTarget, SelectEntry credentials, String testResultsOutputPath, Integer timeout, TraceLevel traceLevel, String parametersFilePath) {
        this.testTarget = testTarget;
        this.orchestratorAddress = orchestratorAddress;
        this.orchestratorTenant = orchestratorTenant;
        this.folderName = folderName;
        this.credentials = credentials;
        this.timeout = timeout;
        this.testResultsOutputPath = testResultsOutputPath;
        this.parametersFilePath = parametersFilePath;
        this.disableBuiltInNugetFeeds = null;
        this.repositoryUrl = null;
        this.repositoryCommit = null;
        this.repositoryBranch = null;
        this.repositoryType = null;
        this.projectUrl = null;
        this.releaseNotes = null;
        this.traceLevel = traceLevel;
        this.attachRobotLogs = false;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @NonNull EnvVars env, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        this.validateParameters();
        FilePath tempRemoteDir = WorkspaceList.tempDir((FilePath)workspace);
        if (Objects.isNull(tempRemoteDir)) {
            throw new AbortException(Messages.GenericErrors_FailedToCreateTempFolderTest());
        }
        tempRemoteDir.mkdirs();
        try {
            ResourceBundle rb = ResourceBundle.getBundle("config");
            EnvVars envVars = TaskScopedEnvVarsManager.addRequiredEnvironmentVariables(run, env, listener);
            this.util.validateRuntime(launcher, envVars);
            CliDetails cliDetails = this.util.getCliDetails(run, listener, envVars, launcher);
            String buildTag = (String)envVars.get((Object)"BUILD_TAG");
            TestOptions testOptions = new TestOptions();
            if (this.disableBuiltInNugetFeeds != null && this.disableBuiltInNugetFeeds.booleanValue()) {
                testOptions.setDisableBuiltInNugetFeeds(true);
            }
            if (cliDetails.getActualVersion().supportsNewTelemetry()) {
                testOptions.populateAdditionalTelemetryData();
                testOptions.setPipelineCorrelationId(buildTag);
                testOptions.setCliGetFlow(cliDetails.getGetFlow());
            }
            if (!StringUtils.isBlank((String)this.projectKey)) {
                testOptions.setProjectKey(this.projectKey.trim());
            } else {
                testOptions.setOrganizationUnit(envVars.expand(this.folderName.trim()));
                listener.getLogger().println("Testing module in Orchestrator will be deprecated soon. Consider migrating to UiPath Test Manager. For more information, visit: Migration FAQ: https://docs.uipath.com/orchestrator/automation-cloud/latest/user-guide/faq-migrating-test-artifacts-to-test-manager Deprecation FAQ: https://docs.uipath.com/orchestrator/automation-cloud/latest/user-guide/faq---deprecating-the-testing-module");
            }
            if (this.testTarget instanceof TestProjectEntry) {
                String environments = envVars.expand(((TestProjectEntry)this.testTarget).getEnvironments());
                Object projectPath = ((TestProjectEntry)this.testTarget).getTestProjectPath();
                if (!((String)projectPath).endsWith("project.json")) {
                    projectPath = !((String)projectPath).endsWith("\\") ? (String)projectPath + "\\project.json" : (String)projectPath + "project.json";
                }
                FilePath expandedProjectPath = ((String)projectPath).contains("${WORKSPACE}") ? new FilePath(launcher.getChannel(), envVars.expand((String)projectPath)) : workspace.child(envVars.expand((String)projectPath));
                testOptions.setProjectPath(expandedProjectPath.getRemote());
                if (environments != null && !environments.trim().isEmpty()) {
                    testOptions.setEnvironment(environments);
                }
            } else if (!StringUtils.isBlank((String)this.projectKey)) {
                testOptions.setTestSetKey(((TestSetEntry)this.testTarget).getTestSet());
            } else {
                testOptions.setTestSet(((TestSetEntry)this.testTarget).getTestSet());
            }
            String orchestratorTenantFormatted = envVars.expand(this.orchestratorTenant.trim()).isEmpty() ? this.util.getConfigValue(rb, "UiPath.DefaultTenant") : envVars.expand(this.orchestratorTenant.trim());
            testOptions.setOrchestratorUrl(this.orchestratorAddress);
            testOptions.setOrchestratorTenant(orchestratorTenantFormatted);
            testOptions.setTestReportType("junit");
            String resultsOutputPath = this.testResultsOutputPath != null && !this.testResultsOutputPath.trim().isEmpty() ? this.testResultsOutputPath : "UiPathResults.xml";
            FilePath expandedTestResultsOutputPath = resultsOutputPath.contains("${WORKSPACE}") ? new FilePath(launcher.getChannel(), envVars.expand(resultsOutputPath)) : workspace.child(envVars.expand(resultsOutputPath));
            testOptions.setTestReportDestination(expandedTestResultsOutputPath.getRemote());
            testOptions.setTimeout(this.timeout != null ? this.timeout : TimeoutDefault);
            this.util.setCredentialsFromCredentialsEntry(this.credentials, testOptions, run);
            String language = Locale.getDefault().getLanguage();
            String country = Locale.getDefault().getCountry();
            String localization = country.isEmpty() ? language : language + "-" + country;
            testOptions.setLanguage(localization);
            testOptions.setTraceLevel(this.traceLevel);
            if (this.parametersFilePath != null && !this.parametersFilePath.isEmpty()) {
                FilePath parametersPath = this.parametersFilePath.contains("${WORKSPACE}") ? new FilePath(launcher.getChannel(), envVars.expand(this.parametersFilePath)) : workspace.child(envVars.expand(this.parametersFilePath));
                parametersPath.mkdirs();
                testOptions.setParametersFilePath(parametersPath.getRemote());
            }
            testOptions.setAttachRobotLogs(this.attachRobotLogs);
            testOptions.setRepositoryUrl(this.repositoryUrl);
            testOptions.setRepositoryCommit(this.repositoryCommit);
            testOptions.setRepositoryBranch(this.repositoryBranch);
            testOptions.setRepositoryType(this.repositoryType);
            testOptions.setProjectUrl(this.projectUrl);
            testOptions.setReleaseNotes(this.releaseNotes);
            int result = this.util.execute("RunTestsOptions", testOptions, tempRemoteDir, listener, envVars, launcher, false);
            if (result != 0 && !expandedTestResultsOutputPath.exists()) {
                throw new AbortException(Messages.GenericErrors_FailedToRunCommand());
            }
            String workspacePath = workspace.getRemote();
            this.testResultIncludes = expandedTestResultsOutputPath.getRemote();
            if (this.testResultIncludes.startsWith(workspacePath)) {
                this.testResultIncludes = this.testResultIncludes.substring(workspacePath.length());
                while ((this.testResultIncludes.startsWith("/") || this.testResultIncludes.startsWith("\\")) && this.testResultIncludes.length() > 1) {
                    this.testResultIncludes = this.testResultIncludes.substring(1);
                }
            }
            if (!expandedTestResultsOutputPath.getName().contains(".")) {
                if (!this.testResultIncludes.endsWith("/") && !this.testResultIncludes.endsWith("\\")) {
                    this.testResultIncludes = launcher.isUnix() ? this.testResultIncludes + "/" : this.testResultIncludes + "\\";
                }
                this.testResultIncludes = this.testResultIncludes + "*.xml";
            }
            run.addAction((Action)new TestResultProjectAction(run.getParent()));
            this.publishTestResults(run, workspace, launcher, listener);
        }
        catch (URISyntaxException e) {
            e.printStackTrace(listener.getLogger());
            throw new AbortException(e.getMessage());
        }
        finally {
            try {
                Objects.requireNonNull(tempRemoteDir).deleteRecursive();
            }
            catch (Exception e) {
                listener.getLogger().println(Messages.GenericErrors_FailedToDeleteTempTest() + e.getMessage());
                e.printStackTrace(listener.getLogger());
            }
        }
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public SelectEntry getTestTarget() {
        return this.testTarget;
    }

    public SelectEntry getCredentials() {
        return this.credentials;
    }

    public String getOrchestratorAddress() {
        return this.orchestratorAddress;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public String getOrchestratorTenant() {
        return this.orchestratorTenant;
    }

    public String getTestResultsOutputPath() {
        return this.testResultsOutputPath;
    }

    public TraceLevel getTraceLevel() {
        return this.traceLevel;
    }

    public String getParametersFilePath() {
        return this.parametersFilePath;
    }

    public boolean getAttachRobotLogs() {
        return this.attachRobotLogs;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public String getRepositoryCommit() {
        return this.repositoryCommit;
    }

    public String getRepositoryBranch() {
        return this.repositoryBranch;
    }

    public String getRepositoryType() {
        return this.repositoryType;
    }

    public String getProjectUrl() {
        return this.projectUrl;
    }

    public String getReleaseNotes() {
        return this.releaseNotes;
    }

    public Boolean getDisableBuiltInNugetFeeds() {
        return this.disableBuiltInNugetFeeds;
    }

    @DataBoundSetter
    public void setAttachRobotLogs(boolean attachRobotLogs) {
        this.attachRobotLogs = attachRobotLogs;
    }

    @DataBoundSetter
    public void setDisableBuiltInNugetFeeds(Boolean disableBuiltInNugetFeeds) {
        this.disableBuiltInNugetFeeds = disableBuiltInNugetFeeds;
    }

    @DataBoundSetter
    public void setRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
    }

    @DataBoundSetter
    public void setRepositoryCommit(String repositoryCommit) {
        this.repositoryCommit = repositoryCommit;
    }

    @DataBoundSetter
    public void setRepositoryBranch(String repositoryBranch) {
        this.repositoryBranch = repositoryBranch;
    }

    @DataBoundSetter
    public void setRepositoryType(String repositoryType) {
        this.repositoryType = repositoryType;
    }

    @DataBoundSetter
    public void setProjectUrl(String projectUrl) {
        this.projectUrl = projectUrl;
    }

    @DataBoundSetter
    public void setReleaseNotes(String releaseNotes) {
        this.releaseNotes = releaseNotes;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    @DataBoundSetter
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    private void validateParameters() throws AbortException {
        if (this.testTarget == null) {
            throw new InvalidParameterException(Messages.GenericErrors_MissingTestSetOrProjectPath());
        }
        this.testTarget.validateParameters();
        Utility util = new Utility();
        util.validateParams(this.orchestratorAddress, Messages.ValidationErrors_InvalidOrchAddress());
        if (StringUtils.isBlank((String)this.projectKey)) {
            util.validateParams(this.folderName, Messages.ValidationErrors_InvalidOrchFolder());
        }
        if (this.credentials == null) {
            throw new InvalidParameterException(Messages.GenericErrors_MissingAuthenticationMethod());
        }
        this.credentials.validateParameters();
        if (this.testResultsOutputPath != null && this.testResultsOutputPath.toUpperCase().contains("${JENKINS_HOME}")) {
            throw new AbortException(Messages.ValidationErrors_InvalidPath());
        }
    }

    private void publishTestResults(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        try {
            TestResultSummary resultSummary = JUnitResultArchiver.parseAndSummarize((JUnitTask)this, null, run, (FilePath)workspace, (Launcher)launcher, (TaskListener)listener);
            if (resultSummary != null) {
                TestResultAction action = (TestResultAction)run.getAction(TestResultAction.class);
                if (action != null && StringUtils.isNotEmpty((String)action.getResult().getStdout())) {
                    String stdOut = action.getResult().getStdout();
                    listener.getLogger().println(Messages.UiPathTest_DescriptorImpl_TestRunUrl() + stdOut.substring(stdOut.indexOf("ms.") + 3, stdOut.length()));
                }
                if (resultSummary.getFailCount() > 0) {
                    run.setResult(Result.UNSTABLE);
                }
            }
        }
        catch (Exception e) {
            listener.getLogger().println(e.getMessage());
            throw e;
        }
    }

    public String getTestResults() {
        return this.testResultIncludes;
    }

    public double getHealthScaleFactor() {
        return 1.0;
    }

    public List<TestDataPublisher> getTestDataPublishers() {
        return Collections.emptyList();
    }

    public String getStdioRetention() {
        return null;
    }

    public StdioRetention getParsedStdioRetention() {
        return super.getParsedStdioRetention();
    }

    public boolean isKeepLongStdio() {
        return true;
    }

    public boolean isKeepProperties() {
        return false;
    }

    public boolean isKeepTestNames() {
        return false;
    }

    public boolean isAllowEmptyResults() {
        return true;
    }

    public boolean isSkipPublishingChecks() {
        return false;
    }

    public String getChecksName() {
        return "UiPath Tests";
    }

    public boolean isSkipOldReports() {
        return false;
    }

    @Symbol(value={"UiPathTest"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.UiPathTest_DescriptorImpl_DisplayName();
        }

        public List<Descriptor> getEntryDescriptors() {
            Descriptor testPackageDescriptor;
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            if (jenkins == null) {
                return new ArrayList<Descriptor>();
            }
            ArrayList<Descriptor> list = new ArrayList<Descriptor>();
            Descriptor testSetDescriptor = jenkins.getDescriptor(TestSetEntry.class);
            if (testSetDescriptor != null) {
                list.add(testSetDescriptor);
            }
            if ((testPackageDescriptor = jenkins.getDescriptor(TestProjectEntry.class)) != null) {
                list.add(testPackageDescriptor);
            }
            return ImmutableList.copyOf(list);
        }

        public List<Descriptor> getAuthenticationDescriptors() {
            Descriptor externalAppDescriptor;
            Descriptor tokenDescriptor;
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            if (jenkins == null) {
                return new ArrayList<Descriptor>();
            }
            ArrayList<Descriptor> list = new ArrayList<Descriptor>();
            Descriptor userPassDescriptor = jenkins.getDescriptor(UserPassAuthenticationEntry.class);
            if (userPassDescriptor != null) {
                list.add(userPassDescriptor);
            }
            if ((tokenDescriptor = jenkins.getDescriptor(TokenAuthenticationEntry.class)) != null) {
                list.add(tokenDescriptor);
            }
            if ((externalAppDescriptor = jenkins.getDescriptor(ExternalAppAuthenticationEntry.class)) != null) {
                list.add(externalAppDescriptor);
            }
            return ImmutableList.copyOf(list);
        }

        public FormValidation doCheckOrchestratorAddress(@QueryParameter String value) {
            if (value.trim().isEmpty()) {
                return FormValidation.error((String)Messages.GenericErrors_MissingOrchestratorAddress());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckParametersFilePath(@QueryParameter String value) {
            if (value.trim().toUpperCase().contains("${JENKINS_HOME}")) {
                return FormValidation.error((String)Messages.GenericErrors_MustUseSlavePaths());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckTimeout(@AncestorInPath Item item, @QueryParameter String value) {
            if (value != null && !value.isEmpty()) {
                try {
                    if (Integer.parseInt(value) < 0) {
                        return FormValidation.error((String)Messages.GenericErrors_InvalidTimeout());
                    }
                }
                catch (NumberFormatException e) {
                    return FormValidation.error((String)Messages.GenericErrors_InvalidTimeout());
                }
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillTraceLevelItems(@AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            ListBoxModel result = new ListBoxModel();
            for (TraceLevel v : TraceLevel.values()) {
                result.add(v.toString(), v.toString());
            }
            return result;
        }
    }
}

