/*
 * Decompiled with CFR 0.152.
 */
package com.uipath.uipathpackage.solutions;

import com.google.common.collect.ImmutableList;
import com.uipath.uipathpackage.entries.SelectEntry;
import com.uipath.uipathpackage.entries.authentication.ExternalAppAuthenticationEntry;
import com.uipath.uipathpackage.entries.authentication.TokenAuthenticationEntry;
import com.uipath.uipathpackage.entries.authentication.UserPassAuthenticationEntry;
import com.uipath.uipathpackage.models.solutions.SolutionDeployOptions;
import com.uipath.uipathpackage.util.CliDetails;
import com.uipath.uipathpackage.util.TaskScopedEnvVarsManager;
import com.uipath.uipathpackage.util.TraceLevel;
import com.uipath.uipathpackage.util.Utility;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.slaves.WorkspaceList;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class UiPathSolutionDeploy
extends Recorder
implements SimpleBuildStep {
    private final String packageName;
    private final String packageVersion;
    private final String deploymentName;
    private final String deploymentFolderName;
    private String deploymentParentFolder;
    private String configPath;
    private final SelectEntry credentials;
    private final TraceLevel traceLevel;
    private final String orchestratorAddress;
    private final String orchestratorTenant;

    @DataBoundConstructor
    public UiPathSolutionDeploy(String packageName, String packageVersion, String deploymentName, String deploymentFolderName, SelectEntry credentials, TraceLevel traceLevel, String orchestratorAddress, String orchestratorTenant) {
        this.packageName = packageName;
        this.packageVersion = packageVersion;
        this.deploymentName = deploymentName;
        this.deploymentFolderName = deploymentFolderName;
        this.credentials = credentials;
        this.traceLevel = traceLevel;
        this.orchestratorAddress = orchestratorAddress;
        this.orchestratorTenant = orchestratorTenant;
    }

    @DataBoundSetter
    public void setDeploymentParentFolder(String deploymentParentFolder) {
        this.deploymentParentFolder = deploymentParentFolder;
    }

    @DataBoundSetter
    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getPackageVersion() {
        return this.packageVersion;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public String getDeploymentFolderName() {
        return this.deploymentFolderName;
    }

    public String getDeploymentParentFolder() {
        return this.deploymentParentFolder;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public SelectEntry getCredentials() {
        return this.credentials;
    }

    public TraceLevel getTraceLevel() {
        return this.traceLevel;
    }

    public String getOrchestratorAddress() {
        return this.orchestratorAddress;
    }

    public String getOrchestratorTenant() {
        return this.orchestratorTenant;
    }

    public void perform(Run<?, ?> run, FilePath workspace, EnvVars env, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        this.validateParameters();
        PrintStream logger = listener.getLogger();
        FilePath tempRemoteDir = WorkspaceList.tempDir((FilePath)workspace);
        if (tempRemoteDir == null) {
            throw new AbortException("Failed to create temp folder for solution deploy.");
        }
        tempRemoteDir.mkdirs();
        Utility util = new Utility();
        try {
            EnvVars envVars = TaskScopedEnvVarsManager.addRequiredEnvironmentVariables(run, env, listener);
            util.validateRuntime(launcher, envVars);
            CliDetails cliDetails = util.getCliDetails(run, listener, envVars, launcher);
            String buildTag = (String)envVars.get((Object)"BUILD_TAG");
            FilePath expandedConfigPath = null;
            if (this.configPath != null && !this.configPath.trim().isEmpty()) {
                String raw = envVars.expand(this.configPath.trim());
                expandedConfigPath = raw.contains("${WORKSPACE}") ? new FilePath(launcher.getChannel(), raw) : workspace.child(raw);
            }
            SolutionDeployOptions options = new SolutionDeployOptions();
            if (cliDetails.getActualVersion().supportsNewTelemetry()) {
                options.populateAdditionalTelemetryData();
                options.setPipelineCorrelationId(buildTag);
                options.setCliGetFlow(cliDetails.getGetFlow());
            }
            options.setPackageName(envVars.expand(this.packageName));
            options.setPackageVersion(envVars.expand(this.packageVersion));
            options.setDeploymentName(envVars.expand(this.deploymentName));
            options.setDeploymentFolderName(envVars.expand(this.deploymentFolderName));
            if (this.deploymentParentFolder != null && !this.deploymentParentFolder.trim().isEmpty()) {
                options.setDeploymentParentFolder(envVars.expand(this.deploymentParentFolder.trim()));
            }
            if (expandedConfigPath != null) {
                options.setConfigPath(expandedConfigPath.getRemote());
            }
            util.setCredentialsFromCredentialsEntry(this.credentials, options, run);
            options.setTraceLevel(this.traceLevel);
            options.setOrchestratorUrl(this.orchestratorAddress);
            options.setOrchestratorTenant(this.orchestratorTenant);
            String language = Locale.getDefault().getLanguage();
            String country = Locale.getDefault().getCountry();
            String localization = country.isEmpty() ? language : language + "-" + country;
            options.setLanguage(localization);
            int exitCode = util.execute("SolutionDeployOptions", options, tempRemoteDir, listener, envVars, launcher, true);
            if (exitCode != 0) {
                throw new AbortException("UiPath CLI solution deploy failed with exit code: " + exitCode);
            }
            logger.println("Solution deployment completed successfully.");
        }
        catch (URISyntaxException e) {
            e.printStackTrace(logger);
            throw new AbortException(e.getMessage());
        }
        finally {
            try {
                if (tempRemoteDir != null) {
                    tempRemoteDir.deleteRecursive();
                }
            }
            catch (Exception e) {
                logger.println("Failed to delete temp folder after solution deploy: " + e.getMessage());
            }
        }
    }

    private void validateParameters() throws AbortException {
        Utility util = new Utility();
        util.validateParams(this.packageName, "Invalid package name");
        util.validateParams(this.packageVersion, "Invalid package version");
        util.validateParams(this.deploymentName, "Invalid deployment name");
        util.validateParams(this.deploymentFolderName, "Invalid deployment folder name");
        util.validateParams(this.orchestratorAddress, "Invalid orchestrator address");
        util.validateParams(this.orchestratorTenant, "Invalid orchestrator tenant");
        if (this.credentials == null) {
            throw new InvalidParameterException("Invalid credentials type");
        }
    }

    @Symbol(value={"UiPathSolutionDeploy"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "UiPath Solution: Deploy";
        }

        public FormValidation doCheckPackageName(@QueryParameter String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.error((String)"Package name is required.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPackageVersion(@QueryParameter String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.error((String)"Package version is required.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckDeploymentName(@QueryParameter String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.error((String)"Deployment name is required.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckDeploymentFolderName(@QueryParameter String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.error((String)"Solution deployment folder name is required.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckOrchestratorAddress(@QueryParameter String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.error((String)"Orchestrator address is required.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckOrchestratorTenant(@QueryParameter String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.error((String)"Orchestrator tenant is required.");
            }
            return FormValidation.ok();
        }

        public List<Descriptor> getAuthenticationDescriptors() {
            Descriptor external;
            Descriptor token;
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            if (jenkins == null) {
                return new ArrayList<Descriptor>();
            }
            ArrayList<Descriptor> list = new ArrayList<Descriptor>();
            Descriptor userPass = jenkins.getDescriptor(UserPassAuthenticationEntry.class);
            if (userPass != null) {
                list.add(userPass);
            }
            if ((token = jenkins.getDescriptor(TokenAuthenticationEntry.class)) != null) {
                list.add(token);
            }
            if ((external = jenkins.getDescriptor(ExternalAppAuthenticationEntry.class)) != null) {
                list.add(external);
            }
            return ImmutableList.copyOf(list);
        }

        public ListBoxModel doFillTraceLevelItems(@AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            ListBoxModel result = new ListBoxModel();
            for (TraceLevel v : TraceLevel.values()) {
                result.add(v.toString(), v.toString());
            }
            return result;
        }
    }
}

