/*
 * Decompiled with CFR 0.152.
 */
package com.uipath.uipathpackage.models;

import com.uipath.uipathpackage.models.AuthenticatedOptions;
import com.uipath.uipathpackage.models.LocalizationOptions;
import com.uipath.uipathpackage.models.SerializableCliOptions;
import com.uipath.uipathpackage.models.TelemetryOptions;
import com.uipath.uipathpackage.util.CliGetFlow;
import com.uipath.uipathpackage.util.TraceLevel;
import hudson.PluginWrapper;
import jenkins.model.Jenkins;
import org.jenkinsci.main.modules.instance_identity.InstanceIdentity;

public class CommonOptions
implements AuthenticatedOptions,
LocalizationOptions,
TelemetryOptions,
SerializableCliOptions {
    private String username;
    private String password;
    private String accountName;
    private String refreshToken;
    private String authorizationUrl;
    private String accountForApp;
    private String applicationId;
    private String applicationSecret;
    private String applicationScope;
    private String organizationUnit;
    private String orchestratorUrl;
    private String orchestratorTenant;
    private TraceLevel traceLevel;
    private String language;
    private String pipelineCorrelationId;
    private String extensionClientOrganizationId;
    private String telemetryOriginVersion;
    private String cliGetFlow;

    @Override
    public void populateAdditionalTelemetryData() {
        this.telemetryOriginVersion = this.getPluginVersion();
        this.extensionClientOrganizationId = this.getInstanceIdentity();
    }

    private String getInstanceIdentity() {
        return InstanceIdentity.get().getEncodedPublicKey();
    }

    @Override
    public String getTelemetryOriginVersion() {
        return this.telemetryOriginVersion;
    }

    private String getPluginVersion() {
        Jenkins jenkinsInstance = Jenkins.get();
        PluginWrapper pluginWrapper = jenkinsInstance.getPluginManager().getPlugin("uipath-automation-package");
        return pluginWrapper != null ? pluginWrapper.getVersion() : "";
    }

    @Override
    public String getPipelineCorrelationId() {
        return this.pipelineCorrelationId;
    }

    @Override
    public void setPipelineCorrelationId(String buildTag) {
        this.pipelineCorrelationId = this.getInstanceIdentity() + buildTag;
    }

    @Override
    public String getExtensionClientOrganizationId() {
        return this.extensionClientOrganizationId;
    }

    @Override
    public String getTelemetryOrigin() {
        return "Jenkins";
    }

    @Override
    public String getCliGetFlow() {
        return this.cliGetFlow;
    }

    @Override
    public void setCliGetFlow(CliGetFlow cliGetFlow) {
        this.cliGetFlow = cliGetFlow.toString();
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public void setLanguage(String language) {
        this.language = language;
    }

    @Override
    public String getAccountName() {
        return this.accountName;
    }

    @Override
    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    @Override
    public String getAccountForApp() {
        return this.accountForApp;
    }

    @Override
    public void setAccountForApp(String accountForApp) {
        this.accountForApp = accountForApp;
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    @Override
    public String getApplicationSecret() {
        return this.applicationSecret;
    }

    @Override
    public void setApplicationSecret(String applicationSecret) {
        this.applicationSecret = applicationSecret;
    }

    @Override
    public String getApplicationScope() {
        return this.applicationScope;
    }

    @Override
    public void setApplicationScope(String applicationScope) {
        this.applicationScope = applicationScope;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getRefreshToken() {
        return this.refreshToken;
    }

    @Override
    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    @Override
    public String getOrchestratorUrl() {
        return this.orchestratorUrl;
    }

    @Override
    public void setOrchestratorUrl(String orchestratorUrl) {
        this.orchestratorUrl = orchestratorUrl;
    }

    @Override
    public String getOrchestratorTenant() {
        return this.orchestratorTenant;
    }

    @Override
    public void setOrchestratorTenant(String orchestratorTenant) {
        this.orchestratorTenant = orchestratorTenant;
    }

    @Override
    public String getOrganizationUnit() {
        return this.organizationUnit;
    }

    @Override
    public void setOrganizationUnit(String organizationUnit) {
        this.organizationUnit = organizationUnit;
    }

    @Override
    public TraceLevel getTraceLevel() {
        return this.traceLevel;
    }

    @Override
    public void setTraceLevel(TraceLevel traceLevel) {
        this.traceLevel = traceLevel;
    }

    @Override
    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    @Override
    public void setAuthorizationUrl(String authorizationUrl) {
        this.authorizationUrl = authorizationUrl;
    }
}

