/*
 * Decompiled with CFR 0.152.
 */
package com.uipath.uipathpackage.entries.authentication;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.uipath.uipathpackage.Messages;
import com.uipath.uipathpackage.entries.SelectEntry;
import com.uipath.uipathpackage.util.Utility;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.Collections;
import javax.annotation.Nonnull;
import org.acegisecurity.Authentication;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class UserPassAuthenticationEntry
extends SelectEntry {
    private final String credentialsId;
    private static int numberOfItems = 0;

    @DataBoundConstructor
    public UserPassAuthenticationEntry(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @Override
    public boolean validateParameters() {
        Utility util = new Utility();
        util.validateParams(this.credentialsId, "Invalid username-password credentials");
        return true;
    }

    @Symbol(value={"UserPass"})
    @Extension
    public static class DescriptorImpl
    extends Descriptor<SelectEntry> {
        @Nonnull
        public String getDisplayName() {
            return Messages.UserPassAuthenticationEntry_DisplayName();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            ListBoxModel result = CredentialsProvider.listCredentials(StandardUsernamePasswordCredentials.class, (Item)item, (Authentication)ACL.SYSTEM, Collections.emptyList(), (CredentialsMatcher)CredentialsMatchers.always());
            numberOfItems = result.size();
            return result;
        }

        public FormValidation doCheckCredentialsId(@AncestorInPath Item item, @QueryParameter String value) {
            if (numberOfItems != 0 && item != null && value != null && value.trim().isEmpty()) {
                return FormValidation.ok();
            }
            if (value == null || CredentialsProvider.listCredentials(StandardUsernamePasswordCredentials.class, (Item)item, (Authentication)ACL.SYSTEM, Collections.emptyList(), (CredentialsMatcher)CredentialsMatchers.withId((String)value)).isEmpty()) {
                return FormValidation.error((String)Messages.GenericErrors_MissingCredentialSet());
            }
            return FormValidation.ok();
        }
    }
}

