/*
 * Decompiled with CFR 0.152.
 */
package com.uipath.uipathpackage.entries.authentication;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.uipath.uipathpackage.Messages;
import com.uipath.uipathpackage.entries.SelectEntry;
import com.uipath.uipathpackage.util.Utility;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.Collections;
import javax.annotation.Nonnull;
import org.acegisecurity.Authentication;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class TokenAuthenticationEntry
extends SelectEntry {
    private final String credentialsId;
    private final String accountName;

    @DataBoundConstructor
    public TokenAuthenticationEntry(String credentialsId, String accountName) {
        this.credentialsId = credentialsId;
        this.accountName = accountName;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @Override
    public boolean validateParameters() {
        Utility util = new Utility();
        util.validateParams(this.credentialsId, "Invalid token credentials");
        return true;
    }

    @Symbol(value={"Token"})
    @Extension
    public static class DescriptorImpl
    extends Descriptor<SelectEntry> {
        @Nonnull
        public String getDisplayName() {
            return Messages.TokenAuthenticationEntry_DisplayName();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            return CredentialsProvider.listCredentials(StringCredentials.class, (Item)item, (Authentication)ACL.SYSTEM, Collections.emptyList(), (CredentialsMatcher)CredentialsMatchers.always());
        }

        public FormValidation doCheckCredentialsId(@AncestorInPath Item item, @QueryParameter String value) {
            if (CredentialsProvider.listCredentials(StringCredentials.class, (Item)item, (Authentication)ACL.SYSTEM, Collections.emptyList(), (CredentialsMatcher)CredentialsMatchers.withId((String)value)).isEmpty()) {
                return FormValidation.error((String)Messages.GenericErrors_MissingCredentialSecret());
            }
            return FormValidation.ok();
        }
    }
}

