/*
 * Decompiled with CFR 0.152.
 */
package com.uipath.uipathpackage.configuration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.uipath.uipathpackage.actions.AddEnvironmentVariablesAction;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Run;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public final class UiPathCliConfiguration {
    private static UiPathCliConfiguration INSTANCE = null;
    public static final String WIN_PLATFORM = "Windows";
    public static final String SELECTED_CLI_VERSION_KEY = "SELECTED_CLI_VERSION_KEY";
    public static final String DEFAULT_CLI_VERSION_KEY = "UiPath.CLI.Version";
    private final String INSTALL_PLATFORM_CONFIGURATION_KEY = "UiPath.CLI.InstallPlatform.Configuration";
    private final String INSTALL_PLATFORM_CONFIGURATION_COUNT_KEY = "UiPath.CLI.InstallPlatform.Configuration.Count";
    private static final String FEED_URL_TEMPLATE = "https://uipath.pkgs.visualstudio.com/Public.Feeds/_packaging/UiPath-Official/nuget/v3/flat2/UiPath.CLI.%s/%s/UiPath.CLI.%s.%s.nupkg";
    private static final Map<String, CliPlatform> PLATFORM_MAP;
    private final Map<String, Configuration> cliConfigurationMap;
    private final int configurationCount;

    private UiPathCliConfiguration() throws JsonProcessingException {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("config");
        this.configurationCount = Integer.parseInt(resourceBundle.getString("UiPath.CLI.InstallPlatform.Configuration.Count"));
        this.cliConfigurationMap = this.initializeConfigurationMap(resourceBundle);
    }

    public static synchronized UiPathCliConfiguration getInstance() throws JsonProcessingException {
        if (INSTANCE == null) {
            INSTANCE = new UiPathCliConfiguration();
        }
        return INSTANCE;
    }

    public Map<String, Configuration> getConfiguration() {
        HashMap<String, Configuration> configuration = new HashMap<String, Configuration>();
        this.cliConfigurationMap.forEach((versionKey, cliConfig) -> configuration.put((String)versionKey, cliConfig.clone()));
        return configuration;
    }

    public Configuration getConfiguration(String versionKey) {
        return this.cliConfigurationMap.getOrDefault(versionKey, null);
    }

    public int getConfigurationCount() {
        return this.configurationCount;
    }

    public String getDefaultCliVersionKey() {
        return "Windows." + ResourceBundle.getBundle("config").getString(DEFAULT_CLI_VERSION_KEY);
    }

    public String getSelectedOrDefaultCliVersionKey(@Nonnull EnvVars envVars) {
        String selectedCliVersionKey = (String)envVars.get((Object)SELECTED_CLI_VERSION_KEY);
        return StringUtils.isNotBlank((String)selectedCliVersionKey) ? selectedCliVersionKey : this.getDefaultCliVersionKey();
    }

    public void updateSelectedCliVersionKey(@NonNull Run<?, ?> run, @Nonnull String cliVersionKey) throws AbortException {
        Map<String, String> addedEnvVars = Collections.singletonMap(SELECTED_CLI_VERSION_KEY, cliVersionKey);
        AddEnvironmentVariablesAction envAction = (AddEnvironmentVariablesAction)run.getAction(AddEnvironmentVariablesAction.class);
        if (envAction == null) {
            envAction = new AddEnvironmentVariablesAction();
            envAction.setAddedEnvironmentVariables(addedEnvVars);
            run.addAction((Action)envAction);
        } else {
            envAction.setAddedEnvironmentVariables(addedEnvVars);
        }
    }

    public FilePath getCliHomeDirectory(@Nonnull Launcher launcher, @Nonnull EnvVars env) throws IOException, InterruptedException {
        FilePath cliHomeDir = new FilePath(launcher.getChannel(), env.expand("${WORKSPACE}")).child("CLI");
        cliHomeDir.mkdirs();
        return cliHomeDir;
    }

    public FilePath getCliRootCachedDirectoryPath(@Nonnull Launcher launcher, @Nonnull EnvVars env, String cliVersionKey) throws IOException, InterruptedException {
        if (!this.cliConfigurationMap.containsKey(cliVersionKey)) {
            launcher.getListener().getLogger().println("(cacheRootPath) invalid cli configuration might have caused this issue.");
            throw new AbortException("(cacheRootPath) invalid cli configuration might have caused this issue. Version key: " + cliVersionKey);
        }
        Configuration configuration = this.cliConfigurationMap.get(cliVersionKey);
        FilePath cliHomeDir = this.getCliHomeDirectory(launcher, env);
        FilePath cachedRootPath = cliHomeDir.child("cached").child(configuration.getName()).child(configuration.getVersion().getComplete());
        cachedRootPath.mkdirs();
        return cachedRootPath;
    }

    public FilePath getCliRootDownloadsDirectoryPath(@Nonnull Launcher launcher, @Nonnull EnvVars env, String cliVersionKey) throws IOException, InterruptedException {
        if (!this.cliConfigurationMap.containsKey(cliVersionKey)) {
            launcher.getListener().getLogger().println("(downloadsRootPath) invalid cli configuration might have caused this issue.");
            throw new AbortException("(downloadsRootPath) invalid cli configuration might have caused this issue.");
        }
        Configuration configuration = this.cliConfigurationMap.get(cliVersionKey);
        FilePath cliHomeDir = this.getCliHomeDirectory(launcher, env);
        FilePath downloadsRootPath = cliHomeDir.child("downloads").child(configuration.getName()).child(configuration.getVersion().getComplete());
        downloadsRootPath.mkdirs();
        launcher.getListener().getLogger().println("Cli root download directory: " + downloadsRootPath.getRemote());
        return downloadsRootPath;
    }

    public Optional<FilePath> getCliPath(@Nonnull Launcher launcher, @Nonnull EnvVars env, String cliVersionKey) {
        PrintStream logger = launcher.getListener().getLogger();
        try {
            FilePath cliCachedPath = this.getCliRootCachedDirectoryPath(launcher, env, cliVersionKey);
            Configuration configuration = this.cliConfigurationMap.get(cliVersionKey);
            cliCachedPath = configuration.getVersion().getMajor() >= 22 ? cliCachedPath.child("tools").child("uipcli.dll") : cliCachedPath.child("lib").child("net461").child("uipcli.exe");
            if (cliCachedPath.exists()) {
                return Optional.of(cliCachedPath);
            }
        }
        catch (Exception e) {
            e.printStackTrace(logger);
            logger.println("error while location cached cli path " + e.getMessage());
        }
        return Optional.empty();
    }

    public void AddCliConfiguration(String cliVersionKey, Configuration configuration) {
        if (this.cliConfigurationMap.containsKey(cliVersionKey)) {
            return;
        }
        this.cliConfigurationMap.put(cliVersionKey, configuration);
    }

    private Map<String, Configuration> initializeConfigurationMap(@Nonnull ResourceBundle resourceBundle) throws JsonProcessingException {
        String json = resourceBundle.getString("UiPath.CLI.InstallPlatform.Configuration");
        ObjectMapper mapper = new ObjectMapper();
        String[] displayNames = (String[])mapper.readValue(json, (TypeReference)new TypeReference<String[]>(){});
        HashMap<String, Configuration> cliConfigurationMap = new HashMap<String, Configuration>();
        for (String displayName : displayNames) {
            if ("CustomVersion".equals(displayName)) {
                Configuration.Version dummyVersion = new Configuration.Version(0, 0, 0, "CustomVersion");
                Configuration config = new Configuration(displayName, displayName, dummyVersion, false, false, "", "", CliPlatform.Unknown);
                cliConfigurationMap.put(config.getConfigurationUniqueId(), config);
                continue;
            }
            String fullPackageName = "UiPath.CLI." + displayName;
            try {
                Configuration configuration = this.getConfigurationFromPackageName(fullPackageName);
                cliConfigurationMap.put(configuration.getConfigurationUniqueId(), configuration);
            }
            catch (Exception e) {
                throw new JsonProcessingException("Failed to parse configuration for " + displayName, e){};
            }
        }
        return cliConfigurationMap;
    }

    public Configuration getConfigurationFromPackageName(String cliPackageName) throws Exception {
        String packageName;
        if (cliPackageName.endsWith(".nupkg")) {
            String fileName = FilenameUtils.getBaseName((String)cliPackageName);
            packageName = fileName.substring(0, fileName.lastIndexOf(46));
        } else {
            packageName = cliPackageName;
        }
        Pattern packageRegex = Pattern.compile("^UiPath\\.CLI\\.(Windows\\.Legacy|Windows|Linux|Mac)\\.((?:\\d+\\.\\d+\\.\\d+(?:\\.\\d+)*)-(?:\\d+(?:-\\d+)*)|\\d+\\.\\d+\\.\\d+(?:\\.\\d+)*)$");
        Matcher match = packageRegex.matcher(packageName);
        if (!match.matches()) {
            throw new Exception("Invalid CLI package name format: " + cliPackageName + " Extracted package name: " + packageName);
        }
        String platformString = match.group(1);
        String rawVersion = match.group(2);
        CliPlatform platform = PLATFORM_MAP.getOrDefault(platformString, CliPlatform.Unknown);
        Object fullVersion = rawVersion;
        Pattern legacyVersionPattern = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)$");
        Matcher legacyMatch = legacyVersionPattern.matcher(rawVersion);
        if (legacyMatch.matches()) {
            fullVersion = legacyMatch.group(1) + "." + legacyMatch.group(2) + "." + legacyMatch.group(3) + "-" + legacyMatch.group(4);
        }
        boolean windowsCompatible = WIN_PLATFORM.equals(platformString) || "Windows.Legacy".equals(platformString);
        boolean linuxCompatible = "Linux".equals(platformString);
        Pattern versionRegex = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)");
        Matcher versionMatch = versionRegex.matcher((CharSequence)fullVersion);
        if (!versionMatch.find()) {
            throw new Exception("Invalid version format: " + (String)fullVersion);
        }
        int major = Integer.parseInt(versionMatch.group(1));
        int minor = Integer.parseInt(versionMatch.group(2));
        int patch = Integer.parseInt(versionMatch.group(3));
        String feedUrl = String.format(FEED_URL_TEMPLATE, platformString, rawVersion, platformString, rawVersion);
        Configuration.Version version = new Configuration.Version(major, minor, patch, rawVersion);
        String name = "UiPath.CLI." + platformString;
        String displayName = platformString + "." + rawVersion;
        Configuration config = new Configuration(displayName, name, version, windowsCompatible, linuxCompatible, "", feedUrl, platform);
        return config;
    }

    static {
        HashMap<String, CliPlatform> map = new HashMap<String, CliPlatform>();
        map.put("Windows.Legacy", CliPlatform.Windows);
        map.put(WIN_PLATFORM, CliPlatform.Windows);
        map.put("Linux", CliPlatform.Linux);
        map.put("macOS", CliPlatform.macOS);
        PLATFORM_MAP = Collections.unmodifiableMap(map);
    }

    public static final class Configuration
    implements Cloneable,
    Serializable {
        private String displayName;
        private String name;
        private Version version;
        private boolean windowsCompatible;
        private boolean linuxCompatible;
        private String description;
        private String feedUrl;
        private CliPlatform platform;

        public Configuration() {
        }

        public Configuration(String displayName, String name, Version version, boolean windowsCompatible, boolean linuxCompatible, String description, String feedUrl, CliPlatform platform) {
            this.displayName = displayName;
            this.name = name;
            this.version = version;
            this.windowsCompatible = windowsCompatible;
            this.linuxCompatible = linuxCompatible;
            this.description = description;
            this.feedUrl = feedUrl;
            this.platform = platform;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getName() {
            return this.name;
        }

        public Version getVersion() {
            return this.version;
        }

        public boolean getWindowsCompatible() {
            return this.windowsCompatible;
        }

        public boolean getLinuxCompatible() {
            return this.linuxCompatible;
        }

        public String getDescription() {
            return this.description;
        }

        public String getFeedUrl() {
            return this.feedUrl;
        }

        public CliPlatform getPlatform() {
            return this.platform;
        }

        public String getConfigurationUniqueId() {
            return this.getDisplayName();
        }

        protected Configuration clone() {
            Version version = new Version(this.version.major, this.version.minor, this.version.patch, this.version.complete);
            Configuration configuration = new Configuration(this.displayName, this.name, version, this.windowsCompatible, this.linuxCompatible, this.description, this.feedUrl, this.platform);
            return configuration;
        }

        public static final class Version
        implements Cloneable,
        Serializable {
            private int major;
            private int minor;
            private int patch;
            private String complete;

            public Version(int major, int minor, int patch, String complete) {
                this.major = major;
                this.minor = minor;
                this.patch = patch;
                this.complete = complete;
            }

            public Version() {
            }

            public int getMajor() {
                return this.major;
            }

            public int getMinor() {
                return this.minor;
            }

            public int getPatch() {
                return this.patch;
            }

            public String getComplete() {
                return this.complete;
            }

            protected Version clone() {
                Version version = new Version(this.major, this.minor, this.patch, this.complete);
                return version;
            }
        }
    }

    public static enum CliPlatform {
        Unknown,
        Windows,
        Linux,
        macOS;

    }
}

