/*
 * Decompiled with CFR 0.152.
 */
package com.uipath.uipathpackage;

import com.google.common.collect.ImmutableList;
import com.uipath.uipathpackage.Messages;
import com.uipath.uipathpackage.entries.SelectEntry;
import com.uipath.uipathpackage.entries.authentication.ExternalAppAuthenticationEntry;
import com.uipath.uipathpackage.entries.authentication.TokenAuthenticationEntry;
import com.uipath.uipathpackage.entries.authentication.UserPassAuthenticationEntry;
import com.uipath.uipathpackage.entries.job.DynamicallyEntry;
import com.uipath.uipathpackage.entries.job.NonProductionJobTypeEntry;
import com.uipath.uipathpackage.entries.job.RobotEntry;
import com.uipath.uipathpackage.entries.job.TestAutomationJobTypeEntry;
import com.uipath.uipathpackage.entries.job.UnattendedJobTypeEntry;
import com.uipath.uipathpackage.models.JobOptions;
import com.uipath.uipathpackage.util.CliDetails;
import com.uipath.uipathpackage.util.StartProcessDtoJobPriority;
import com.uipath.uipathpackage.util.TaskScopedEnvVarsManager;
import com.uipath.uipathpackage.util.TraceLevel;
import com.uipath.uipathpackage.util.Utility;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.slaves.WorkspaceList;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class UiPathRunJob
extends Recorder
implements SimpleBuildStep {
    private final Utility util = new Utility();
    private String processName;
    private String parametersFilePath;
    private StartProcessDtoJobPriority priority;
    private final SelectEntry jobType;
    private SelectEntry strategy;
    private String resultFilePath;
    private Integer timeout;
    private Boolean failWhenJobFails;
    private Boolean waitForJobCompletion;
    private TraceLevel traceLevel;
    private final String orchestratorAddress;
    private final String orchestratorTenant;
    private final SelectEntry credentials;
    private final String folderName;

    @DataBoundConstructor
    public UiPathRunJob(String processName, String parametersFilePath, StartProcessDtoJobPriority priority, SelectEntry strategy, SelectEntry jobType, String resultFilePath, Integer timeout, Boolean failWhenJobFails, Boolean waitForJobCompletion, TraceLevel traceLevel, String orchestratorAddress, String orchestratorTenant, String folderName, SelectEntry credentials) {
        this.processName = processName;
        this.parametersFilePath = parametersFilePath;
        this.priority = priority;
        this.jobType = jobType;
        this.strategy = strategy;
        this.resultFilePath = resultFilePath;
        this.timeout = timeout;
        this.failWhenJobFails = failWhenJobFails;
        this.waitForJobCompletion = waitForJobCompletion;
        this.traceLevel = traceLevel;
        this.orchestratorAddress = orchestratorAddress;
        this.orchestratorTenant = orchestratorTenant;
        this.credentials = credentials;
        this.folderName = folderName;
    }

    public SelectEntry getJobType() {
        return this.jobType;
    }

    @DataBoundSetter
    public void setStrategy(SelectEntry strategy) {
        this.strategy = strategy;
    }

    public SelectEntry getStrategy() {
        return this.strategy;
    }

    public SelectEntry getCredentials() {
        return this.credentials;
    }

    @DataBoundSetter
    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public String getProcessName() {
        return this.processName;
    }

    @DataBoundSetter
    public void setPriority(StartProcessDtoJobPriority priority) {
        this.priority = priority;
    }

    public StartProcessDtoJobPriority getPriority() {
        return this.priority;
    }

    @DataBoundSetter
    public void setParametersFilePath(String parametersFilePath) {
        this.parametersFilePath = parametersFilePath;
    }

    public String getParametersFilePath() {
        return this.parametersFilePath;
    }

    public String getOrchestratorAddress() {
        return this.orchestratorAddress;
    }

    public String getOrchestratorTenant() {
        return this.orchestratorTenant;
    }

    public String getFolderName() {
        return this.folderName;
    }

    @DataBoundSetter
    public void setFailWhenJobFails(Boolean failWhenJobFails) {
        this.failWhenJobFails = failWhenJobFails;
    }

    public Boolean getFailWhenJobFails() {
        return this.failWhenJobFails;
    }

    @DataBoundSetter
    public void setWaitForJobCompletion(Boolean waitForJobCompletion) {
        this.waitForJobCompletion = waitForJobCompletion;
    }

    public Boolean getWaitForJobCompletion() {
        return this.waitForJobCompletion;
    }

    @DataBoundSetter
    public void setResultFilePath(String resultFilePath) {
        this.resultFilePath = resultFilePath;
    }

    @DataBoundSetter
    public void setTraceLevel(TraceLevel traceLevel) {
        this.traceLevel = traceLevel;
    }

    public TraceLevel getTraceLevel() {
        return this.traceLevel;
    }

    public String getResultFilePath() {
        return this.resultFilePath;
    }

    @DataBoundSetter
    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull EnvVars env, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        this.validateParameters();
        PrintStream logger = listener.getLogger();
        FilePath tempRemoteDir = WorkspaceList.tempDir((FilePath)workspace);
        if (Objects.isNull(tempRemoteDir)) {
            throw new AbortException(Messages.GenericErrors_FailedToCreateTempFolderRunJob());
        }
        tempRemoteDir.mkdirs();
        try {
            EnvVars envVars = TaskScopedEnvVarsManager.addRequiredEnvironmentVariables(run, env, listener);
            this.util.validateRuntime(launcher, envVars);
            CliDetails cliDetails = this.util.getCliDetails(run, listener, envVars, launcher);
            String buildTag = (String)envVars.get((Object)"BUILD_TAG");
            JobOptions jobOptions = new JobOptions();
            if (cliDetails.getActualVersion().supportsNewTelemetry()) {
                jobOptions.populateAdditionalTelemetryData();
                jobOptions.setPipelineCorrelationId(buildTag);
                jobOptions.setCliGetFlow(cliDetails.getGetFlow());
            }
            jobOptions.setProcessName(this.processName);
            if (this.parametersFilePath != null && !this.parametersFilePath.isEmpty()) {
                FilePath parametersPath = this.parametersFilePath.contains("${WORKSPACE}") ? new FilePath(launcher.getChannel(), envVars.expand(this.parametersFilePath)) : workspace.child(envVars.expand(this.parametersFilePath));
                parametersPath.mkdirs();
                jobOptions.setParametersFilePath(parametersPath.getRemote());
            }
            jobOptions.setPriority(this.priority);
            this.util.setJobRunFromStrategyEntry(this.strategy, jobOptions);
            jobOptions.setResultFilePath(this.resultFilePath);
            jobOptions.setTimeout(this.timeout);
            jobOptions.setFailWhenJobFails(this.failWhenJobFails);
            jobOptions.setWaitForJobCompletion(this.waitForJobCompletion);
            jobOptions.setTraceLevel(this.traceLevel);
            jobOptions.setOrchestratorUrl(this.orchestratorAddress);
            jobOptions.setOrganizationUnit(envVars.expand(this.folderName.trim()));
            this.util.setJobRunFromJobTypeEntry(this.jobType, jobOptions);
            ResourceBundle rb = ResourceBundle.getBundle("config");
            String orchestratorTenantFormatted = envVars.expand(this.orchestratorTenant.trim()).isEmpty() ? this.util.getConfigValue(rb, "UiPath.DefaultTenant") : envVars.expand(this.orchestratorTenant.trim());
            jobOptions.setOrchestratorTenant(orchestratorTenantFormatted);
            this.util.setCredentialsFromCredentialsEntry(this.credentials, jobOptions, run);
            String language = Locale.getDefault().getLanguage();
            String country = Locale.getDefault().getCountry();
            String localization = country.isEmpty() ? language : language + "-" + country;
            jobOptions.setLanguage(localization);
            this.util.execute("RunJobOptions", jobOptions, tempRemoteDir, listener, envVars, launcher, true);
        }
        catch (URISyntaxException e) {
            e.printStackTrace(logger);
            throw new AbortException(e.getMessage());
        }
        finally {
            try {
                Objects.requireNonNull(tempRemoteDir).deleteRecursive();
            }
            catch (Exception e) {
                logger.println(Messages.GenericErrors_FailedToDeleteTempRunJob() + e.getMessage());
                e.printStackTrace(logger);
            }
        }
    }

    private void validateParameters() throws AbortException {
        this.util.validateParams(this.processName, Messages.ValidationErrors_InvalidProcess());
        this.util.validateParams(this.orchestratorAddress, Messages.ValidationErrors_InvalidOrchAddress());
        this.util.validateParams(this.folderName, Messages.ValidationErrors_InvalidOrchFolder());
        if (this.credentials == null) {
            throw new InvalidParameterException(Messages.ValidationErrors_InvalidCredentialsType());
        }
        this.credentials.validateParameters();
    }

    @Symbol(value={"UiPathRunJob"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        @Nonnull
        public String getDisplayName() {
            return Messages.UiPathRunJob_DescriptorImpl_DisplayName();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public FormValidation doCheckProcessName(@QueryParameter String value) {
            if (value.trim().isEmpty()) {
                return FormValidation.error((String)Messages.UiPathRunJob_DescriptorImpl_Errors_MissingProcessName());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckParametersFilePath(@QueryParameter String value) {
            if (value.trim().toUpperCase().contains("${JENKINS_HOME}")) {
                return FormValidation.error((String)Messages.GenericErrors_MustUseSlavePaths());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckResultFilePath(@QueryParameter String value) {
            if (value.trim().toUpperCase().contains("${JENKINS_HOME}")) {
                return FormValidation.error((String)Messages.GenericErrors_MustUseSlavePaths());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckOrchestratorAddress(@QueryParameter String value) {
            if (value.trim().isEmpty()) {
                return FormValidation.error((String)Messages.GenericErrors_MissingOrchestratorAddress());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckFolderName(@QueryParameter String value) {
            if (value.trim().isEmpty()) {
                return FormValidation.error((String)Messages.GenericErrors_MissingFolder());
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillPriorityItems(@AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            StartProcessDtoJobPriority[] startProcessDtoJobPriorityArrayList = StartProcessDtoJobPriority.values();
            ListBoxModel result = new ListBoxModel();
            for (StartProcessDtoJobPriority priority : startProcessDtoJobPriorityArrayList) {
                result.add(priority.toString());
            }
            return result;
        }

        public List<Descriptor> getStrategyDescriptors() {
            Descriptor robotDescriptor;
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            if (jenkins == null) {
                return new ArrayList<Descriptor>();
            }
            ArrayList<Descriptor> list = new ArrayList<Descriptor>();
            Descriptor dynamicallyDescriptor = jenkins.getDescriptor(DynamicallyEntry.class);
            if (dynamicallyDescriptor != null) {
                list.add(dynamicallyDescriptor);
            }
            if ((robotDescriptor = jenkins.getDescriptor(RobotEntry.class)) != null) {
                list.add(robotDescriptor);
            }
            return ImmutableList.copyOf(list);
        }

        public List<Descriptor> getJobTypeDescriptors() {
            Descriptor testAutomationDescriptor;
            Descriptor nonProductionDescriptor;
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            if (jenkins == null) {
                return new ArrayList<Descriptor>();
            }
            ArrayList<Descriptor> list = new ArrayList<Descriptor>();
            Descriptor unattendedDescriptor = jenkins.getDescriptor(UnattendedJobTypeEntry.class);
            if (unattendedDescriptor != null) {
                list.add(unattendedDescriptor);
            }
            if ((nonProductionDescriptor = jenkins.getDescriptor(NonProductionJobTypeEntry.class)) != null) {
                list.add(nonProductionDescriptor);
            }
            if ((testAutomationDescriptor = jenkins.getDescriptor(TestAutomationJobTypeEntry.class)) != null) {
                list.add(testAutomationDescriptor);
            }
            return ImmutableList.copyOf(list);
        }

        public List<Descriptor> getAuthenticationDescriptors() {
            Descriptor externalAppDescriptor;
            Descriptor tokenDescriptor;
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            if (jenkins == null) {
                return new ArrayList<Descriptor>();
            }
            ArrayList<Descriptor> list = new ArrayList<Descriptor>();
            Descriptor userPassDescriptor = jenkins.getDescriptor(UserPassAuthenticationEntry.class);
            if (userPassDescriptor != null) {
                list.add(userPassDescriptor);
            }
            if ((tokenDescriptor = jenkins.getDescriptor(TokenAuthenticationEntry.class)) != null) {
                list.add(tokenDescriptor);
            }
            if ((externalAppDescriptor = jenkins.getDescriptor(ExternalAppAuthenticationEntry.class)) != null) {
                list.add(externalAppDescriptor);
            }
            return ImmutableList.copyOf(list);
        }

        public ListBoxModel doFillTraceLevelItems(@AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            ListBoxModel result = new ListBoxModel();
            for (TraceLevel v : TraceLevel.values()) {
                result.add(v.toString(), v.toString());
            }
            return result;
        }
    }
}

