/*
 * Decompiled with CFR 0.152.
 */
package com.uipath.uipathpackage;

import com.google.common.collect.ImmutableList;
import com.uipath.uipathpackage.Messages;
import com.uipath.uipathpackage.entries.SelectEntry;
import com.uipath.uipathpackage.entries.authentication.ExternalAppAuthenticationEntry;
import com.uipath.uipathpackage.entries.authentication.TokenAuthenticationEntry;
import com.uipath.uipathpackage.entries.authentication.UserPassAuthenticationEntry;
import com.uipath.uipathpackage.entries.versioning.AutoVersionEntry;
import com.uipath.uipathpackage.entries.versioning.CurrentVersionEntry;
import com.uipath.uipathpackage.entries.versioning.ManualVersionEntry;
import com.uipath.uipathpackage.models.AnalyzeOptions;
import com.uipath.uipathpackage.models.PackOptions;
import com.uipath.uipathpackage.util.CliDetails;
import com.uipath.uipathpackage.util.OutputType;
import com.uipath.uipathpackage.util.TaskScopedEnvVarsManager;
import com.uipath.uipathpackage.util.TraceLevel;
import com.uipath.uipathpackage.util.Utility;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.slaves.WorkspaceList;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class UiPathPack
extends Builder
implements SimpleBuildStep {
    private final Utility util = new Utility();
    private final SelectEntry version;
    private final String projectJsonPath;
    private final String outputPath;
    private String outputType;
    private Boolean splitOutput;
    private Boolean disableBuiltInNugetFeeds;
    private boolean runWorkflowAnalysis;
    private String repositoryUrl;
    private String repositoryCommit;
    private String repositoryBranch;
    private String repositoryType;
    private String projectUrl;
    private String releaseNotes;
    private boolean useOrchestrator;
    private String orchestratorAddress;
    private String orchestratorTenant;
    private SelectEntry credentials;
    private final TraceLevel traceLevel;
    private String governanceFilePath;

    @DataBoundConstructor
    public UiPathPack(SelectEntry version, String projectJsonPath, String outputPath, TraceLevel traceLevel) {
        this.version = version;
        this.projectJsonPath = projectJsonPath;
        this.outputPath = outputPath;
        this.traceLevel = traceLevel;
        this.outputType = "None";
        this.splitOutput = null;
        this.disableBuiltInNugetFeeds = null;
        this.repositoryUrl = null;
        this.repositoryCommit = null;
        this.repositoryBranch = null;
        this.repositoryType = null;
        this.projectUrl = null;
        this.releaseNotes = null;
        this.orchestratorAddress = "";
        this.orchestratorTenant = "";
        this.credentials = null;
        this.runWorkflowAnalysis = false;
        this.governanceFilePath = null;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull EnvVars env, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        this.validateParameters();
        FilePath tempRemoteDir = WorkspaceList.tempDir((FilePath)workspace);
        if (Objects.isNull(tempRemoteDir)) {
            throw new AbortException(Messages.GenericErrors_FailedToCreateTempFolderPack());
        }
        tempRemoteDir.mkdirs();
        try {
            FilePath expandedWorkspacePath;
            EnvVars envVars = TaskScopedEnvVarsManager.addRequiredEnvironmentVariables(run, env, listener);
            this.util.validateRuntime(launcher, envVars);
            CliDetails cliDetails = this.util.getCliDetails(run, listener, envVars, launcher);
            String buildTag = (String)envVars.get((Object)"BUILD_TAG");
            FilePath expandedOutputPath = this.outputPath.contains("${WORKSPACE}") ? new FilePath(launcher.getChannel(), envVars.expand(this.outputPath)) : workspace.child(envVars.expand(this.outputPath));
            expandedOutputPath.mkdirs();
            FilePath filePath = expandedWorkspacePath = this.projectJsonPath.contains("${WORKSPACE}") ? new FilePath(launcher.getChannel(), envVars.expand(this.projectJsonPath)) : workspace.child(envVars.expand(this.projectJsonPath));
            if (this.runWorkflowAnalysis) {
                AnalyzeOptions analyzeOptions = new AnalyzeOptions();
                if (this.governanceFilePath != null && !this.governanceFilePath.isEmpty()) {
                    FilePath expandedGovernanceFilePath = this.governanceFilePath.contains("${WORKSPACE}") ? new FilePath(launcher.getChannel(), envVars.expand(this.governanceFilePath)) : workspace.child(envVars.expand(this.governanceFilePath));
                    analyzeOptions.setGovernanceFilePath(expandedGovernanceFilePath.getRemote());
                }
                if (this.disableBuiltInNugetFeeds != null && this.disableBuiltInNugetFeeds.booleanValue()) {
                    analyzeOptions.setDisableBuiltInNugetFeeds(true);
                }
                if (cliDetails.getActualVersion().supportsNewTelemetry()) {
                    analyzeOptions.populateAdditionalTelemetryData();
                    analyzeOptions.setPipelineCorrelationId(buildTag);
                    analyzeOptions.setCliGetFlow(cliDetails.getGetFlow());
                }
                analyzeOptions.setProjectPath(expandedWorkspacePath.getRemote());
                if (this.useOrchestrator) {
                    analyzeOptions.setOrchestratorUrl(this.orchestratorAddress);
                    analyzeOptions.setOrchestratorTenant(this.orchestratorTenant);
                    this.util.setCredentialsFromCredentialsEntry(this.credentials, analyzeOptions, run);
                }
                this.util.execute("AnalyzeOptions", analyzeOptions, tempRemoteDir, listener, envVars, launcher, true);
            }
            PackOptions packOptions = new PackOptions();
            if (cliDetails.getActualVersion().supportsNewTelemetry()) {
                packOptions.populateAdditionalTelemetryData();
                packOptions.setPipelineCorrelationId(buildTag);
                packOptions.setCliGetFlow(cliDetails.getGetFlow());
            }
            packOptions.setDestinationFolder(expandedOutputPath.getRemote());
            packOptions.setProjectPath(expandedWorkspacePath.getRemote());
            packOptions.setOutputType(this.outputType);
            if (this.splitOutput != null && this.splitOutput.booleanValue()) {
                packOptions.setSplitOutput(true);
            }
            if (this.disableBuiltInNugetFeeds != null && this.disableBuiltInNugetFeeds.booleanValue()) {
                packOptions.setDisableBuiltInNugetFeeds(true);
            }
            packOptions.setRepositoryUrl(this.repositoryUrl);
            packOptions.setRepositoryCommit(this.repositoryCommit);
            packOptions.setRepositoryBranch(this.repositoryBranch);
            packOptions.setRepositoryType(this.repositoryType);
            packOptions.setProjectUrl(this.projectUrl);
            packOptions.setReleaseNotes(this.releaseNotes);
            if (this.version instanceof ManualVersionEntry) {
                packOptions.setVersion(envVars.expand(((ManualVersionEntry)this.version).getVersion().trim()));
            } else if (this.version instanceof AutoVersionEntry) {
                packOptions.setAutoVersion(true);
            }
            if (this.useOrchestrator) {
                packOptions.setOrchestratorUrl(this.orchestratorAddress);
                packOptions.setOrchestratorTenant(this.orchestratorTenant);
                this.util.setCredentialsFromCredentialsEntry(this.credentials, packOptions, run);
            }
            String language = Locale.getDefault().getLanguage();
            String country = Locale.getDefault().getCountry();
            String localization = country.isEmpty() ? language : language + "-" + country;
            packOptions.setLanguage(localization);
            packOptions.setTraceLevel(this.traceLevel);
            this.util.execute("PackOptions", packOptions, tempRemoteDir, listener, envVars, launcher, true);
        }
        catch (URISyntaxException e) {
            e.printStackTrace(listener.getLogger());
            throw new AbortException(e.getMessage());
        }
        finally {
            try {
                Objects.requireNonNull(tempRemoteDir).deleteRecursive();
            }
            catch (Exception e) {
                listener.getLogger().println(Messages.GenericErrors_FailedToDeleteTempPack() + e.getMessage());
                e.printStackTrace(listener.getLogger());
            }
        }
    }

    @DataBoundSetter
    public void setUseOrchestrator(boolean useOrchestrator) {
        this.useOrchestrator = useOrchestrator;
        if (!useOrchestrator) {
            this.orchestratorAddress = null;
            this.orchestratorTenant = null;
            this.credentials = null;
        }
    }

    @DataBoundSetter
    public void setGovernanceFilePath(String governanceFilePath) {
        this.governanceFilePath = governanceFilePath;
    }

    @DataBoundSetter
    public void setOutputType(String outputType) {
        this.outputType = outputType;
    }

    @DataBoundSetter
    public void setSplitOutput(Boolean splitOutput) {
        this.splitOutput = splitOutput;
    }

    @DataBoundSetter
    public void setDisableBuiltInNugetFeeds(Boolean disableBuiltInNugetFeeds) {
        this.disableBuiltInNugetFeeds = disableBuiltInNugetFeeds;
    }

    @DataBoundSetter
    public void setRunWorkflowAnalysis(boolean runWorkflowAnalysis) {
        this.runWorkflowAnalysis = runWorkflowAnalysis;
    }

    @DataBoundSetter
    public void setRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
    }

    @DataBoundSetter
    public void setRepositoryCommit(String repositoryCommit) {
        this.repositoryCommit = repositoryCommit;
    }

    @DataBoundSetter
    public void setRepositoryBranch(String repositoryBranch) {
        this.repositoryBranch = repositoryBranch;
    }

    @DataBoundSetter
    public void setRepositoryType(String repositoryType) {
        this.repositoryType = repositoryType;
    }

    @DataBoundSetter
    public void setProjectUrl(String projectUrl) {
        this.projectUrl = projectUrl;
    }

    @DataBoundSetter
    public void setReleaseNotes(String releaseNotes) {
        this.releaseNotes = releaseNotes;
    }

    @DataBoundSetter
    public void setOrchestratorAddress(String orchestratorAddress) {
        this.orchestratorAddress = orchestratorAddress;
    }

    @DataBoundSetter
    public void setOrchestratorTenant(String orchestratorTenant) {
        this.orchestratorTenant = orchestratorTenant;
    }

    @DataBoundSetter
    public void setCredentials(SelectEntry credentials) {
        this.credentials = credentials;
    }

    public SelectEntry getVersion() {
        return this.version;
    }

    public String getProjectJsonPath() {
        return this.projectJsonPath;
    }

    public boolean getUseOrchestrator() {
        return this.useOrchestrator;
    }

    public String getOrchestratorAddress() {
        return this.orchestratorAddress;
    }

    public String getOrchestratorTenant() {
        return this.orchestratorTenant;
    }

    public SelectEntry getCredentials() {
        return this.credentials;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public Boolean getSplitOutput() {
        return this.splitOutput;
    }

    public Boolean getDisableBuiltInNugetFeeds() {
        return this.disableBuiltInNugetFeeds;
    }

    public boolean getRunWorkflowAnalysis() {
        return this.runWorkflowAnalysis;
    }

    public String getGovernanceFilePath() {
        return this.governanceFilePath;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public String getRepositoryCommit() {
        return this.repositoryCommit;
    }

    public String getRepositoryBranch() {
        return this.repositoryBranch;
    }

    public String getRepositoryType() {
        return this.repositoryType;
    }

    public String getProjectUrl() {
        return this.projectUrl;
    }

    public String getReleaseNotes() {
        return this.releaseNotes;
    }

    public TraceLevel getTraceLevel() {
        return this.traceLevel;
    }

    private void validateParameters() throws AbortException {
        if (this.version == null) {
            throw new InvalidParameterException(Messages.GenericErrors_MissingVersioningMethod());
        }
        this.util.validateParams(this.projectJsonPath, Messages.ValidationErrors_InvalidProject());
        this.util.validateParams(this.outputPath, Messages.ValidationErrors_InvalidOutputPath());
        if (this.useOrchestrator) {
            this.util.validateParams(this.orchestratorAddress, Messages.ValidationErrors_InvalidOrchAddress());
            if (this.credentials == null) {
                throw new InvalidParameterException(Messages.ValidationErrors_InvalidCredentialsType());
            }
            this.credentials.validateParameters();
        }
        if (this.outputPath.toUpperCase().contains("${JENKINS_HOME}")) {
            throw new AbortException(Messages.ValidationErrors_InvalidPath());
        }
    }

    @Symbol(value={"UiPathPack"})
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public List<Descriptor> getEntryDescriptors() {
            Descriptor currentEntryDescriptor;
            Descriptor manualDescriptor;
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            if (jenkins == null) {
                return new ArrayList<Descriptor>();
            }
            ArrayList<Descriptor> list = new ArrayList<Descriptor>();
            Descriptor autoDescriptor = jenkins.getDescriptor(AutoVersionEntry.class);
            if (autoDescriptor != null) {
                list.add(autoDescriptor);
            }
            if ((manualDescriptor = jenkins.getDescriptor(ManualVersionEntry.class)) != null) {
                list.add(manualDescriptor);
            }
            if ((currentEntryDescriptor = jenkins.getDescriptor(CurrentVersionEntry.class)) != null) {
                list.add(currentEntryDescriptor);
            }
            return ImmutableList.copyOf(list);
        }

        public FormValidation doCheckProjectJsonPath(@QueryParameter String value) {
            if (value.trim().isEmpty()) {
                return FormValidation.error((String)Messages.UiPathPack_DescriptorImpl_Error_MissingProjectJsonPath());
            }
            if (value.trim().toUpperCase().contains("${JENKINS_HOME}")) {
                return FormValidation.error((String)Messages.GenericErrors_MustUseSlavePaths());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckOutputPath(@QueryParameter String value) {
            if (value.trim().isEmpty()) {
                return FormValidation.error((String)Messages.UiPathPack_DescriptorImpl_Error_MissingOutputPath());
            }
            return FormValidation.ok();
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.UiPathPack_DescriptorImpl_DisplayName();
        }

        public ListBoxModel doFillOutputTypeItems(@AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            ListBoxModel result = new ListBoxModel();
            for (Map.Entry v : OutputType.outputTypes.entrySet()) {
                result.add((String)v.getKey(), (String)v.getValue());
            }
            return result;
        }

        public ListBoxModel doFillTraceLevelItems(@AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            ListBoxModel result = new ListBoxModel();
            for (TraceLevel v : TraceLevel.values()) {
                result.add(v.toString(), v.toString());
            }
            return result;
        }

        public List<Descriptor> getAuthenticationDescriptors() {
            Descriptor externalAppDescriptor;
            Descriptor tokenDescriptor;
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            if (jenkins == null) {
                return new ArrayList<Descriptor>();
            }
            ArrayList<Descriptor> list = new ArrayList<Descriptor>();
            Descriptor userPassDescriptor = jenkins.getDescriptor(UserPassAuthenticationEntry.class);
            if (userPassDescriptor != null) {
                list.add(userPassDescriptor);
            }
            if ((tokenDescriptor = jenkins.getDescriptor(TokenAuthenticationEntry.class)) != null) {
                list.add(tokenDescriptor);
            }
            if ((externalAppDescriptor = jenkins.getDescriptor(ExternalAppAuthenticationEntry.class)) != null) {
                list.add(externalAppDescriptor);
            }
            return ImmutableList.copyOf(list);
        }
    }
}

