/*
 * Decompiled with CFR 0.152.
 */
package com.uipath.uipathpackage;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.uipath.uipathpackage.Messages;
import com.uipath.uipathpackage.configuration.UiPathCliConfiguration;
import com.uipath.uipathpackage.util.TaskScopedEnvVarsManager;
import com.uipath.uipathpackage.util.TraceLevel;
import com.uipath.uipathpackage.util.Utility;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class UiPathInstallPlatform
extends Builder
implements SimpleBuildStep {
    private final Utility util = new Utility();
    private String cliVersion = cliConfiguration.getDefaultCliVersionKey();
    private String cliNupkgPath;
    private boolean forceInstall;
    private final TraceLevel traceLevel;
    private static final UiPathCliConfiguration cliConfiguration;

    @DataBoundConstructor
    public UiPathInstallPlatform(String cliNupkgPath, TraceLevel traceLevel) {
        this.cliNupkgPath = cliNupkgPath;
        this.forceInstall = false;
        this.traceLevel = traceLevel;
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull EnvVars env, @NonNull Launcher launcher, @NonNull TaskListener listener) throws AbortException {
        PrintStream logger = listener.getLogger();
        try {
            EnvVars envVars = TaskScopedEnvVarsManager.addRequiredEnvironmentVariables(run, env, listener);
            String scopedVersion = this.cliVersion;
            UiPathCliConfiguration.Configuration versionConfiguration = null;
            FilePath actualCliNupkgPath = null;
            if (scopedVersion.contains("CustomVersion")) {
                if (StringUtils.isBlank((String)this.cliNupkgPath)) {
                    throw new AbortException("CustomVersion is selected, but path to local nupkg is not provided.");
                }
                try {
                    actualCliNupkgPath = this.cliNupkgPath.contains("${WORKSPACE}") ? new FilePath(launcher.getChannel(), envVars.expand(this.cliNupkgPath)) : workspace.child(envVars.expand(this.cliNupkgPath));
                    versionConfiguration = cliConfiguration.getConfigurationFromPackageName(actualCliNupkgPath.getBaseName());
                    scopedVersion = versionConfiguration.getConfigurationUniqueId();
                    cliConfiguration.AddCliConfiguration(scopedVersion, versionConfiguration);
                }
                catch (Exception e) {
                    logger.println("Exception: " + e.getMessage());
                    throw new AbortException("Failed to parse custom CLI version from path: " + this.cliNupkgPath + ". Make sure you didn't change default nupkg name downloaded from feed");
                }
            } else {
                versionConfiguration = cliConfiguration.getConfiguration(scopedVersion);
            }
            logger.println("Validating CLI selected version: " + versionConfiguration.getDisplayName() + "...");
            this.validateCliCompatibility(versionConfiguration, logger, workspace);
            boolean isSelectedCliAlreadyCached = cliConfiguration.getCliPath(launcher, envVars, scopedVersion).isPresent();
            logger.println(isSelectedCliAlreadyCached ? "cli " + scopedVersion + " is already cached.." : "cli " + scopedVersion + " is not found in cache..");
            if (this.forceInstall || !isSelectedCliAlreadyCached) {
                if (this.forceInstall) {
                    logger.println("force installing the cli , any previous cache for version " + scopedVersion + " will be invalidated..");
                }
                FilePath cliRootCacheDirPath = cliConfiguration.getCliRootCachedDirectoryPath(launcher, envVars, scopedVersion);
                if (scopedVersion.equals(cliConfiguration.getDefaultCliVersionKey())) {
                    logger.print("(caching) extracting the pre-packaged cli...");
                    this.util.extractCliApp(cliRootCacheDirPath, listener, envVars);
                } else if (this.cliVersion.contains("CustomVersion") && StringUtils.isNotBlank((String)this.cliNupkgPath)) {
                    if (!actualCliNupkgPath.exists()) {
                        logger.println("CliNupkgPath provided doesn't exists " + actualCliNupkgPath.getRemote());
                        throw new AbortException(Messages.UiPathInstallPlatform_DescriptorImpl_Error_CliNupkgPath());
                    }
                    logger.println("(caching) extracting provided cli-nuget from path " + actualCliNupkgPath.getRemote());
                    actualCliNupkgPath.unzip(cliRootCacheDirPath);
                } else {
                    UiPathCliConfiguration.Configuration configuration = cliConfiguration.getConfiguration().get(scopedVersion);
                    FilePath downloadsRootPath = cliConfiguration.getCliRootDownloadsDirectoryPath(launcher, envVars, scopedVersion);
                    String fileName = configuration.getName().concat(".").concat(configuration.getVersion().getComplete()).concat(".nupkg");
                    FilePath downloadCliPath = downloadsRootPath.child(fileName);
                    this.util.downloadCli(configuration.getFeedUrl(), downloadCliPath, listener);
                    logger.println("(caching) extracting the downloaded cli...");
                    downloadCliPath.unzip(cliRootCacheDirPath);
                }
                logger.println("Finished extraction for UipCLI version: " + scopedVersion);
            }
            cliConfiguration.updateSelectedCliVersionKey(run, scopedVersion);
        }
        catch (Exception e) {
            if (this.traceLevel.equals((Object)TraceLevel.Verbose) || this.traceLevel.equals((Object)TraceLevel.Error)) {
                e.printStackTrace(logger);
            }
            throw new AbortException("unable to install the cli " + e.getMessage());
        }
    }

    private void validateCliCompatibility(UiPathCliConfiguration.Configuration cliSelectedVersion, PrintStream logger, FilePath workspace) throws AbortException {
        Computer computer = workspace.toComputer();
        if (computer == null) {
            throw new AbortException("Unable to determine the operating system of the agent.");
        }
        String osName = null;
        try {
            osName = computer.getSystemProperties().get("os.name").toString().toLowerCase();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        logger.println("Detected OS: " + osName);
        if (osName.contains("win")) {
            if (cliSelectedVersion.getPlatform() != UiPathCliConfiguration.CliPlatform.Windows) {
                throw new AbortException("Selected UiPath CLI version '" + cliSelectedVersion.getDisplayName() + "' cannot be executed on Windows agent.");
            }
        } else if (osName.contains("linux")) {
            if (cliSelectedVersion.getPlatform() != UiPathCliConfiguration.CliPlatform.Linux) {
                throw new AbortException("Selected UiPath CLI version '" + cliSelectedVersion.getDisplayName() + "' cannot be executed on Linux agent.");
            }
        } else {
            throw new AbortException("Running on incompatible operating system");
        }
    }

    @DataBoundSetter
    public void setCliVersion(String cliVersion) {
        this.cliVersion = cliVersion;
    }

    @DataBoundSetter
    public void setCliNupkgPath(String cliNupkgPath) {
        this.cliNupkgPath = cliNupkgPath;
    }

    @DataBoundSetter
    public void setForceInstall(boolean forceInstall) {
        this.forceInstall = forceInstall;
    }

    public String getCliVersion() {
        return this.cliVersion;
    }

    public String getCliNupkgPath() {
        return this.cliNupkgPath;
    }

    public boolean isForceInstall() {
        return this.forceInstall;
    }

    public TraceLevel getTraceLevel() {
        return this.traceLevel;
    }

    static {
        try {
            cliConfiguration = UiPathCliConfiguration.getInstance();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Symbol(value={"UiPathInstallPlatform"})
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.UiPathInstallPlatform_DescriptorImpl_DisplayName();
        }

        public FormValidation doCheckCliNupkgPath(@QueryParameter String value) {
            if (StringUtils.isNotBlank((String)value) && value.trim().toUpperCase().contains("${JENKINS_HOME}")) {
                return FormValidation.error((String)Messages.GenericErrors_MustUseSlavePaths());
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillCliVersionItems(@AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            ListBoxModel result = new ListBoxModel();
            ArrayList<Map.Entry<String, UiPathCliConfiguration.Configuration>> entries = new ArrayList<Map.Entry<String, UiPathCliConfiguration.Configuration>>(cliConfiguration.getConfiguration().entrySet());
            entries.sort(Comparator.comparing(e -> ((UiPathCliConfiguration.Configuration)e.getValue()).getName()).thenComparing(e -> ((UiPathCliConfiguration.Configuration)e.getValue()).getVersion().getComplete(), Comparator.reverseOrder()));
            for (Map.Entry entry : entries) {
                result.add((Object)new ListBoxModel.Option(((UiPathCliConfiguration.Configuration)entry.getValue()).getDisplayName(), (String)entry.getKey()));
            }
            return result;
        }

        public ListBoxModel doFillTraceLevelItems(@AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            ListBoxModel result = new ListBoxModel();
            for (TraceLevel v : TraceLevel.values()) {
                result.add(v.toString(), v.toString());
            }
            return result;
        }
    }
}

