/*
 * Decompiled with CFR 0.152.
 */
package com.uipath.uipathpackage;

import com.google.common.collect.ImmutableList;
import com.uipath.uipathpackage.Messages;
import com.uipath.uipathpackage.entries.SelectEntry;
import com.uipath.uipathpackage.entries.authentication.ExternalAppAuthenticationEntry;
import com.uipath.uipathpackage.entries.authentication.TokenAuthenticationEntry;
import com.uipath.uipathpackage.entries.authentication.UserPassAuthenticationEntry;
import com.uipath.uipathpackage.models.DeployOptions;
import com.uipath.uipathpackage.util.CliDetails;
import com.uipath.uipathpackage.util.TaskScopedEnvVarsManager;
import com.uipath.uipathpackage.util.TraceLevel;
import com.uipath.uipathpackage.util.Utility;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.slaves.WorkspaceList;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class UiPathDeploy
extends Recorder
implements SimpleBuildStep {
    private final Utility util = new Utility();
    private final String packagePath;
    private final String orchestratorAddress;
    private final String orchestratorTenant;
    private final SelectEntry credentials;
    private final String environments;
    private final String folderName;
    private TraceLevel traceLevel;
    private final String entryPointPaths;
    private final boolean createProcess;
    private Boolean ignoreLibraryDeployConflict;
    private String processName;
    private String processNames;

    @DataBoundConstructor
    public UiPathDeploy(String packagePath, String orchestratorAddress, String orchestratorTenant, String folderName, String environments, SelectEntry credentials, TraceLevel traceLevel, String entryPointPaths, boolean createProcess) {
        this.packagePath = packagePath;
        this.orchestratorAddress = orchestratorAddress;
        this.orchestratorTenant = orchestratorTenant;
        this.credentials = credentials;
        this.folderName = folderName;
        this.environments = environments;
        this.traceLevel = traceLevel;
        this.entryPointPaths = entryPointPaths;
        this.createProcess = createProcess;
        this.ignoreLibraryDeployConflict = null;
    }

    public SelectEntry getCredentials() {
        return this.credentials;
    }

    public String getPackagePath() {
        return this.packagePath;
    }

    public String getOrchestratorAddress() {
        return this.orchestratorAddress;
    }

    public String getOrchestratorTenant() {
        return this.orchestratorTenant;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public String getEnvironments() {
        return this.environments;
    }

    public TraceLevel getTraceLevel() {
        return this.traceLevel;
    }

    public String getEntryPointPaths() {
        return this.entryPointPaths == null || this.entryPointPaths.trim().isEmpty() ? "Main.xaml" : this.entryPointPaths;
    }

    public boolean getCreateProcess() {
        return this.createProcess;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull EnvVars env, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        this.validateParameters();
        PrintStream logger = listener.getLogger();
        FilePath tempRemoteDir = WorkspaceList.tempDir((FilePath)workspace);
        if (Objects.isNull(tempRemoteDir)) {
            throw new AbortException(Messages.GenericErrors_FailedToCreateTempFolderDeploy());
        }
        tempRemoteDir.mkdirs();
        try {
            EnvVars envVars = TaskScopedEnvVarsManager.addRequiredEnvironmentVariables(run, env, listener);
            this.util.validateRuntime(launcher, envVars);
            CliDetails cliDetails = this.util.getCliDetails(run, listener, envVars, launcher);
            String buildTag = (String)envVars.get((Object)"BUILD_TAG");
            FilePath expandedPackagePath = this.packagePath.contains("${WORKSPACE}") ? new FilePath(launcher.getChannel(), envVars.expand(this.packagePath)) : workspace.child(envVars.expand(this.packagePath));
            DeployOptions deployOptions = new DeployOptions();
            if (cliDetails.getActualVersion().supportsNewTelemetry()) {
                deployOptions.populateAdditionalTelemetryData();
                deployOptions.setPipelineCorrelationId(buildTag);
                deployOptions.setCliGetFlow(cliDetails.getGetFlow());
            }
            if (this.ignoreLibraryDeployConflict != null && this.ignoreLibraryDeployConflict.booleanValue()) {
                deployOptions.setIgnoreLibraryDeployConflict(this.ignoreLibraryDeployConflict);
            }
            if (this.processName != null && !this.processName.isEmpty()) {
                deployOptions.setProcessName(this.processName);
            }
            if (this.processNames != null && !this.processNames.isEmpty()) {
                FilePath expandedprocessNamesPath = this.processNames.contains("${WORKSPACE}") ? new FilePath(launcher.getChannel(), envVars.expand(this.processNames)) : workspace.child(envVars.expand(this.processNames));
                deployOptions.setProcessNames(expandedprocessNamesPath.getRemote());
            }
            deployOptions.setPackagesPath(expandedPackagePath.getRemote());
            deployOptions.setOrchestratorUrl(this.orchestratorAddress);
            deployOptions.setOrganizationUnit(envVars.expand(this.folderName.trim()));
            ResourceBundle rb = ResourceBundle.getBundle("config");
            String orchestratorTenantFormatted = envVars.expand(this.orchestratorTenant.trim()).isEmpty() ? this.util.getConfigValue(rb, "UiPath.DefaultTenant") : envVars.expand(this.orchestratorTenant.trim());
            deployOptions.setOrchestratorTenant(orchestratorTenantFormatted);
            this.util.setCredentialsFromCredentialsEntry(this.credentials, deployOptions, run);
            String language = Locale.getDefault().getLanguage();
            String country = Locale.getDefault().getCountry();
            String localization = country.isEmpty() ? language : language + "-" + country;
            deployOptions.setLanguage(localization);
            deployOptions.setTraceLevel(this.traceLevel);
            if (this.environments != null && !this.environments.isEmpty()) {
                String[] deploymentEnvironments = envVars.expand(this.environments).split(",");
                deployOptions.setEnvironments(Arrays.asList(deploymentEnvironments));
            } else {
                deployOptions.setEnvironments(new ArrayList<String>());
            }
            if (this.entryPointPaths != null && !this.entryPointPaths.isEmpty()) {
                String[] entryPoints = envVars.expand(this.entryPointPaths).split(",");
                deployOptions.setEntryPointPaths(Arrays.asList(entryPoints));
            } else {
                deployOptions.setEntryPointPaths(new ArrayList<String>());
            }
            deployOptions.setCreateProcess(this.createProcess);
            this.util.execute("DeployOptions", deployOptions, tempRemoteDir, listener, envVars, launcher, true);
        }
        catch (URISyntaxException e) {
            e.printStackTrace(logger);
            throw new AbortException(e.getMessage());
        }
        finally {
            try {
                Objects.requireNonNull(tempRemoteDir).deleteRecursive();
            }
            catch (Exception e) {
                logger.println(Messages.GenericErrors_FailedToDeleteTempDeploy() + e.getMessage());
                e.printStackTrace(logger);
            }
        }
    }

    private void validateParameters() throws AbortException {
        this.util.validateParams(this.packagePath, Messages.ValidationErrors_InvalidPackage());
        this.util.validateParams(this.orchestratorAddress, Messages.ValidationErrors_InvalidOrchAddress());
        this.util.validateParams(this.folderName, Messages.ValidationErrors_InvalidOrchFolder());
        this.util.validateParams(this.getEntryPointPaths(), Messages.ValidationErrors_InvalidEntryPoint());
        if (this.credentials == null) {
            throw new InvalidParameterException(Messages.ValidationErrors_InvalidCredentialsType());
        }
        this.credentials.validateParameters();
        if (this.packagePath.toUpperCase().contains("${JENKINS_HOME}")) {
            throw new AbortException(Messages.ValidationErrors_InvalidPath());
        }
    }

    @DataBoundSetter
    public void setIgnoreLibraryDeployConflict(Boolean ignoreLibraryDeployConflict) {
        this.ignoreLibraryDeployConflict = ignoreLibraryDeployConflict;
    }

    public Boolean getIgnoreLibraryDeployConflict() {
        return this.ignoreLibraryDeployConflict;
    }

    @DataBoundSetter
    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public String getProcessName() {
        return this.processName;
    }

    @DataBoundSetter
    public void setProcessNames(String processNames) {
        this.processNames = processNames;
    }

    public String getProcessNames() {
        return this.processNames;
    }

    @Symbol(value={"UiPathDeploy"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        @Nonnull
        public String getDisplayName() {
            return Messages.UiPathDeploy_DescriptorImpl_DisplayName();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public FormValidation doCheckPackagePath(@QueryParameter String value) {
            if (value.trim().isEmpty()) {
                return FormValidation.error((String)Messages.UiPathDeploy_DescriptorImpl_Errors_MissingPackagePath());
            }
            if (value.trim().toUpperCase().contains("${JENKINS_HOME}")) {
                return FormValidation.error((String)Messages.GenericErrors_MustUseSlavePaths());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckOrchestratorAddress(@QueryParameter String value) {
            if (value.trim().isEmpty()) {
                return FormValidation.error((String)Messages.GenericErrors_MissingOrchestratorAddress());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckFolderName(@QueryParameter String value) {
            if (value.trim().isEmpty()) {
                return FormValidation.error((String)Messages.GenericErrors_MissingFolder());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckEntryPointPaths(@QueryParameter String value) {
            if (value.trim().isEmpty()) {
                return FormValidation.error((String)Messages.GenericErrors_MissingEntryPoint());
            }
            return FormValidation.ok();
        }

        public List<Descriptor> getAuthenticationDescriptors() {
            Descriptor externalAppDescriptor;
            Descriptor tokenDescriptor;
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            if (jenkins == null) {
                return new ArrayList<Descriptor>();
            }
            ArrayList<Descriptor> list = new ArrayList<Descriptor>();
            Descriptor userPassDescriptor = jenkins.getDescriptor(UserPassAuthenticationEntry.class);
            if (userPassDescriptor != null) {
                list.add(userPassDescriptor);
            }
            if ((tokenDescriptor = jenkins.getDescriptor(TokenAuthenticationEntry.class)) != null) {
                list.add(tokenDescriptor);
            }
            if ((externalAppDescriptor = jenkins.getDescriptor(ExternalAppAuthenticationEntry.class)) != null) {
                list.add(externalAppDescriptor);
            }
            return ImmutableList.copyOf(list);
        }

        public ListBoxModel doFillTraceLevelItems(@AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            ListBoxModel result = new ListBoxModel();
            for (TraceLevel v : TraceLevel.values()) {
                result.add(v.toString(), v.toString());
            }
            return result;
        }
    }
}

