/*
 * Decompiled with CFR 0.152.
 */
package com.uipath.uipathpackage;

import com.google.common.collect.ImmutableList;
import com.uipath.uipathpackage.Messages;
import com.uipath.uipathpackage.entries.SelectEntry;
import com.uipath.uipathpackage.entries.assetsAction.DeleteAssetsEntry;
import com.uipath.uipathpackage.entries.assetsAction.DeployAssetsEntry;
import com.uipath.uipathpackage.entries.authentication.ExternalAppAuthenticationEntry;
import com.uipath.uipathpackage.entries.authentication.TokenAuthenticationEntry;
import com.uipath.uipathpackage.entries.authentication.UserPassAuthenticationEntry;
import com.uipath.uipathpackage.models.AssetsOptions;
import com.uipath.uipathpackage.util.CliDetails;
import com.uipath.uipathpackage.util.TaskScopedEnvVarsManager;
import com.uipath.uipathpackage.util.TraceLevel;
import com.uipath.uipathpackage.util.Utility;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.slaves.WorkspaceList;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class UiPathAssets
extends Builder
implements SimpleBuildStep {
    private final Utility util = new Utility();
    private final SelectEntry assetsAction;
    private final String orchestratorAddress;
    private final String orchestratorTenant;
    private final SelectEntry credentials;
    private final String folderName;
    private final String filePath;
    private final TraceLevel traceLevel;

    @DataBoundConstructor
    public UiPathAssets(SelectEntry assetsAction, String orchestratorAddress, String orchestratorTenant, String folderName, SelectEntry credentials, String filePath, TraceLevel traceLevel) {
        this.assetsAction = assetsAction;
        this.orchestratorAddress = orchestratorAddress;
        this.orchestratorTenant = orchestratorTenant;
        this.folderName = folderName;
        this.credentials = credentials;
        this.filePath = filePath;
        this.traceLevel = traceLevel;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull EnvVars env, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        this.validateParameters();
        PrintStream logger = listener.getLogger();
        FilePath tempRemoteDir = WorkspaceList.tempDir((FilePath)workspace);
        if (Objects.isNull(tempRemoteDir)) {
            throw new AbortException(Messages.GenericErrors_FailedToCreateTempFolderAssets());
        }
        tempRemoteDir.mkdirs();
        try {
            EnvVars envVars = TaskScopedEnvVarsManager.addRequiredEnvironmentVariables(run, env, listener);
            this.util.validateRuntime(launcher, envVars);
            CliDetails cliDetails = this.util.getCliDetails(run, listener, envVars, launcher);
            String buildTag = (String)envVars.get((Object)"BUILD_TAG");
            FilePath expandedCsvFilePath = this.filePath.contains("${WORKSPACE}") ? new FilePath(launcher.getChannel(), envVars.expand(this.filePath)) : workspace.child(envVars.expand(this.filePath));
            AssetsOptions assetsOptions = new AssetsOptions();
            if (cliDetails.getActualVersion().supportsNewTelemetry()) {
                assetsOptions.populateAdditionalTelemetryData();
                assetsOptions.setPipelineCorrelationId(buildTag);
                assetsOptions.setCliGetFlow(cliDetails.getGetFlow());
            }
            assetsOptions.setOrchestratorUrl(this.orchestratorAddress);
            String organizationUnit = envVars.expand(this.folderName.trim());
            assetsOptions.setOrganizationUnit(organizationUnit.length() > 0 ? organizationUnit : "Default");
            assetsOptions.setAssetsFile(expandedCsvFilePath.getRemote());
            ResourceBundle rb = ResourceBundle.getBundle("config");
            String orchestratorTenantFormatted = envVars.expand(this.orchestratorTenant.trim()).isEmpty() ? this.util.getConfigValue(rb, "UiPath.DefaultTenant") : envVars.expand(this.orchestratorTenant.trim());
            assetsOptions.setOrchestratorTenant(orchestratorTenantFormatted);
            this.util.setCredentialsFromCredentialsEntry(this.credentials, assetsOptions, run);
            String assetAction = this.assetsAction instanceof DeployAssetsEntry ? "DeployAssetsOptions" : (this.assetsAction instanceof DeleteAssetsEntry ? "DeleteAssetsOptions" : "None");
            String language = Locale.getDefault().getLanguage();
            String country = Locale.getDefault().getCountry();
            String localization = country.isEmpty() ? language : language + "-" + country;
            assetsOptions.setLanguage(localization);
            assetsOptions.setTraceLevel(this.traceLevel);
            if (assetAction.equals("None")) {
                throw new AbortException(Messages.GenericErrors_InvalidAction());
            }
            int result = this.util.execute(assetAction, assetsOptions, tempRemoteDir, listener, envVars, launcher, true);
            if (result != 0) {
                throw new AbortException(Messages.GenericErrors_FailedToRunCommand());
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace(logger);
            throw new AbortException(e.getMessage());
        }
        finally {
            try {
                Objects.requireNonNull(tempRemoteDir).deleteRecursive();
            }
            catch (Exception e) {
                logger.println(Messages.GenericErrors_FailedToDeleteTempAssets() + e.getMessage());
                e.printStackTrace(logger);
            }
        }
    }

    public SelectEntry getAssetsAction() {
        return this.assetsAction;
    }

    public SelectEntry getCredentials() {
        return this.credentials;
    }

    public String getOrchestratorAddress() {
        return this.orchestratorAddress;
    }

    public String getOrchestratorTenant() {
        return this.orchestratorTenant;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public TraceLevel getTraceLevel() {
        return this.traceLevel;
    }

    private void validateParameters() throws AbortException {
        this.util.validateParams(this.filePath, Messages.ValidationErrors_InvalidPackage());
        this.util.validateParams(this.orchestratorAddress, Messages.ValidationErrors_InvalidOrchAddress());
        if (this.credentials == null) {
            throw new InvalidParameterException(Messages.ValidationErrors_InvalidCredentialsType());
        }
        this.credentials.validateParameters();
        if (this.filePath.toUpperCase().contains("${JENKINS_HOME}")) {
            throw new AbortException(Messages.ValidationErrors_InvalidPath());
        }
    }

    @Symbol(value={"UiPathAssets"})
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public List<Descriptor> getEntryDescriptors() {
            Descriptor deleteAssetsDescriptor;
            Jenkins jenkins = Jenkins.getInstance();
            ArrayList<Descriptor> list = new ArrayList<Descriptor>();
            Descriptor deployAssetsDescriptor = jenkins.getDescriptor(DeployAssetsEntry.class);
            if (deployAssetsDescriptor != null) {
                list.add(deployAssetsDescriptor);
            }
            if ((deleteAssetsDescriptor = jenkins.getDescriptor(DeleteAssetsEntry.class)) != null) {
                list.add(deleteAssetsDescriptor);
            }
            return ImmutableList.copyOf(list);
        }

        public FormValidation doCheckFilePath(@QueryParameter String value) {
            if (value.trim().isEmpty()) {
                return FormValidation.error((String)Messages.UiPathAssets_DescriptorImpl_Errors_MissingFilePath());
            }
            if (value.trim().toUpperCase().contains("${JENKINS_HOME}")) {
                return FormValidation.error((String)Messages.GenericErrors_MustUseSlavePaths());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckOrchestratorAddress(@QueryParameter String value) {
            if (value.trim().isEmpty()) {
                return FormValidation.error((String)Messages.GenericErrors_MissingOrchestratorAddress());
            }
            return FormValidation.ok();
        }

        public List<Descriptor> getAuthenticationDescriptors() {
            Descriptor externalAppDescriptor;
            Descriptor tokenDescriptor;
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            if (jenkins == null) {
                return new ArrayList<Descriptor>();
            }
            ArrayList<Descriptor> list = new ArrayList<Descriptor>();
            Descriptor userPassDescriptor = jenkins.getDescriptor(UserPassAuthenticationEntry.class);
            if (userPassDescriptor != null) {
                list.add(userPassDescriptor);
            }
            if ((tokenDescriptor = jenkins.getDescriptor(TokenAuthenticationEntry.class)) != null) {
                list.add(tokenDescriptor);
            }
            if ((externalAppDescriptor = jenkins.getDescriptor(ExternalAppAuthenticationEntry.class)) != null) {
                list.add(externalAppDescriptor);
            }
            return ImmutableList.copyOf(list);
        }

        public ListBoxModel doFillTraceLevelItems(@AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            ListBoxModel result = new ListBoxModel();
            for (TraceLevel v : TraceLevel.values()) {
                result.add(v.toString(), v.toString());
            }
            return result;
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.UiPathAssets_DescriptorImpl_DisplayName();
        }
    }
}

